/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.darkphoenixs.kafka.core.KafkaMessageSender;

public class KafkaMessageNewSender<K, V>
implements KafkaMessageSender<K, V> {
    private final KafkaProducer<K, V> kafkaProducer;
    protected Callback sendCallback = new Callback(){

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                KafkaMessageSender.logger.error("Send message failed.", (Throwable)exception);
            }
        }
    };

    public KafkaMessageNewSender(Properties properties) {
        this.kafkaProducer = new KafkaProducer(properties);
    }

    public List<PartitionInfo> getPartitions(String topic) {
        return this.kafkaProducer.partitionsFor(topic);
    }

    @Override
    public void send(String topic, V value) {
        this.kafkaProducer.send(new ProducerRecord(topic, value), this.sendCallback);
    }

    @Override
    public void sendWithKey(String topic, K key, V value) {
        this.kafkaProducer.send(new ProducerRecord(topic, key, value), this.sendCallback);
    }

    @Override
    public void shutDown() {
        this.kafkaProducer.flush();
        this.kafkaProducer.close();
    }
}

