/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.darkphoenixs.kafka.core.KafkaMessageSender;

public class KafkaMessageSenderImpl<K, V>
implements KafkaMessageSender<K, V> {
    private Producer<K, V> producer;

    public KafkaMessageSenderImpl(Properties props) {
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public void setProducer(Producer<K, V> producer) {
        this.producer = producer;
    }

    @Override
    public void send(String topic, V value) {
        KeyedMessage data = new KeyedMessage(topic, value);
        this.producer.send(data);
    }

    @Override
    public void sendWithKey(String topic, K key, V value) {
        KeyedMessage data = new KeyedMessage(topic, key, value);
        this.producer.send(data);
    }

    @Override
    public void shutDown() {
        this.producer.close();
    }
}

