/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.KeeperException;
import org.darkphoenixs.kafka.core.ZookeeperHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperBrokers {
    public static final Logger logger = LoggerFactory.getLogger(ZookeeperBrokers.class);
    private CuratorFramework _curator;
    private String _zkPath;
    private String _topic;

    public ZookeeperBrokers(ZookeeperHosts zkHosts) {
        this._zkPath = zkHosts.getBrokerZkPath();
        this._topic = zkHosts.getTopic();
        this._curator = CuratorFrameworkFactory.newClient((String)zkHosts.getBrokerZkStr(), (RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 100));
        this._curator.start();
    }

    public ZookeeperBrokers(String zkStr, String zkPath, String topic) {
        this._zkPath = zkPath;
        this._topic = topic;
        this._curator = CuratorFrameworkFactory.newClient((String)zkStr, (RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 100));
        this._curator.start();
    }

    public String getBrokerInfo() {
        String brokerStr = "";
        try {
            int numPartitionsForTopic = this.getNumPartitions();
            String brokerInfoPath = this.brokerPath();
            for (int partition = 0; partition < numPartitionsForTopic; ++partition) {
                int leader = this.getLeaderFor(partition);
                String path = brokerInfoPath + "/" + leader;
                try {
                    byte[] hostPortData = (byte[])this._curator.getData().forPath(path);
                    brokerStr = brokerStr + this.getBrokerHost(hostPortData);
                    if (partition == numPartitionsForTopic - 1) continue;
                    brokerStr = brokerStr + ",";
                    continue;
                }
                catch (KeeperException.NoNodeException e) {
                    logger.error("Node {} does not exist ", (Object)path);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("Read partition info from zookeeper: " + brokerStr);
        return brokerStr;
    }

    public int getNumPartitions() {
        try {
            String topicBrokersPath = this.partitionPath();
            List children = (List)this._curator.getChildren().forPath(topicBrokersPath);
            return children.size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getLeaderFor(long partition) {
        try {
            String topicBrokersPath = this.partitionPath();
            byte[] hostPortData = (byte[])this._curator.getData().forPath(topicBrokersPath + "/" + partition + "/state");
            JSONObject json = JSON.parseObject((String)new String(hostPortData, "UTF-8"));
            Integer leader = json.getInteger("leader");
            return leader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getBrokerHost(byte[] contents) {
        try {
            JSONObject json = JSON.parseObject((String)new String(contents, "UTF-8"));
            String host = json.getString("host");
            Integer port = json.getInteger("port");
            return host + ":" + port;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String partitionPath() {
        return this._zkPath + "/topics/" + this._topic + "/partitions";
    }

    public String brokerPath() {
        return this._zkPath + "/ids";
    }

    public void close() {
        this._curator.close();
    }
}

