/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.pool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.darkphoenixs.kafka.pool.KafkaPoolThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageReceiverMonitor<T> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageReceiverMonitor.class);
    private final int monitorPoolSize = 1;
    private final int monitorPercentage;
    protected final ScheduledExecutorService monitorPool;

    public KafkaMessageReceiverMonitor(String topic, long monitorIntervalTime, int monitorPercentage, BlockingQueue<T> blockingQueue) {
        this.monitorPercentage = monitorPercentage;
        this.monitorPool = Executors.newScheduledThreadPool(1, new KafkaPoolThreadFactory("MonitorThread-" + topic));
        this.monitorPool.scheduleAtFixedRate(new MonitorThread(blockingQueue), 0L, monitorIntervalTime, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        if (this.monitorPool != null) {
            this.monitorPool.shutdown();
            logger.info("Monitor pool closed.");
        }
    }

    class MonitorThread
    implements Runnable {
        public static final String tagger = "MonitorThread";
        private final BlockingQueue<T> blockingQueue;

        public MonitorThread(BlockingQueue<T> blockingQueue) {
            this.blockingQueue = blockingQueue;
        }

        @Override
        public void run() {
            int freeSize;
            int usageSize = this.blockingQueue.size();
            double usageRate = (double)usageSize * 1.0 / ((double)(usageSize + (freeSize = this.blockingQueue.remainingCapacity())) * 1.0) * 100.0;
            if (usageRate > (double)KafkaMessageReceiverMonitor.this.monitorPercentage) {
                logger.warn("BlockingQueue usage rate: {}%. usage size: {}. free size: {}.", new Object[]{usageRate, usageSize, freeSize});
            }
        }
    }
}

