/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.pool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class KafkaPoolThreadFactory
implements ThreadFactory {
    private AtomicInteger i = new AtomicInteger(0);
    private String prefix = "KafkaPool";
    private int priority;
    private boolean daemon;

    public KafkaPoolThreadFactory() {
    }

    public KafkaPoolThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    public KafkaPoolThreadFactory(String prefix, boolean daemon) {
        this.prefix = prefix;
        this.daemon = daemon;
    }

    public KafkaPoolThreadFactory(int priority, boolean daemon) {
        this.priority = priority;
        this.daemon = daemon;
    }

    public KafkaPoolThreadFactory(String prefix, int priority, boolean daemon) {
        this.prefix = prefix;
        this.priority = priority;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        if (this.priority >= 1 && this.priority <= 10) {
            thread.setPriority(this.priority);
        }
        thread.setDaemon(this.daemon);
        thread.setName(this.prefix + "-" + this.i.getAndIncrement());
        return thread;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }
}

