/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.rocketmq.producer;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionExecuter;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.darkphoenixs.mq.codec.MQMessageEncoder;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.producer.MQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducer<T>
implements MQProducer<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private DefaultMQProducer defaultMQProducer;
    private TransactionMQProducer transactionMQProducer;
    private MQMessageEncoder<T> messageEncoder;
    private String topic;
    private String producerKey;
    protected MessageQueueSelector messageQueueSelector = new MessageQueueSelector(){

        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
            int select = Math.abs(arg.hashCode());
            if (select < 0) {
                select = 0;
            }
            return mqs.get(select % mqs.size());
        }
    };

    public TransactionMQProducer getTransactionMQProducer() {
        return this.transactionMQProducer;
    }

    public void setTransactionMQProducer(TransactionMQProducer transactionMQProducer) {
        this.transactionMQProducer = transactionMQProducer;
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    public void setDefaultMQProducer(DefaultMQProducer defaultMQProducer) {
        this.defaultMQProducer = defaultMQProducer;
    }

    public MQMessageEncoder<T> getMessageEncoder() {
        return this.messageEncoder;
    }

    public void setMessageEncoder(MQMessageEncoder<T> messageEncoder) {
        this.messageEncoder = messageEncoder;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public String getProducerKey() {
        if (this.producerKey != null) {
            return this.producerKey;
        }
        return this.topic;
    }

    public void setProducerKey(String producerKey) {
        this.producerKey = producerKey;
    }

    @Override
    public void send(T message) throws MQException {
        if (this.defaultMQProducer == null) {
            throw new MQException("DefaultMQProducer is null !");
        }
        try {
            T obj = this.doSend(message);
            Message msg = new Message(this.topic, this.messageEncoder.encode(obj));
            SendResult sendResult = this.defaultMQProducer.send(msg);
            this.logger.debug("Send Success: " + sendResult + " " + message);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    public void batchSend(List<T> messages) throws MQException {
        if (this.defaultMQProducer == null) {
            throw new MQException("DefaultMQProducer is null !");
        }
        try {
            List<T> objs = this.doSend(messages);
            ArrayList<Message> batchMessage = new ArrayList<Message>();
            for (T t : objs) {
                batchMessage.add(new Message(this.topic, this.messageEncoder.encode(t)));
            }
            SendResult sendResult = this.defaultMQProducer.send(batchMessage);
            this.logger.debug("Send Success: " + sendResult + " " + batchMessage);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    public void sendAsync(T message) throws MQException {
        if (this.defaultMQProducer == null) {
            throw new MQException("DefaultMQProducer is null !");
        }
        try {
            T obj = this.doSend(message);
            final Message msg = new Message(this.topic, this.messageEncoder.encode(obj));
            this.defaultMQProducer.send(msg, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    AbstractProducer.this.logger.debug("Send Success: " + sendResult + " " + msg);
                }

                public void onException(Throwable e) {
                    AbstractProducer.this.logger.error("Async send failed !", e);
                }
            });
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    public void sendOneWay(T message) throws MQException {
        if (this.defaultMQProducer == null) {
            throw new MQException("DefaultMQProducer is null !");
        }
        try {
            T obj = this.doSend(message);
            Message msg = new Message(this.topic, this.messageEncoder.encode(obj));
            this.defaultMQProducer.sendOneway(msg);
            this.logger.debug("Send Success: " + msg);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    public void sendWithKey(String key, T message) throws MQException {
        if (this.defaultMQProducer == null) {
            throw new MQException("DefaultMQProducer is null !");
        }
        try {
            T obj = this.doSend(message);
            Message msg = new Message(this.topic, "", key, this.messageEncoder.encode(obj));
            SendResult sendResult = this.defaultMQProducer.send(msg, this.messageQueueSelector, (Object)key);
            this.logger.debug("Send Success: " + sendResult + " " + msg);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    public void sendWithTag(String key, String tag, T message) throws MQException {
        if (this.defaultMQProducer == null) {
            throw new MQException("DefaultMQProducer is null !");
        }
        try {
            T obj = this.doSend(message);
            Message msg = new Message(this.topic, tag, key, this.messageEncoder.encode(obj));
            SendResult sendResult = this.defaultMQProducer.send(msg, this.messageQueueSelector, (Object)key);
            this.logger.debug("Send Success: " + sendResult + " " + msg);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    public void sendWithTx(T message, LocalTransactionExecuter executer, Object param) throws MQException {
        if (this.transactionMQProducer == null) {
            throw new MQException("TransactionMQProducer is null !");
        }
        try {
            T obj = this.doSend(message);
            Message msg = new Message(this.topic, this.messageEncoder.encode(obj));
            TransactionSendResult sendResult = this.transactionMQProducer.sendMessageInTransaction(msg, executer, param);
            this.logger.debug("Send Success: " + sendResult + " " + msg);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
    }

    protected T doSend(T message) throws MQException {
        return message;
    }

    protected List<T> doSend(List<T> messages) throws MQException {
        return messages;
    }
}

