/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.responsehandlers;

import java.io.IOException;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseHandler;
import org.dmfs.httpessentials.exceptions.ClientErrorException;
import org.dmfs.httpessentials.exceptions.NotFoundException;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.exceptions.ServerErrorException;
import org.dmfs.httpessentials.exceptions.UnauthorizedException;
import org.dmfs.httpessentials.exceptions.UnexpectedStatusException;

public final class FailResponseHandler<T>
implements HttpResponseHandler<T> {
    private static final HttpResponseHandler<?> INSTANCE = new FailResponseHandler();

    public static <V> HttpResponseHandler<V> getInstance() {
        return INSTANCE;
    }

    public T handleResponse(HttpResponse response) throws IOException, ProtocolError, ProtocolException {
        try {
            HttpStatus status = response.status();
            if (status.isClientError()) {
                if (HttpStatus.NOT_FOUND.equals((Object)status)) {
                    throw new NotFoundException(response.responseUri(), String.format("Resource at '%s' not found.", response.responseUri().toASCIIString()));
                }
                if (HttpStatus.UNAUTHORIZED.equals((Object)status)) {
                    throw new UnauthorizedException(String.format("Authentication at '%s' failed.", response.responseUri().toASCIIString()));
                }
                throw new ClientErrorException(status, String.format("'%s' returned a client error: '%d %s'", response.responseUri().toASCIIString(), status.statusCode(), status.reason(), response));
            }
            if (status.isServerError()) {
                throw new ServerErrorException(status, String.format("'%s' returned a server error: '%d %s'", response.responseUri().toASCIIString(), status.statusCode(), status.reason()));
            }
            throw new UnexpectedStatusException(status, String.format("Unexpected status code '%d %s' returned from '%s'", status.statusCode(), status.reason(), response.responseUri().toASCIIString()));
        }
        catch (Throwable throwable) {
            response.responseEntity().contentStream().close();
            throw throwable;
        }
    }
}

