/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.util.Collection;
import java.util.Objects;
import java.util.Properties;

public interface ExecutionEnvironment {
    public String getProfileName();

    public Collection<SystemPackageEntry> getSystemPackages();

    public Properties getProfileProperties();

    public String getCompilerSourceLevelDefault();

    public String getCompilerTargetLevelDefault();

    public boolean isCompatibleCompilerTargetLevel(String var1);

    public static final class SystemPackageEntry {
        public final String packageName;
        public final String version;

        public SystemPackageEntry(String packageName, String version) {
            this.packageName = packageName;
            this.version = version;
        }

        public String toPackageSpecifier() {
            if (this.version != null) {
                return this.packageName + ";version=\"" + this.version + "\"";
            }
            return this.packageName;
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.version);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof SystemPackageEntry)) return false;
            SystemPackageEntry other = (SystemPackageEntry)o;
            if (!Objects.equals(this.packageName, other.packageName)) return false;
            if (!Objects.equals(this.version, other.version)) return false;
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.packageName + "/" + this.version + "]";
        }
    }
}

