/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.mustangproject.FileAttachment;
import org.mustangproject.Item;
import org.mustangproject.Product;
import org.mustangproject.SchemedID;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.PostalTradeAddress;
import org.mustangproject.ZUGFeRD.ZUGFeRDInvoiceImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZUGFeRDImporter
extends ZUGFeRDInvoiceImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDImporter.class);

    public ZUGFeRDImporter() {
    }

    public ZUGFeRDImporter(String filename) {
        super(filename);
    }

    public ZUGFeRDImporter(InputStream stream) {
        super(stream);
    }

    @Override
    public List<FileAttachment> getFileAttachmentsPDF() {
        return this.PDFAttachments;
    }

    public String getForeignReference() {
        return this.importedInvoice.getNumber();
    }

    public String getZUGFeRDProfil() {
        String guideline = this.extractString("//*[local-name() = 'GuidelineSpecifiedDocumentContextParameter']//*[local-name() = 'ID']");
        if (guideline.contains("xrechnung")) {
            return "XRECHNUNG";
        }
        switch (guideline) {
            case "urn:cen.eu:en16931:2017": 
            case "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort": {
                return "COMFORT";
            }
            case "urn:cen.eu:en16931:2017#compliant#urn:factur-x.eu:1p0:basic": 
            case "urn:ferd:CrossIndustryDocument:invoice:1p0:basic": {
                return "BASIC";
            }
            case "urn:factur-x.eu:1p0:basicwl": {
                return "BASIC WL";
            }
            case "urn:factur-x.eu:1p0:minimum": {
                return "MINIMUM";
            }
            case "urn:ferd:CrossIndustryDocument:invoice:1p0:extended": 
            case "urn:cen.eu:en16931:2017#conformant#urn:factur-x.eu:1p0:extended": {
                return "EXTENDED";
            }
        }
        return "";
    }

    public String getIssuerAssignedID() {
        return this.extractIssuerAssignedID("BuyerOrderReferencedDocument");
    }

    public String getSellerOrderReferencedDocumentIssuerAssignedID() {
        return this.extractIssuerAssignedID("SellerOrderReferencedDocument");
    }

    public String getContractOrderReferencedDocumentIssuerAssignedID() {
        return this.extractIssuerAssignedID("ContractReferencedDocument");
    }

    public String getTaxBasisTotalAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'TaxBasisTotalAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'TaxBasisTotalAmount']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getTaxTotalAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'TaxTotalAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'TaxTotalAmount']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRoundingAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'RoundingAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'RoundingAmount']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getPaidAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'TotalPrepaidAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'TotalPrepaidAmount']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getSellerTradePartyGlobalID() {
        return this.extractString("//*[local-name() = 'SellerTradeParty']//*[local-name() = 'GlobalID']");
    }

    public String getBuyerTradePartyGlobalID() {
        return this.extractString("//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'GlobalID']");
    }

    public String getBuyertradePartySpecifiedTaxRegistrationID() {
        String id = null;
        if (this.importedInvoice.getRecipient() != null && this.importedInvoice.getRecipient().getLegalOrganisation() != null) {
            id = this.importedInvoice.getRecipient().getLegalOrganisation().getSchemedID().getID();
        }
        if (id == null) {
            id = this.getBuyerTradePartyID();
        }
        return id;
    }

    public String getIncludedNote() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'HeaderExchangedDocument']//*[local-name() = 'IncludedNote']");
            }
            return this.extractString("//*[local-name() = 'ExchangedDocument']//*[local-name() = 'IncludedNote']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getBuyerTradePartyName() {
        return this.importedInvoice.getRecipient().getName();
    }

    public String getDeliveryTradePartyName() {
        return this.importedInvoice.getDeliveryAddress().getName();
    }

    public String getLineTotalAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'LineTotalAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'LineTotalAmount']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getPaymentTerms() {
        return this.importedInvoice.getPaymentTermDescription();
    }

    public String getTaxPointDate() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'ActualDeliverySupplyChainEvent']//*[local-name() = 'OccurrenceDateTime']//*[local-name() = 'DateTimeString']");
            }
            return this.extractString("//*[local-name() = 'ActualDeliverySupplyChainEvent']//*[local-name() = 'OccurrenceDateTime']//*[local-name() = 'DateTimeString']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getInvoiceID() {
        return this.importedInvoice.getNumber();
    }

    public String getDocumentCode() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'HeaderExchangedDocument']/*[local-name() = 'TypeCode']");
            }
            return this.extractString("//*[local-name() = 'ExchangedDocument']/*[local-name() = 'TypeCode']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getReference() {
        return this.importedInvoice.getReferenceNumber();
    }

    public String getBIC() {
        return this.extractString("//*[local-name() = 'PayeeSpecifiedCreditorFinancialInstitution']/*[local-name() = 'BICID']");
    }

    public String getBankName() {
        return this.extractString("//*[local-name() = 'PayeeSpecifiedCreditorFinancialInstitution']/*[local-name() = 'Name']");
    }

    public String getIBAN() {
        if (this.importedInvoice == null || this.importedInvoice.getTradeSettlement() == null) {
            return null;
        }
        for (IZUGFeRDTradeSettlement settlement : this.importedInvoice.getTradeSettlement()) {
            if (settlement instanceof IZUGFeRDTradeSettlementDebit) {
                return ((IZUGFeRDTradeSettlementDebit)settlement).getIBAN();
            }
            if (!(settlement instanceof IZUGFeRDTradeSettlementPayment)) continue;
            return ((IZUGFeRDTradeSettlementPayment)settlement).getOwnIBAN();
        }
        return null;
    }

    public String getHolder() {
        return this.extractString("//*[local-name() = 'SellerTradeParty']/*[local-name() = 'Name']");
    }

    public String getAmount() {
        return this.importedInvoice.getGrandTotal().toPlainString();
    }

    public String getDueDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(this.importedInvoice.getDueDate());
    }

    public String getInvoiceCurrencyCode() {
        return this.importedInvoice.getCurrency();
    }

    private String extractIssuerAssignedID(String propertyName) {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = '" + propertyName + "']//*[local-name() = 'ID']");
            }
            return this.extractString("//*[local-name() = '" + propertyName + "']//*[local-name() = 'IssuerAssignedID']");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getBuyerTradePartyID() {
        String id = this.importedInvoice.getRecipient().getID();
        if (id == null) {
            id = this.importedInvoice.getRecipient().getVATID();
        }
        return id;
    }

    public String getIssueDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(this.importedInvoice.getIssueDate());
    }

    public Date getDetailedDeliveryPeriodFrom() {
        return this.importedInvoice.getDetailedDeliveryPeriodFrom();
    }

    public Date getDetailedDeliveryPeriodTo() {
        return this.importedInvoice.getDetailedDeliveryPeriodTo();
    }

    public HashMap<String, byte[]> getAdditionalData() {
        return this.additionalXMLs;
    }

    public String getXMP() {
        return this.xmpString;
    }

    public boolean containsMeta() {
        return this.containsMeta;
    }

    public void setMeta(String meta) throws IOException {
        this.setRawXML(meta.getBytes());
    }

    public String getMeta() {
        if (this.rawXML == null) {
            return null;
        }
        return new String(this.rawXML);
    }

    public int getVersion() throws Exception {
        if (!this.containsMeta) {
            throw new Exception("Not yet parsed");
        }
        if (this.version != null) {
            return this.version;
        }
        String head = this.getUTF8();
        if (head.contains("<rsm:CrossIndustryDocument") || head.contains("<CrossIndustryDocument") || head.contains("<SCRDMCCBDACIDAMessageStructure") || head.contains("<rsm:SCRDMCCBDACIOMessageStructure")) {
            this.version = 1;
        } else if (head.contains("<rsm:CrossIndustryInvoice")) {
            this.version = 2;
        } else {
            throw new Exception("ZUGFeRD version could not be determined");
        }
        return this.version;
    }

    public byte[] getRawXML() {
        return this.rawXML;
    }

    public boolean canParse() {
        String meta = this.getMeta();
        return meta != null && meta.length() > 0 && (meta.contains("SpecifiedExchangedDocumentContext") || meta.contains("ExchangedDocumentContext"));
    }

    public PostalTradeAddress getBuyerTradePartyAddress() {
        NodeList nl = null;
        try {
            nl = this.getVersion() == 1 ? this.getNodeListByPath("//*[localname() = 'CrossIndustryDocument']//*[local-name() = 'SpecifiedSupplyChainTradeTransaction']/*[local-name() = 'ApplicableSupplyChainTradeAgreement']//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'PostalTradeAddress']") : this.getNodeListByPath("//*[local-name() = 'CrossIndustryInvoice']//*[local-name() = 'SupplyChainTradeTransaction']//*[local-name() = 'ApplicableHeaderTradeAgreement']//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'PostalTradeAddress']");
        }
        catch (Exception e) {
            return null;
        }
        return this.getAddressFromNodeList(nl);
    }

    public PostalTradeAddress getSellerTradePartyAddress() {
        NodeList nl = null;
        try {
            nl = this.getVersion() == 1 ? this.getNodeListByPath("//*[local-name() = 'CrossIndustryDocument']//*[local-name() = 'SpecifiedSupplyChainTradeTransaction']//*[local-name() = 'ApplicableSupplyChainTradeAgreement']//*[local-name() = 'SellerTradeParty']//*[local-name() = 'PostalTradeAddress']") : this.getNodeListByPath("//*[local-name() = 'CrossIndustryInvoice']//*[local-name() = 'SupplyChainTradeTransaction']//*[local-name() = 'ApplicableHeaderTradeAgreement']//*[local-name() = 'SellerTradeParty']//*[local-name() = 'PostalTradeAddress']");
        }
        catch (Exception e) {
            return null;
        }
        return this.getAddressFromNodeList(nl);
    }

    public PostalTradeAddress getDeliveryTradePartyAddress() {
        NodeList nl;
        try {
            nl = this.getVersion() == 1 ? this.getNodeListByPath("//*[local-name() = 'CrossIndustryDocument']//*[local-name() = 'SpecifiedSupplyChainTradeTransaction']//*[local-name() = 'ApplicableSupplyChainTradeDelivery']//*[local-name() = 'ShipToTradeParty']//*[local-name() = 'PostalTradeAddress']") : this.getNodeListByPath("//*[local-name() = 'CrossIndustryInvoice']//*[local-name() = 'SupplyChainTradeTransaction']//*[local-name() = 'ApplicableHeaderTradeDelivery']//*[local-name() = 'ShipToTradeParty']//*[local-name() = 'PostalTradeAddress']");
        }
        catch (Exception e) {
            return null;
        }
        return this.getAddressFromNodeList(nl);
    }

    private PostalTradeAddress getAddressFromNodeList(NodeList nl) {
        PostalTradeAddress address = new PostalTradeAddress();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                NodeList nodes = n.getChildNodes();
                block19: for (int j = 0; j < nodes.getLength(); ++j) {
                    n = nodes.item(j);
                    short nodeType = n.getNodeType();
                    if (nodeType != 1 || n.getLocalName() == null) continue;
                    switch (n.getLocalName()) {
                        case "PostcodeCode": {
                            address.setPostCodeCode("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setPostCodeCode(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "LineOne": {
                            address.setLineOne("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setLineOne(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "LineTwo": {
                            address.setLineTwo("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setLineTwo(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "LineThree": {
                            address.setLineThree("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setLineThree(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "CityName": {
                            address.setCityName("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setCityName(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "CountryID": {
                            address.setCountryID("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setCountryID(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "CountrySubDivisionName": {
                            address.setCountrySubDivisionName("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setCountrySubDivisionName(n.getFirstChild().getNodeValue());
                        }
                    }
                }
            }
        }
        return address;
    }

    @Deprecated
    public List<Item> getLineItemList() {
        List<Node> nodeList = this.getLineItemNodes();
        ArrayList<Item> lineItemList = new ArrayList<Item>();
        for (Node n : nodeList) {
            Item lineItem = new Item(null, null, null);
            lineItem.setProduct(new Product(null, null, null, null));
            NodeList nl = n.getChildNodes();
            block19: for (int i = 0; i < nl.getLength(); ++i) {
                Node nn = nl.item(i);
                Node node = null;
                if (nn.getLocalName() == null) continue;
                switch (nn.getLocalName()) {
                    case "SpecifiedLineTradeAgreement": 
                    case "SpecifiedSupplyChainTradeAgreement": {
                        node = this.getNodeByName(nn.getChildNodes(), "NetPriceProductTradePrice");
                        if (node != null) {
                            Node unitCodeAttribute;
                            NodeList tradeAgreementChildren = node.getChildNodes();
                            node = this.getNodeByName(tradeAgreementChildren, "ChargeAmount");
                            lineItem.setPrice(XMLTools.tryBigDecimal(node));
                            node = this.getNodeByName(tradeAgreementChildren, "BasisQuantity");
                            if (node != null && node.getAttributes() != null && (unitCodeAttribute = node.getAttributes().getNamedItem("unitCode")) != null) {
                                lineItem.getProduct().setUnit(unitCodeAttribute.getNodeValue());
                            }
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "GrossPriceProductTradePrice")) == null) continue block19;
                        node = this.getNodeByName(node.getChildNodes(), "ChargeAmount");
                        lineItem.setGrossPrice(XMLTools.tryBigDecimal(node));
                        continue block19;
                    }
                    case "AssociatedDocumentLineDocument": {
                        node = this.getNodeByName(nn.getChildNodes(), "LineID");
                        lineItem.setId(XMLTools.getNodeValue(node));
                        continue block19;
                    }
                    case "SpecifiedTradeProduct": {
                        node = this.getNodeByName(nn.getChildNodes(), "GlobalID");
                        if (node != null) {
                            SchemedID globalId = new SchemedID().setScheme(node.getAttributes().getNamedItem("schemeID").getNodeValue()).setId(XMLTools.getNodeValue(node));
                            lineItem.getProduct().addGlobalID(globalId);
                        }
                        node = this.getNodeByName(nn.getChildNodes(), "SellerAssignedID");
                        lineItem.getProduct().setSellerAssignedID(XMLTools.getNodeValue(node));
                        node = this.getNodeByName(nn.getChildNodes(), "BuyerAssignedID");
                        lineItem.getProduct().setBuyerAssignedID(XMLTools.getNodeValue(node));
                        node = this.getNodeByName(nn.getChildNodes(), "Name");
                        lineItem.getProduct().setName(XMLTools.getNodeValue(node));
                        node = this.getNodeByName(nn.getChildNodes(), "Description");
                        lineItem.getProduct().setDescription(XMLTools.getNodeValue(node));
                        continue block19;
                    }
                    case "SpecifiedLineTradeDelivery": 
                    case "SpecifiedSupplyChainTradeDelivery": {
                        node = this.getNodeByName(nn.getChildNodes(), "BilledQuantity");
                        lineItem.setQuantity(XMLTools.tryBigDecimal(node));
                        continue block19;
                    }
                    case "SpecifiedLineTradeSettlement": {
                        node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax");
                        if (node != null) {
                            node = this.getNodeByName(node.getChildNodes(), "RateApplicablePercent");
                            lineItem.getProduct().setVATPercent(XMLTools.tryBigDecimal(node));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax")) != null) {
                            node = this.getNodeByName(node.getChildNodes(), "CalculatedAmount");
                            lineItem.setTax(XMLTools.tryBigDecimal(node));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax")) != null && (node = this.getNodeByName(node.getChildNodes(), "CategoryCode")) != null) {
                            lineItem.getProduct().setTaxCategoryCode(XMLTools.getNodeValue(node));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "BillingSpecifiedPeriod")) != null) {
                            Node start = this.getNodeByName(node.getChildNodes(), "StartDateTime");
                            Node dateTimeStart = null;
                            if (start != null) {
                                dateTimeStart = this.getNodeByName(start.getChildNodes(), "DateTimeString");
                            }
                            Node end = this.getNodeByName(node.getChildNodes(), "EndDateTime");
                            Node dateTimeEnd = null;
                            if (end != null) {
                                dateTimeEnd = this.getNodeByName(end.getChildNodes(), "DateTimeString");
                            }
                            lineItem.setDetailedDeliveryPeriod(XMLTools.tryDate(dateTimeStart), XMLTools.tryDate(dateTimeEnd));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "SpecifiedTradeSettlementLineMonetarySummation")) == null) continue block19;
                        node = this.getNodeByName(node.getChildNodes(), "LineTotalAmount");
                        lineItem.setLineTotalAmount(XMLTools.tryBigDecimal(node));
                        continue block19;
                    }
                    case "SpecifiedSupplyChainTradeSettlement": {
                        node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax");
                        if (node != null) {
                            node = this.getNodeByName(node.getChildNodes(), "ApplicablePercent");
                            lineItem.getProduct().setVATPercent(XMLTools.tryBigDecimal(node));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax")) != null) {
                            node = this.getNodeByName(node.getChildNodes(), "CalculatedAmount");
                            lineItem.setTax(XMLTools.tryBigDecimal(node));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "SpecifiedTradeSettlementMonetarySummation")) == null) continue block19;
                        node = this.getNodeByName(node.getChildNodes(), "LineTotalAmount");
                        lineItem.setLineTotalAmount(XMLTools.tryBigDecimal(node));
                    }
                }
            }
            lineItemList.add(lineItem);
        }
        return lineItemList;
    }

    public List<Node> getLineItemNodes() {
        ArrayList<Node> lineItemNodes = new ArrayList<Node>();
        NodeList nl = null;
        try {
            nl = this.getNodeListByPath("//*[local-name() = 'IncludedSupplyChainTradeLineItem']");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            lineItemNodes.add(n);
        }
        return lineItemNodes;
    }

    private Node getNodeByName(NodeList nl, String name) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node;
            if (nl.item(i).getLocalName() != null && nl.item(i).getLocalName().equals(name)) {
                return nl.item(i);
            }
            if (nl.item(i).getChildNodes().getLength() <= 0 || (node = this.getNodeByName(nl.item(i).getChildNodes(), name)) == null) continue;
            return node;
        }
        return null;
    }

    public NodeList getNodeListByPath(String path) {
        XPathFactory xpathFact = XPathFactory.newInstance();
        XPath xPath = xpathFact.newXPath();
        String s = path;
        try {
            XPathExpression xpr = xPath.compile(s);
            return (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            LOGGER.error("Failed to evaluate XPath", (Throwable)e);
            return null;
        }
    }
}

