/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import com.helger.commons.io.stream.StreamHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.mustangproject.ClasspathResolverURIAdapter;
import org.mustangproject.EStandard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ZUGFeRDVisualizer {
    static final ClassLoader CLASS_LOADER = ZUGFeRDVisualizer.class.getClassLoader();
    private static final String RESOURCE_PATH = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRDVisualizer.class);
    private TransformerFactory mFactory = new TransformerFactoryImpl();
    private Templates mXsltXRTemplate = null;
    private Templates mXsltUBLTemplate = null;
    private Templates mXsltCIOTemplate = null;
    private Templates mXsltHTMLTemplate = null;
    private Templates mXsltPDFTemplate = null;
    private Templates mXsltZF1HTMLTemplate = null;

    public ZUGFeRDVisualizer() {
        this.mFactory.setURIResolver(new ClasspathResourceURIResolver());
    }

    private EStandard findOutStandardFromRootNode(InputStream fis) {
        String zf1Signature = "CrossIndustryDocument";
        String zf2Signature = "CrossIndustryInvoice";
        String ublSignature = "Invoice";
        String ublCreditNoteSignature = "CreditNote";
        String cioSignature = "SCRDMCCBDACIOMessageStructure";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(fis));
            Element root = doc.getDocumentElement();
            if (root.getLocalName().equals(zf1Signature)) {
                return EStandard.zugferd;
            }
            if (root.getLocalName().equals(zf2Signature)) {
                return EStandard.facturx;
            }
            if (root.getLocalName().equals(ublSignature)) {
                return EStandard.ubl;
            }
            if (root.getLocalName().equals(ublCreditNoteSignature)) {
                return EStandard.ubl_creditnote;
            }
            if (root.getLocalName().equals(cioSignature)) {
                return EStandard.orderx;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to recognize standard", (Throwable)e);
        }
        return null;
    }

    public String visualize(String xmlFilename, Language lang) throws IOException, TransformerException {
        FileInputStream fis = new FileInputStream(xmlFilename);
        return this.visualize(fis, lang);
    }

    public String visualize(InputStream inputXml, Language lang) throws IOException, TransformerException {
        this.initTemplates(lang);
        String fileContent = new String(IOUtils.toByteArray((InputStream)inputXml), StandardCharsets.UTF_8);
        EStandard thestandard = this.findOutStandardFromRootNode(new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream htmlOutput = new ByteArrayOutputStream();
        ByteArrayInputStream xmlContentStream = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
        if (thestandard == EStandard.zugferd) {
            this.applyZF1XSLT(xmlContentStream, htmlOutput);
            return htmlOutput.toString(StandardCharsets.UTF_8);
        }
        if (thestandard == EStandard.facturx) {
            this.applyZF2XSLT(xmlContentStream, htmlOutput);
        } else if (thestandard == EStandard.ubl) {
            this.applyUBL2XSLT(xmlContentStream, htmlOutput);
        } else if (thestandard == EStandard.ubl_creditnote) {
            this.applyUBLCreditNote2XSLT(xmlContentStream, htmlOutput);
        } else if (thestandard == EStandard.orderx) {
            this.applyCIO2XSLT(xmlContentStream, htmlOutput);
        } else {
            throw new IllegalArgumentException("File does not look like CII or UBL");
        }
        Optional<InputStream> in = this.copyStream(htmlOutput);
        ByteArrayOutputStream htmlOutStream = new ByteArrayOutputStream();
        if (in.isPresent()) {
            this.applyXSLTToHTML(in.get(), htmlOutStream);
        }
        return htmlOutStream.toString(StandardCharsets.UTF_8);
    }

    private Optional<InputStream> copyStream(ByteArrayOutputStream byteArrayOutputStream) {
        PipedInputStream in = new PipedInputStream();
        try {
            PipedOutputStream out = new PipedOutputStream(in);
            new Thread(() -> {
                try {
                    byteArrayOutputStream.writeTo(out);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write to stream", (Throwable)e);
                }
                finally {
                    StreamHelper.close((AutoCloseable)out);
                }
            }).start();
        }
        catch (IOException e1) {
            LOGGER.error("Failed to create HTML", (Throwable)e1);
            return Optional.empty();
        }
        return Optional.of(in);
    }

    private void initTemplates(Language lang) throws TransformerConfigurationException {
        if (this.mXsltXRTemplate == null) {
            this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
        }
        if (this.mXsltHTMLTemplate == null) {
            this.mXsltHTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xrechnung-html." + lang.name().toLowerCase() + ".xsl")));
        }
        if (this.mXsltZF1HTMLTemplate == null) {
            this.mXsltZF1HTMLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ZUGFeRD_1p0_c1p0_s1p0.xslt")));
        }
    }

    protected String toFOP(String xmlFilename) throws IOException, TransformerException {
        FileInputStream fis = new FileInputStream(xmlFilename);
        EStandard theStandard = this.findOutStandardFromRootNode(fis);
        fis = new FileInputStream(xmlFilename);
        return this.toFOP(fis, theStandard);
    }

    protected String toFOP(InputStream is, EStandard theStandard) throws TransformerException, IOException {
        try {
            if (this.mXsltPDFTemplate == null) {
                this.mXsltPDFTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/xr-pdf.xsl")));
            }
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.error("Failed to init XSLT templates", (Throwable)ex);
        }
        ByteArrayOutputStream iaos = new ByteArrayOutputStream();
        if (theStandard == EStandard.facturx) {
            this.applyZF2XSLT(is, iaos);
        } else if (theStandard == EStandard.ubl) {
            this.applyUBL2XSLT(is, iaos);
        } else if (theStandard == EStandard.ubl_creditnote) {
            this.applyUBLCreditNote2XSLT(is, iaos);
        }
        Optional<InputStream> in = this.copyStream(iaos);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (in.isPresent()) {
            this.applyXSLTToPDF(in.get(), baos);
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    public void toPDF(String xmlFilename, String pdfFilename) {
        File XMLinputFile = new File(xmlFilename);
        String result = null;
        try {
            result = this.toFOP(XMLinputFile.getAbsolutePath());
        }
        catch (IOException | TransformerException e) {
            LOGGER.error("Failed to apply FOP", (Throwable)e);
        }
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        DefaultConfiguration cfg = null;
        try {
            cfg = cfgBuilder.build(CLASS_LOADER.getResourceAsStream("fop-config.xconf"));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI(), (ResourceResolver)new ClasspathResolverURIAdapter()).setConfiguration((Configuration)cfg);
        FopFactory fopFactory = builder.build();
        fopFactory.getFontManager().setResourceResolver(ResourceResolverFactory.createInternalResourceResolver((URI)new File(".").toURI(), (ResourceResolver)new ClasspathResolverURIAdapter()));
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.getRendererOptions().put("pdf-a-mode", "PDF/A-3b");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdfFilename));){
            Fop fop = fopFactory.newFop("application/pdf", userAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8)));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (IOException | TransformerException | FOPException e) {
            LOGGER.error("Failed to create PDF", e);
        }
    }

    protected void applyZF2XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        if (this.mXsltXRTemplate == null) {
            this.mXsltXRTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cii-xr.xsl")));
        }
        Transformer transformer = this.mXsltXRTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyCIO2XSLT(InputStream xmlFile, OutputStream htmlOutstream) throws TransformerException {
        if (this.mXsltCIOTemplate == null) {
            this.mXsltCIOTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/cio-xr.xsl")));
        }
        Transformer transformer = this.mXsltCIOTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutstream));
    }

    protected void applyUBL2XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-invoice-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyUBLCreditNote2XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        if (this.mXsltUBLTemplate == null) {
            this.mXsltUBLTemplate = this.mFactory.newTemplates(new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/ubl-creditnote-xr.xsl")));
        }
        Transformer transformer = this.mXsltUBLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyZF1XSLT(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException {
        Transformer transformer = this.mXsltZF1HTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
    }

    protected void applyXSLTToHTML(InputStream xmlFile, OutputStream htmlOutStream) throws TransformerException, IOException {
        Transformer transformer = this.mXsltHTMLTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(htmlOutStream));
        xmlFile.close();
    }

    protected void applyXSLTToPDF(InputStream xmlFile, OutputStream PDFOutstream) throws TransformerException, IOException {
        Transformer transformer = this.mXsltPDFTemplate.newTransformer();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(PDFOutstream));
        xmlFile.close();
    }

    private static class ClasspathResourceURIResolver
    implements URIResolver {
        ClasspathResourceURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) {
            return new StreamSource(CLASS_LOADER.getResourceAsStream("stylesheets/" + href));
        }
    }

    public static enum Language {
        EN,
        FR,
        DE;

    }
}

