/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;

public class LineCalculator {
    protected BigDecimal price;
    protected BigDecimal priceGross;
    protected BigDecimal itemTotalNetAmount;
    protected BigDecimal itemTotalVATAmount;
    protected BigDecimal lineAllowance = BigDecimal.ZERO;
    protected BigDecimal lineCharge = BigDecimal.ZERO;
    protected BigDecimal itemAllowance = BigDecimal.ZERO;
    protected BigDecimal itemCharge = BigDecimal.ZERO;
    protected BigDecimal allowanceItemTotal = BigDecimal.ZERO;

    public LineCalculator(IZUGFeRDExportableItem currentItem) {
        if (currentItem.getItemAllowances() != null) {
            for (IZUGFeRDAllowanceCharge allowance : currentItem.getItemAllowances()) {
                BigDecimal singleAllowance = allowance.getTotalAmount(currentItem);
                this.addItemAllowance(singleAllowance);
                this.addAllowanceItemTotal(singleAllowance);
            }
        }
        if (currentItem.getItemCharges() != null) {
            for (IZUGFeRDAllowanceCharge charge : currentItem.getItemCharges()) {
                IZUGFeRDAllowanceCharge[] singleCharge = charge.getTotalAmount(currentItem);
                this.addItemCharge((BigDecimal)singleCharge);
                this.subtractAllowanceItemTotal((BigDecimal)singleCharge);
            }
        }
        if (currentItem.getItemTotalAllowances() != null) {
            for (IZUGFeRDAllowanceCharge itemTotalAllowance : currentItem.getItemTotalAllowances()) {
                this.addAllowanceItemTotal(itemTotalAllowance.getTotalAmount(currentItem));
            }
        }
        BigDecimal vatPercent = null;
        if (currentItem.getProduct() != null) {
            vatPercent = currentItem.getProduct().getVATPercent();
        }
        if (vatPercent == null) {
            vatPercent = BigDecimal.ZERO;
        }
        BigDecimal multiplicator = vatPercent.divide(BigDecimal.valueOf(100L));
        BigDecimal quantity = BigDecimal.ZERO;
        if (currentItem != null && currentItem.getQuantity() != null) {
            quantity = currentItem.getQuantity();
        }
        this.priceGross = this.price = currentItem.getPrice();
        BigDecimal delta = BigDecimal.ZERO;
        if (currentItem.getProduct() != null) {
            if (currentItem.getProduct().getAllowances() != null) {
                for (IZUGFeRDAllowanceCharge ccaf : currentItem.getProduct().getAllowances()) {
                    delta = delta.subtract(ccaf.getTotalAmount(currentItem));
                }
            }
            if (currentItem.getProduct().getCharges() != null) {
                for (IZUGFeRDAllowanceCharge ccaf : currentItem.getProduct().getCharges()) {
                    delta = delta.subtract(ccaf.getTotalAmount(currentItem));
                }
            }
        }
        this.price = this.price.add(delta);
        BigDecimal basisQuantity = currentItem.getBasisQuantity().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE.setScale(4) : currentItem.getBasisQuantity();
        this.itemTotalNetAmount = quantity.multiply(this.price).divide(basisQuantity, 18, RoundingMode.HALF_UP).add(this.lineCharge).subtract(this.lineAllowance).subtract(this.allowanceItemTotal.setScale(2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
        this.itemTotalVATAmount = this.itemTotalNetAmount.multiply(multiplicator);
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getItemTotalNetAmount() {
        return this.itemTotalNetAmount;
    }

    public BigDecimal getItemTotalVATAmount() {
        return this.itemTotalVATAmount;
    }

    public BigDecimal getItemTotalGrossAmount() {
        return this.itemTotalNetAmount;
    }

    public BigDecimal getPriceGross() {
        return this.priceGross;
    }

    public void addLineAllowance(BigDecimal b) {
        this.lineAllowance = this.lineAllowance.add(b);
    }

    public void addLineCharge(BigDecimal b) {
        this.lineCharge = this.lineCharge.add(b);
    }

    public void addItemAllowance(BigDecimal b) {
        this.itemAllowance = this.itemAllowance.add(b);
    }

    public void addItemCharge(BigDecimal b) {
        this.itemCharge = this.itemCharge.add(b);
    }

    public void addAllowanceItemTotal(BigDecimal b) {
        this.allowanceItemTotal = this.allowanceItemTotal.add(b);
    }

    public void subtractAllowanceItemTotal(BigDecimal b) {
        this.allowanceItemTotal = this.allowanceItemTotal.subtract(b);
    }
}

