/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.trait.SpringDependencyManagementPluginEntry;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;
import org.openrewrite.trait.Trait;

public final class ChangeManagedDependency
extends Recipe {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    private final @Nullable String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    private final @Nullable String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="29.X", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    private final transient Map<Dependency, Dependency> updatedRequested = new HashMap<Dependency, Dependency>();
    private final transient Map<ResolvedDependency, ResolvedDependency> updatedResolved = new HashMap<ResolvedDependency, ResolvedDependency>();

    public String getDisplayName() {
        return "Change Gradle managed dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.oldGroupId, this.oldArtifactId);
    }

    public String getDescription() {
        return "Change a Gradle managed dependency coordinates. The `newGroupId` or `newArtifactId` **MUST** be different from before.\nFor now, only Spring Dependency Management Plugin entries are supported and no other forms of managed dependencies (yet).";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        validated = validated.and(Validated.required((String)"newGroupId", (Object)this.newGroupId).or(Validated.required((String)"newArtifactId", (Object)this.newArtifactId)));
        return validated.and(Validated.test((String)"coordinates", (String)"newGroupId OR newArtifactId must be different from before", (Object)((Object)this), r -> {
            boolean sameGroupId = StringUtils.isBlank((String)r.newGroupId) || Objects.equals(r.oldGroupId, r.newGroupId);
            boolean sameArtifactId = StringUtils.isBlank((String)r.newArtifactId) || Objects.equals(r.oldArtifactId, r.newArtifactId);
            return !sameGroupId || !sameArtifactId;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final DependencyMatcher depMatcher;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeManagedDependency.this.oldGroupId + ":" + ChangeManagedDependency.this.oldArtifactId)).getValue());
            }

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof G.CompilationUnit || sourceFile instanceof K.CompilationUnit;
            }

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                Optional maybeGp;
                J t = (J)super.visit(tree, (Object)ctx);
                if (t instanceof JavaSourceFile && t != tree && (maybeGp = tree.getMarkers().findFirst(GradleProject.class)).isPresent()) {
                    GradleProject gp = (GradleProject)maybeGp.get();
                    t = (J)t.withMarkers(t.getMarkers().setByType((Marker)this.updateGradleModel(gp)));
                }
                return t;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                return new SpringDependencyManagementPluginEntry.Matcher().groupId(ChangeManagedDependency.this.oldGroupId).artifactId(ChangeManagedDependency.this.oldArtifactId).get(this.getCursor()).map(dep -> dep.withGroupArtifactVersion(this.depMatcher, ChangeManagedDependency.this.newGroupId, ChangeManagedDependency.this.newArtifactId, ChangeManagedDependency.this.newVersion, ChangeManagedDependency.this.versionPattern, ChangeManagedDependency.this.metadataFailures, ctx)).map(Trait::getTree).orElse(m);
            }

            private GradleProject updateGradleModel(GradleProject gp) {
                Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
                HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
                boolean anyChanged = false;
                Iterator<GradleDependencyConfiguration> iterator = nameToConfiguration.values().iterator();
                while (iterator.hasNext()) {
                    GradleDependencyConfiguration gdc;
                    GradleDependencyConfiguration newGdc = gdc = iterator.next();
                    newGdc = newGdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> {
                        assert (requested != null);
                        if (this.depMatcher.matches(requested.getGroupId(), requested.getArtifactId())) {
                            requested = ChangeManagedDependency.this.updatedRequested.computeIfAbsent(requested, r -> {
                                GroupArtifactVersion gav = r.getGav();
                                if (ChangeManagedDependency.this.newGroupId != null) {
                                    gav = gav.withGroupId(ChangeManagedDependency.this.newGroupId);
                                }
                                if (ChangeManagedDependency.this.newArtifactId != null) {
                                    gav = gav.withArtifactId(ChangeManagedDependency.this.newArtifactId);
                                }
                                if (gav != r.getGav()) {
                                    r = r.withGav(gav);
                                }
                                return r;
                            });
                        }
                        return requested;
                    }));
                    anyChanged |= (newGdc = newGdc.withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        assert (resolved != null);
                        if (this.depMatcher.matches(resolved.getGroupId(), resolved.getArtifactId())) {
                            resolved = ChangeManagedDependency.this.updatedResolved.computeIfAbsent(resolved, r -> {
                                ResolvedGroupArtifactVersion gav = r.getGav();
                                if (ChangeManagedDependency.this.newGroupId != null) {
                                    gav = gav.withGroupId(ChangeManagedDependency.this.newGroupId);
                                }
                                if (ChangeManagedDependency.this.newArtifactId != null) {
                                    gav = gav.withArtifactId(ChangeManagedDependency.this.newArtifactId);
                                }
                                if (gav != r.getGav()) {
                                    r = r.withGav(gav);
                                }
                                return r;
                            });
                        }
                        return resolved;
                    }))) != gdc;
                    newNameToConfiguration.put(newGdc.getName(), newGdc);
                }
                if (anyChanged) {
                    gp = gp.withNameToConfiguration(newNameToConfiguration);
                }
                return gp;
            }
        });
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public Map<Dependency, Dependency> getUpdatedRequested() {
        return this.updatedRequested;
    }

    @Generated
    public Map<ResolvedDependency, ResolvedDependency> getUpdatedResolved() {
        return this.updatedResolved;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeManagedDependency(metadataFailures=" + this.getMetadataFailures() + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", updatedRequested=" + this.getUpdatedRequested() + ", updatedResolved=" + this.getUpdatedResolved() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeManagedDependency)) {
            return false;
        }
        ChangeManagedDependency other = (ChangeManagedDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeManagedDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    @Generated
    public ChangeManagedDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }
}

