/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.ParseWarning;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.groovy.CompiledGroovySource;
import org.openrewrite.groovy.GroovyParserVisitor;
import org.openrewrite.groovy.ParseWarningCollector;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.slf4j.LoggerFactory;

public class GroovyParser
implements Parser {
    @Nullable
    private final Collection<Path> classpath;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final List<Consumer<CompilerConfiguration>> compilerCustomizers;

    public Stream<SourceFile> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".java";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, null, () -> new ByteArrayInputStream(sourceFile.getBytes(StandardCharsets.UTF_8)), true);
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setTolerance(Integer.MAX_VALUE);
        configuration.setWarningLevel(0);
        configuration.setClasspathList(this.classpath == null ? Collections.emptyList() : this.classpath.stream().flatMap(cp -> {
            try {
                return Stream.of(cp.toFile().toString());
            }
            catch (UnsupportedOperationException e) {
                return Stream.empty();
            }
        }).collect(Collectors.toList()));
        for (Consumer<CompilerConfiguration> compilerCustomizer : this.compilerCustomizers) {
            compilerCustomizer.accept(configuration);
        }
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        return StreamSupport.stream(sources.spliterator(), false).map(input -> {
            ParseWarningCollector errorCollector = new ParseWarningCollector(configuration, this);
            GroovyClassLoader classLoader = new GroovyClassLoader(this.getClass().getClassLoader(), configuration, true);
            SourceUnit unit = new SourceUnit("doesntmatter", (ReaderSource)new InputStreamReaderSource((InputStream)input.getSource(ctx), configuration), configuration, classLoader, (ErrorCollector)errorCollector);
            pctx.getParsingListener().startedParsing(input);
            CompilationUnit compUnit2222 = new CompilationUnit(configuration, null, classLoader, classLoader);
            compUnit2222.addSource(unit);
            compUnit2222.compile(5);
            ModuleNode ast = unit.getAST();
            for (ClassNode aClass : ast.getClasses()) {
                try {
                    StaticTypeCheckingVisitor staticTypeCheckingVisitor = new StaticTypeCheckingVisitor(unit, aClass);
                    staticTypeCheckingVisitor.setCompilationUnit(compUnit2222);
                    staticTypeCheckingVisitor.visitClass(aClass);
                }
                catch (NoClassDefFoundError staticTypeCheckingVisitor) {}
            }
            CompiledGroovySource compiled = new CompiledGroovySource((Parser.Input)input, unit, ast);
            List<ParseWarning> warnings = errorCollector.getWarningMarkers();
            GroovyParserVisitor mappingVisitor = new GroovyParserVisitor(compiled.getInput().getRelativePath(relativeTo), compiled.getInput().getFileAttributes(), compiled.getInput().getSource(ctx), this.typeCache, ctx);
            G.CompilationUnit gcu = mappingVisitor.visit(compiled.getSourceUnit(), compiled.getModule());
            if (warnings.size() > 0) {
                Markers m = gcu.getMarkers();
                for (ParseWarning warning : warnings) {
                    m = m.add((Marker)warning);
                }
                gcu = gcu.withMarkers(m);
            }
            pctx.getParsingListener().parsed(compiled.getInput(), (SourceFile)gcu);
            SourceFile sourceFile = this.requirePrintEqualsInput(gcu, (Parser.Input)input, relativeTo, ctx);
            classLoader.close();
            if (this.logCompilationWarningsAndErrors && (errorCollector.hasErrors() || errorCollector.hasWarnings())) {
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    errorCollector.write(pw, new Janitor());
                    LoggerFactory.getLogger(GroovyParser.class).warn(sw.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return sourceFile;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                classLoader.close();
                            }
                            catch (Throwable compUnit2222) {
                                throwable.addSuppressed(compUnit2222);
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            ctx.getOnError().accept(t);
                            ParseError parseError = ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                            return parseError;
                        }
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (this.logCompilationWarningsAndErrors && (errorCollector.hasErrors() || errorCollector.hasWarnings())) {
                            try (StringWriter sw = new StringWriter();
                                 PrintWriter pw = new PrintWriter(sw);){
                                errorCollector.write(pw, new Janitor());
                                LoggerFactory.getLogger(GroovyParser.class).warn(sw.toString());
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        });
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".groovy") || path.toFile().getName().startsWith("Jenkinsfile");
    }

    public GroovyParser reset() {
        this.typeCache.clear();
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.groovy");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Builder base) {
        return new Builder(base);
    }

    private GroovyParser(@Nullable Collection<Path> classpath, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, List<Consumer<CompilerConfiguration>> compilerCustomizers) {
        this.classpath = classpath;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.compilerCustomizers = compilerCustomizers;
    }

    public static class Builder
    extends Parser.Builder {
        @Nullable
        private Collection<Path> classpath = Collections.emptyList();
        @Nullable
        protected Collection<String> artifactNames = Collections.emptyList();
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors = false;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
        private final List<Consumer<CompilerConfiguration>> compilerCustomizers = new ArrayList<Consumer<CompilerConfiguration>>();

        public Builder() {
            super(G.CompilationUnit.class);
        }

        public Builder(Builder base) {
            super(G.CompilationUnit.class);
            this.classpath = base.classpath;
            this.artifactNames = base.artifactNames;
            this.typeCache = base.typeCache;
            this.logCompilationWarningsAndErrors = base.logCompilationWarningsAndErrors;
            this.styles.addAll(base.styles);
            this.compilerCustomizers.addAll(base.compilerCustomizers);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder classpath(@Nullable Collection<Path> classpath) {
            this.artifactNames = null;
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... artifactNames) {
            this.artifactNames = Arrays.asList(artifactNames);
            this.classpath = null;
            return this;
        }

        public Builder classpathFromResource(ExecutionContext ctx, String ... artifactNamesWithVersions) {
            this.artifactNames = null;
            this.classpath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])artifactNamesWithVersions);
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        @SafeVarargs
        public final Builder compilerCustomizers(Consumer<CompilerConfiguration> ... compilerCustomizers) {
            return this.compilerCustomizers(Arrays.asList(compilerCustomizers));
        }

        public Builder compilerCustomizers(Iterable<Consumer<CompilerConfiguration>> compilerCustomizers) {
            for (Consumer<CompilerConfiguration> compilerCustomizer : compilerCustomizers) {
                this.compilerCustomizers.add(compilerCustomizer);
            }
            return this;
        }

        @Nullable
        private Collection<Path> resolvedClasspath() {
            if (this.artifactNames != null && !this.artifactNames.isEmpty()) {
                this.classpath = JavaParser.dependenciesFromClasspath((String[])this.artifactNames.toArray(new String[0]));
                this.artifactNames = null;
            }
            return this.classpath;
        }

        public GroovyParser build() {
            return new GroovyParser(this.resolvedClasspath(), this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.compilerCustomizers);
        }

        public String getDslName() {
            return "groovy";
        }
    }
}

