/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.internal.template;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.Comment;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.Nullable;

public class Substitutions {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("__p(\\d+)__");
    private final String code;
    private final Object[] parameters;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);

    public String substitute() {
        AtomicInteger index = new AtomicInteger(0);
        return this.propertyPlaceholderHelper.replacePlaceholders(this.code, key -> {
            int i = index.getAndIncrement();
            Object parameter = this.parameters[i];
            return this.substituteSingle(parameter, i);
        });
    }

    private String substituteSingle(Object parameter, int index) {
        if (parameter instanceof Hcl) {
            if (parameter instanceof Expression) {
                return "/*__p" + index + "__*/{}";
            }
            throw new IllegalArgumentException("'" + parameter.getClass().getSimpleName() + "' cannot be a parameter to a template.");
        }
        if (parameter instanceof HclRightPadded) {
            return this.substituteSingle(((HclRightPadded)parameter).getElement(), index);
        }
        if (parameter instanceof HclLeftPadded) {
            return this.substituteSingle(((HclLeftPadded)parameter).getElement(), index);
        }
        return parameter.toString();
    }

    public <H extends Hcl> List<H> unsubstitute(List<H> js) {
        return ListUtils.map(js, this::unsubstitute);
    }

    public <H extends Hcl> H unsubstitute(H j) {
        if (this.parameters.length == 0) {
            return j;
        }
        Hcl unsub = (Hcl)new HclVisitor<Integer>(){

            @Override
            public Hcl visitExpression(Expression expression, Integer integer) {
                Hcl param = this.maybeParameter(expression);
                if (param != null) {
                    return param;
                }
                return super.visitExpression(expression, integer);
            }

            @Nullable
            private Hcl maybeParameter(Hcl h) {
                Integer param = this.parameterIndex(h.getPrefix());
                if (param != null) {
                    Hcl h2 = (Hcl)Substitutions.this.parameters[param];
                    return h2.withPrefix(h2.getPrefix().withWhitespace(h.getPrefix().getWhitespace()));
                }
                return null;
            }

            @Nullable
            private Integer parameterIndex(Space space) {
                for (Comment comment : space.getComments()) {
                    Matcher matcher = PATTERN_COMMENT.matcher(comment.getText());
                    if (!matcher.matches()) continue;
                    return Integer.valueOf(matcher.group(1));
                }
                return null;
            }
        }.visit(j, 0);
        assert (unsub != null);
        return (H)unsub;
    }

    public Substitutions(String code, Object[] parameters) {
        this.code = code;
        this.parameters = parameters;
    }
}

