/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public final class ChangeMethodAccessLevelVisitor<P>
extends JavaIsoVisitor<P> {
    private static final Collection<J.Modifier.Type> EXPLICIT_ACCESS_LEVELS = Arrays.asList(J.Modifier.Type.Public, J.Modifier.Type.Private, J.Modifier.Type.Protected);
    private final MethodMatcher methodMatcher;
    @Nullable
    private final J.Modifier.Type newAccessLevel;

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        J.ClassDeclaration classDecl = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
        if (classDecl == null) {
            return m;
        }
        if (this.methodMatcher.matches(method, classDecl)) {
            J.Modifier.Type currentMethodAccessLevel = ((J.MethodDeclaration)m).getModifiers().stream().map(J.Modifier::getType).filter(EXPLICIT_ACCESS_LEVELS::contains).findAny().orElse(null);
            if (currentMethodAccessLevel == this.newAccessLevel) {
                return m;
            }
            if (EXPLICIT_ACCESS_LEVELS.contains((Object)currentMethodAccessLevel) && EXPLICIT_ACCESS_LEVELS.contains((Object)this.newAccessLevel)) {
                m = ((J.MethodDeclaration)m).withModifiers(ListUtils.map(((J.MethodDeclaration)m).getModifiers(), mod -> mod.getType() == currentMethodAccessLevel ? mod.withType(this.newAccessLevel) : mod));
            } else if (currentMethodAccessLevel == null) {
                J.Modifier mod3 = new J.Modifier(Tree.randomId(), Space.build(" ", Collections.emptyList()), Markers.EMPTY, null, this.newAccessLevel, Collections.emptyList());
                m = ((J.MethodDeclaration)m).withModifiers(ListUtils.concat((Object)mod3, ((J.MethodDeclaration)m).getModifiers()));
                if (method.getModifiers().isEmpty()) {
                    J.TypeParameters typeParams = ((J.MethodDeclaration)m).getPadding().getTypeParameters();
                    if (typeParams == null) {
                        TypeTree returnExpr = ((J.MethodDeclaration)m).getReturnTypeExpression();
                        if (returnExpr == null) {
                            m = ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), ((J.MethodDeclaration)m).getName().getPrefix()));
                            m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(Space.format(" ")));
                        } else {
                            m = ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), returnExpr.getPrefix()));
                            m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)returnExpr.withPrefix(Space.format(" ")));
                        }
                    } else {
                        m = ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), typeParams.getPrefix()));
                        m = ((J.MethodDeclaration)m).getPadding().withTypeParameters(typeParams.withPrefix(Space.format(" ")));
                    }
                } else {
                    m = ((J.MethodDeclaration)m).withModifiers(ListUtils.map(((J.MethodDeclaration)m).getModifiers(), (i, mod2) -> {
                        if (i == 0) {
                            return mod2.withPrefix(method.getModifiers().get(0).getPrefix());
                        }
                        if (i == 1) {
                            return mod2.withPrefix(Space.format(" "));
                        }
                        return mod2;
                    }));
                }
            } else if (this.newAccessLevel == null) {
                ArrayList modifierComments = new ArrayList();
                List modifiers = ListUtils.map(((J.MethodDeclaration)m).getModifiers(), mod -> {
                    if (mod.getType() == currentMethodAccessLevel) {
                        modifierComments.addAll(mod.getComments());
                        return null;
                    }
                    if (!modifierComments.isEmpty()) {
                        J.Modifier nextModifier = (J.Modifier)mod.withComments(ListUtils.concatAll(new ArrayList(modifierComments), mod.getComments()));
                        modifierComments.clear();
                        return nextModifier;
                    }
                    return mod;
                });
                if (!modifierComments.isEmpty()) {
                    m = (J.MethodDeclaration)m.withComments(ListUtils.concatAll(m.getComments(), modifierComments));
                }
                m = this.maybeAutoFormat(m, ((J.MethodDeclaration)m).withModifiers(modifiers), p).withBody(((J.MethodDeclaration)m).getBody());
            }
        }
        return m;
    }

    public ChangeMethodAccessLevelVisitor(MethodMatcher methodMatcher, @Nullable J.Modifier.Type newAccessLevel) {
        this.methodMatcher = methodMatcher;
        this.newAccessLevel = newAccessLevel;
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    @Nullable
    public J.Modifier.Type getNewAccessLevel() {
        return this.newAccessLevel;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodAccessLevelVisitor(methodMatcher=" + this.getMethodMatcher() + ", newAccessLevel=" + (Object)((Object)this.getNewAccessLevel()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodAccessLevelVisitor)) {
            return false;
        }
        ChangeMethodAccessLevelVisitor other = (ChangeMethodAccessLevelVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodMatcher this$methodMatcher = this.getMethodMatcher();
        MethodMatcher other$methodMatcher = other.getMethodMatcher();
        if (this$methodMatcher == null ? other$methodMatcher != null : !this$methodMatcher.equals(other$methodMatcher)) {
            return false;
        }
        J.Modifier.Type this$newAccessLevel = this.getNewAccessLevel();
        J.Modifier.Type other$newAccessLevel = other.getNewAccessLevel();
        return !(this$newAccessLevel == null ? other$newAccessLevel != null : !((Object)((Object)this$newAccessLevel)).equals((Object)other$newAccessLevel));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodAccessLevelVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MethodMatcher $methodMatcher = this.getMethodMatcher();
        result = result * 59 + ($methodMatcher == null ? 43 : $methodMatcher.hashCode());
        J.Modifier.Type $newAccessLevel = this.getNewAccessLevel();
        result = result * 59 + ($newAccessLevel == null ? 43 : ((Object)((Object)$newAccessLevel)).hashCode());
        return result;
    }
}

