/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveImport<P>
extends JavaIsoVisitor<P> {
    private final String type;
    private final String owner;
    private final boolean force;

    public RemoveImport(String type) {
        this(type, false);
    }

    @JsonCreator
    public RemoveImport(String type, boolean force) {
        this.type = type;
        this.owner = type.substring(0, Math.max(0, type.lastIndexOf(46)));
        this.force = force;
    }

    @Nullable
    public J preVisit(J tree, P p) {
        this.stopAfterPreVisit();
        J j = tree;
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            ImportLayoutStyle importLayoutStyle = Optional.ofNullable((ImportLayoutStyle)((SourceFile)cu).getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            boolean typeUsed = false;
            TreeSet<String> otherTypesInPackageUsed = new TreeSet<String>();
            HashSet<String> methodsAndFieldsUsed = new HashSet<String>();
            TreeSet<String> otherMethodsAndFieldsInTypeUsed = new TreeSet<String>();
            HashSet<String> originalImports = new HashSet<String>();
            for (J.Import cuImport : cu.getImports()) {
                if (cuImport.getQualid().getType() == null) continue;
                originalImports.add(((JavaType.FullyQualified)cuImport.getQualid().getType()).getFullyQualifiedName().replace("$", "."));
            }
            for (JavaType.Variable variable : cu.getTypesInUse().getVariables()) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified(variable.getOwner());
                if (fq == null || !TypeUtils.fullyQualifiedNamesAreEqual(fq.getFullyQualifiedName(), this.type) && !TypeUtils.fullyQualifiedNamesAreEqual(fq.getFullyQualifiedName(), this.owner)) continue;
                methodsAndFieldsUsed.add(variable.getName());
            }
            for (JavaType.Method method : cu.getTypesInUse().getUsedMethods()) {
                if (!method.hasFlags(Flag.Static)) continue;
                String declaringType = method.getDeclaringType().getFullyQualifiedName();
                if (TypeUtils.fullyQualifiedNamesAreEqual(declaringType, this.type)) {
                    methodsAndFieldsUsed.add(method.getName());
                    continue;
                }
                if (!declaringType.equals(this.owner)) continue;
                if (method.getName().equals(this.type.substring(this.type.lastIndexOf(46) + 1))) {
                    methodsAndFieldsUsed.add(method.getName());
                    continue;
                }
                otherMethodsAndFieldsInTypeUsed.add(method.getName());
            }
            for (JavaType javaType : cu.getTypesInUse().getTypesInUse()) {
                if (!(javaType instanceof JavaType.FullyQualified)) continue;
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)javaType;
                if (TypeUtils.fullyQualifiedNamesAreEqual(fullyQualified.getFullyQualifiedName(), this.type)) {
                    typeUsed = true;
                    continue;
                }
                if (!TypeUtils.fullyQualifiedNamesAreEqual(fullyQualified.getFullyQualifiedName(), this.owner) && !TypeUtils.fullyQualifiedNamesAreEqual(fullyQualified.getPackageName(), this.owner) || originalImports.contains(fullyQualified.getFullyQualifiedName().replace("$", "."))) continue;
                otherTypesInPackageUsed.add(fullyQualified.getClassName());
            }
            JavaSourceFile c = cu;
            boolean keepImport = !this.force && (typeUsed || !otherTypesInPackageUsed.isEmpty() && this.type.endsWith(".*"));
            AtomicReference spaceForNextImport = new AtomicReference();
            if ((c = c.withImports(ListUtils.flatMap(c.getImports(), import_ -> {
                if (spaceForNextImport.get() != null) {
                    import_ = import_.withPrefix((Space)spaceForNextImport.get());
                    spaceForNextImport.set(null);
                }
                String typeName = import_.getTypeName();
                if (import_.isStatic()) {
                    String imported = import_.getQualid().getSimpleName();
                    if (TypeUtils.fullyQualifiedNamesAreEqual(typeName + "." + imported, this.type) && (this.force || !methodsAndFieldsUsed.contains(imported))) {
                        spaceForNextImport.set(import_.getPrefix());
                        return null;
                    }
                    if ("*".equals(imported) && (TypeUtils.fullyQualifiedNamesAreEqual(typeName, this.type) || TypeUtils.fullyQualifiedNamesAreEqual(typeName + this.type.substring(this.type.lastIndexOf(46)), this.type))) {
                        if (methodsAndFieldsUsed.isEmpty() && otherMethodsAndFieldsInTypeUsed.isEmpty()) {
                            spaceForNextImport.set(import_.getPrefix());
                            return null;
                        }
                        if (!ImportLayoutStyle.isPackageAlwaysFolded(importLayoutStyle.getPackagesToFold(), import_) && methodsAndFieldsUsed.size() + otherMethodsAndFieldsInTypeUsed.size() < importLayoutStyle.getNameCountToUseStarImport()) {
                            methodsAndFieldsUsed.addAll(otherMethodsAndFieldsInTypeUsed);
                            return this.unfoldStarImport((J.Import)import_, (Set<String>)methodsAndFieldsUsed);
                        }
                    } else if (TypeUtils.fullyQualifiedNamesAreEqual(typeName, this.type) && !methodsAndFieldsUsed.contains(imported)) {
                        spaceForNextImport.set(import_.getPrefix());
                        return null;
                    }
                } else {
                    if (!keepImport && TypeUtils.fullyQualifiedNamesAreEqual(typeName, this.type)) {
                        if (import_.getPrefix().isEmpty() || import_.getPrefix().getLastWhitespace().chars().filter(s -> s == 10).count() > 1L) {
                            spaceForNextImport.set(import_.getPrefix());
                        }
                        return null;
                    }
                    if (!keepImport && import_.getPackageName().equals(this.owner) && "*".equals(import_.getClassName()) && !ImportLayoutStyle.isPackageAlwaysFolded(importLayoutStyle.getPackagesToFold(), import_) && otherTypesInPackageUsed.size() < importLayoutStyle.getClassCountToUseStarImport()) {
                        if (otherTypesInPackageUsed.isEmpty()) {
                            spaceForNextImport.set(import_.getPrefix());
                            return null;
                        }
                        return this.unfoldStarImport((J.Import)import_, (Set<String>)otherTypesInPackageUsed);
                    }
                }
                return import_;
            }))) != cu && c.getPackageDeclaration() == null && c.getImports().isEmpty() && c.getPrefix() == Space.EMPTY) {
                this.doAfterVisit(new FormatFirstClassPrefix());
            }
            j = c;
        }
        return j;
    }

    private Object unfoldStarImport(J.Import starImport, Set<String> otherImportsUsed) {
        ArrayList<J.Import> unfoldedImports = new ArrayList<J.Import>(otherImportsUsed.size());
        int i = 0;
        for (String other : otherImportsUsed) {
            J.Import unfolded = starImport.withQualid(starImport.getQualid().withName(starImport.getQualid().getName().withSimpleName(other))).withId(Tree.randomId());
            unfoldedImports.add(i++ == 0 ? unfolded : unfolded.withPrefix(Space.format("\n")));
        }
        return unfoldedImports;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImport)) {
            return false;
        }
        RemoveImport other = (RemoveImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.force != other.force) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.force ? 79 : 97);
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

