/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Statement;

final class PatternVariables {
    private static final String DEFAULT_LABEL = "!";

    PatternVariables() {
    }

    @Nullable
    static String simplifiedPatternVariableCondition(Expression condition, @Nullable J toReplace) {
        ResultCollector resultCollector = new ResultCollector();
        PatternVariables.simplifiedPatternVariableCondition0(condition, toReplace, resultCollector);
        return resultCollector.instanceOfFound ? resultCollector.builder.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean simplifiedPatternVariableCondition0(J expr, @Nullable J toReplace, ResultCollector collector) {
        if (expr == toReplace) {
            collector.builder.append('\u00a7');
            return true;
        }
        if (expr instanceof J.Parentheses) {
            J.Parentheses parens = (J.Parentheses)expr;
            collector.builder.append('(');
            try {
                boolean bl = PatternVariables.simplifiedPatternVariableCondition0(parens.getTree(), toReplace, collector);
                return bl;
            }
            finally {
                collector.builder.append(')');
            }
        }
        if (expr instanceof J.Unary) {
            J.Unary unary = (J.Unary)expr;
            switch (unary.getOperator()) {
                case PostIncrement: {
                    boolean found = PatternVariables.simplifiedPatternVariableCondition0(unary.getExpression(), toReplace, collector);
                    collector.builder.append("++");
                    return found;
                }
                case PostDecrement: {
                    boolean found = PatternVariables.simplifiedPatternVariableCondition0(unary.getExpression(), toReplace, collector);
                    collector.builder.append("--");
                    return found;
                }
                case PreIncrement: {
                    collector.builder.append("++");
                    break;
                }
                case PreDecrement: {
                    collector.builder.append("--");
                    break;
                }
                case Positive: {
                    collector.builder.append('+');
                    break;
                }
                case Negative: {
                    collector.builder.append('-');
                    break;
                }
                case Complement: {
                    collector.builder.append('~');
                    break;
                }
                case Not: {
                    collector.builder.append('!');
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected unary operator: " + (Object)((Object)unary.getOperator()));
                }
            }
            return PatternVariables.simplifiedPatternVariableCondition0(unary.getExpression(), toReplace, collector);
        }
        if (expr instanceof J.Binary) {
            J.Binary binary = (J.Binary)expr;
            int length = collector.builder.length();
            boolean result = PatternVariables.simplifiedPatternVariableCondition0(binary.getLeft(), toReplace, collector);
            switch (binary.getOperator()) {
                case Addition: {
                    collector.builder.append('+');
                    break;
                }
                case Subtraction: {
                    collector.builder.append('-');
                    break;
                }
                case Multiplication: {
                    collector.builder.append('*');
                    break;
                }
                case Division: {
                    collector.builder.append('/');
                    break;
                }
                case Modulo: {
                    collector.builder.append('%');
                    break;
                }
                case LessThan: {
                    collector.builder.append('<');
                    break;
                }
                case GreaterThan: {
                    collector.builder.append('>');
                    break;
                }
                case LessThanOrEqual: {
                    collector.builder.append("<=");
                    break;
                }
                case GreaterThanOrEqual: {
                    collector.builder.append(">=");
                    break;
                }
                case Equal: {
                    collector.builder.append("==");
                    break;
                }
                case NotEqual: {
                    collector.builder.append("!=");
                    break;
                }
                case BitAnd: {
                    collector.builder.append('&');
                    break;
                }
                case BitOr: {
                    collector.builder.append('|');
                    break;
                }
                case BitXor: {
                    collector.builder.append('^');
                    break;
                }
                case LeftShift: {
                    collector.builder.append("<<");
                    break;
                }
                case RightShift: {
                    collector.builder.append(">>");
                    break;
                }
                case UnsignedRightShift: {
                    collector.builder.append(">>>");
                    break;
                }
                case Or: {
                    collector.builder.append("||");
                    break;
                }
                case And: {
                    collector.builder.append("&&");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected binary operator: " + (Object)((Object)binary.getOperator()));
                }
            }
            if (!(result |= PatternVariables.simplifiedPatternVariableCondition0(binary.getRight(), toReplace, collector))) {
                switch (binary.getOperator()) {
                    case LessThan: 
                    case GreaterThan: 
                    case LessThanOrEqual: 
                    case GreaterThanOrEqual: 
                    case Equal: 
                    case NotEqual: 
                    case Or: 
                    case And: {
                        collector.builder.setLength(length);
                        collector.builder.append("true");
                        return false;
                    }
                }
            }
            return result;
        }
        if (expr instanceof J.InstanceOf) {
            J.InstanceOf instanceOf = (J.InstanceOf)expr;
            if (instanceOf.getPattern() != null) {
                collector.builder.append("((Object)null) instanceof ").append(instanceOf.getClazz()).append(' ').append(instanceOf.getPattern());
                collector.instanceOfFound = true;
                return true;
            }
            collector.builder.append("true");
        } else if (expr instanceof J.Literal) {
            J.Literal literal = (J.Literal)expr;
            collector.builder.append(literal.getValue());
        } else if (expr instanceof Expression) {
            collector.builder.append("null");
        }
        return false;
    }

    static boolean neverCompletesNormally(Statement statement) {
        return PatternVariables.neverCompletesNormally0(statement, new HashSet<String>());
    }

    private static boolean neverCompletesNormally0(@Nullable Statement statement, Set<String> labelsToIgnore) {
        if (statement instanceof J.Return || statement instanceof J.Throw) {
            return true;
        }
        if (statement instanceof J.Break) {
            J.Break breakStatement = (J.Break)statement;
            return breakStatement.getLabel() != null && !labelsToIgnore.contains(breakStatement.getLabel().getSimpleName()) || breakStatement.getLabel() == null && !labelsToIgnore.contains(DEFAULT_LABEL);
        }
        if (statement instanceof J.Continue) {
            J.Continue continueStatement = (J.Continue)statement;
            return continueStatement.getLabel() != null && !labelsToIgnore.contains(continueStatement.getLabel().getSimpleName()) || continueStatement.getLabel() == null && !labelsToIgnore.contains(DEFAULT_LABEL);
        }
        if (statement instanceof J.Block) {
            return PatternVariables.neverCompletesNormally0(PatternVariables.getLastStatement(statement), labelsToIgnore);
        }
        if (statement instanceof Loop) {
            Loop loop = (Loop)statement;
            return PatternVariables.neverCompletesNormallyIgnoringLabel(loop.getBody(), DEFAULT_LABEL, labelsToIgnore);
        }
        if (statement instanceof J.If) {
            J.If if_ = (J.If)statement;
            return if_.getElsePart() != null && PatternVariables.neverCompletesNormally0(if_.getThenPart(), labelsToIgnore) && PatternVariables.neverCompletesNormally0(if_.getElsePart().getBody(), labelsToIgnore);
        }
        if (statement instanceof J.Switch) {
            J.Switch switch_ = (J.Switch)statement;
            if (switch_.getCases().getStatements().isEmpty()) {
                return false;
            }
            Statement defaultCase = null;
            for (Statement case_ : switch_.getCases().getStatements()) {
                Expression elem;
                if (!PatternVariables.neverCompletesNormallyIgnoringLabel(case_, DEFAULT_LABEL, labelsToIgnore)) {
                    return false;
                }
                if (!(case_ instanceof J.Case) || !((elem = ((J.Case)case_).getPattern()) instanceof J.Identifier) || !((J.Identifier)elem).getSimpleName().equals("default")) continue;
                defaultCase = case_;
            }
            return PatternVariables.neverCompletesNormallyIgnoringLabel(defaultCase, DEFAULT_LABEL, labelsToIgnore);
        }
        if (statement instanceof J.Case) {
            J.Case case_ = (J.Case)statement;
            if (case_.getStatements().isEmpty()) {
                return true;
            }
            return PatternVariables.neverCompletesNormally0(PatternVariables.getLastStatement(case_), labelsToIgnore);
        }
        if (statement instanceof J.Try) {
            J.Try try_ = (J.Try)statement;
            if (try_.getFinally() != null && !try_.getFinally().getStatements().isEmpty() && PatternVariables.neverCompletesNormally0(try_.getFinally(), labelsToIgnore)) {
                return true;
            }
            boolean bodyHasExit = false;
            if (!try_.getBody().getStatements().isEmpty() && !(bodyHasExit = PatternVariables.neverCompletesNormally0(try_.getBody(), labelsToIgnore))) {
                return false;
            }
            for (J.Try.Catch catch_ : try_.getCatches()) {
                if (PatternVariables.neverCompletesNormally0(catch_.getBody(), labelsToIgnore)) continue;
                return false;
            }
            return bodyHasExit;
        }
        if (statement instanceof J.Synchronized) {
            return PatternVariables.neverCompletesNormally0(((J.Synchronized)statement).getBody(), labelsToIgnore);
        }
        if (statement instanceof J.Label) {
            String label = ((J.Label)statement).getLabel().getSimpleName();
            Statement labeledStatement = ((J.Label)statement).getStatement();
            return PatternVariables.neverCompletesNormallyIgnoringLabel(labeledStatement, label, labelsToIgnore);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean neverCompletesNormallyIgnoringLabel(@Nullable Statement statement, String label, Set<String> labelsToIgnore) {
        boolean added = labelsToIgnore.add(label);
        try {
            boolean bl = PatternVariables.neverCompletesNormally0(statement, labelsToIgnore);
            return bl;
        }
        finally {
            if (added) {
                labelsToIgnore.remove(label);
            }
        }
    }

    @Nullable
    private static Statement getLastStatement(Statement statement) {
        if (statement instanceof J.Block) {
            List<Statement> statements = ((J.Block)statement).getStatements();
            return statements.isEmpty() ? null : PatternVariables.getLastStatement(statements.get(statements.size() - 1));
        }
        if (statement instanceof J.Case) {
            List<Statement> statements = ((J.Case)statement).getStatements();
            return statements.isEmpty() ? null : PatternVariables.getLastStatement(statements.get(statements.size() - 1));
        }
        if (statement instanceof Loop) {
            return PatternVariables.getLastStatement(((Loop)statement).getBody());
        }
        return statement;
    }

    private static class ResultCollector {
        final StringBuilder builder = new StringBuilder();
        boolean instanceOfFound;

        private ResultCollector() {
        }
    }
}

