/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateJavaTemplateToRewrite8
extends Recipe {
    private static final String CONTEXT_SENSITIVE_COMMENT = "[Rewrite8 migration] contextSensitive() could be unnecessary, please follow the migration guide";
    private static final String GET_CURSOR_COMMENT = "[Rewrite8 migration] getCursor() could be updateCursor() if the J instance is updated, or it should be updated to point to the correct cursor, please follow the migration guide";
    private static final MethodMatcher templateBuilderMethodMatcher = new MethodMatcher("org.openrewrite.java.JavaTemplate builder(java.lang.String)", true);
    @Nullable
    private static J.MethodInvocation builderTemplate = null;
    @Nullable
    private static J.MethodInvocation applyTemplate = null;

    public String getDisplayName() {
        return "Migrate `JavaTemplate` to accommodate Rewrite 8";
    }

    public String getDescription() {
        return "Migrate `JavaTemplate` to accommodate Rewrite 8, due to wide open-ended usage of JavaTemplate, this recipe just apply most of common changes to pass compile and will leave some comments to require human's review.";
    }

    public Set<String> getTags() {
        return Collections.singleton("Rewrite8 migration");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                return super.visitCompilationUnit(cu, ctx);
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (((J.MethodInvocation)(method = super.visitMethodInvocation((J.MethodInvocation)method, ctx))).getSelect() != null && ((J.MethodInvocation)method).getSelect().getType() != null && TypeUtils.isOfClassType(((J.MethodInvocation)method).getSelect().getType(), "org.openrewrite.java.JavaTemplate") && ((J.MethodInvocation)method).getArguments().size() == 2 && ((J.MethodInvocation)method).getSimpleName().equals("builder")) {
                    return MigrateJavaTemplateToRewrite8.createTemplateBuilderMethodInvocation(((J.MethodInvocation)method).getArguments().get(1));
                }
                if (((J.MethodInvocation)method).getSimpleName().equals("withTemplate") && ((J.MethodInvocation)method).getSelect() != null && ((J.MethodInvocation)method).getArguments().size() >= 2 && TypeUtils.isAssignableTo("org.openrewrite.java.tree.J", ((J.MethodInvocation)method).getSelect().getType())) {
                    List<Expression> args = ((J.MethodInvocation)method).getArguments();
                    MethodCall applyMethodCall = MigrateJavaTemplateToRewrite8.buildApplyMethodInvocation();
                    applyMethodCall = applyMethodCall.withSelect((Expression)args.get(0).withPrefix(Space.EMPTY));
                    List<Expression> newArgs = applyMethodCall.getArguments();
                    newArgs.set(1, args.get(1));
                    for (int i = 2; i < args.size(); ++i) {
                        newArgs.add(args.get(i));
                    }
                    applyMethodCall = applyMethodCall.withArguments((List)newArgs);
                    return this.autoFormat(applyMethodCall, ctx);
                }
                return method;
            }
        };
    }

    private static J.MethodInvocation createTemplateBuilderMethodInvocation(Expression templateString) {
        J.MethodInvocation builderTemplate = MigrateJavaTemplateToRewrite8.buildBuilderMethodInvocation();
        builderTemplate = new JavaIsoVisitor<Expression>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Expression param) {
                if (templateBuilderMethodMatcher.matches(method.getMethodType())) {
                    return method.withArguments((List)Collections.singletonList(param));
                }
                return super.visitMethodInvocation(method, param);
            }
        }.visitMethodInvocation(builderTemplate, templateString);
        return builderTemplate;
    }

    private static J.MethodInvocation buildBuilderMethodInvocation() {
        if (builderTemplate == null) {
            J.CompilationUnit cu = ((JavaParser.Builder)((Object)JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))).build().parse("import org.openrewrite.java.JavaTemplate;\npublic class Demo {void method() {JavaTemplate.builder(\"\")/*[Rewrite8 migration] contextSensitive() could be unnecessary, please follow the migration guide*/.contextSensitive();}}").map(J.CompilationUnit.class::cast).findFirst().get();
            builderTemplate = (J.MethodInvocation)((J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0)).getBody().getStatements().get(0);
        }
        return builderTemplate;
    }

    private static J.MethodInvocation buildApplyMethodInvocation() {
        if (applyTemplate == null) {
            J.CompilationUnit cu = ((JavaParser.Builder)((Object)JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()))).build().parse("import org.openrewrite.java.JavaTemplate;\nimport org.openrewrite.java.JavaVisitor;\nimport org.openrewrite.java.tree.J;\npublic class DemoVisitor extends JavaVisitor {\n    @Override\n    public J visitMethodInvocation(J.MethodInvocation method, Object o) {\n        JavaTemplate t = JavaTemplate.builder(\"\").build();\n        return t.apply(/*[Rewrite8 migration] getCursor() could be updateCursor() if the J instance is updated, or it should be updated to point to the correct cursor, please follow the migration guide*/getCursor(), null);\n    }\n}").map(J.CompilationUnit.class::cast).findFirst().get();
            applyTemplate = (J.MethodInvocation)((J.Return)((J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0)).getBody().getStatements().get(1)).getExpression();
        }
        return applyTemplate;
    }
}

