/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.Space;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression to locate a JSON entry.", example="$.subjects.kind")
    private final String keyPath;

    public String getDisplayName() {
        return "Delete key";
    }

    public String getDescription() {
        return "Delete a JSON mapping entry key.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.keyPath);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.JsonObject visitObject(Json.JsonObject obj, ExecutionContext ctx) {
                Json o = super.visitObject(obj, ctx);
                AtomicReference copyFirstPrefix = new AtomicReference();
                if (!((Json.JsonObject)(o = ((Json.JsonObject)o).withMembers(ListUtils.map(((Json.JsonObject)o).getMembers(), (i, e) -> {
                    if (matcher.matches(new Cursor(this.getCursor(), e))) {
                        if (i == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Json.Array) {
                            copyFirstPrefix.set(e.getPrefix());
                        }
                        return null;
                    }
                    return e;
                })))).getMembers().isEmpty() && copyFirstPrefix.get() != null) {
                    o = ((Json.JsonObject)o).withMembers(ListUtils.mapFirst(((Json.JsonObject)o).getMembers(), e -> e.withPrefix((Space)copyFirstPrefix.get())));
                }
                return o;
            }
        };
    }

    public DeleteKey(String keyPath) {
        this.keyPath = keyPath;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    @NonNull
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        return !(this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        return result;
    }
}

