/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class ParentPomsInUse
extends DataTable<Row> {
    public ParentPomsInUse(Recipe recipe) {
        super(recipe, Row.class, ParentPomsInUse.class.getName(), "Maven parent POMs in use", "Projects, GAVs and relativePaths for Maven parent POMs in use.");
    }

    public static final class Row {
        @Column(displayName="Project artifactId", description="The artifactId of the project that contains the parent.")
        private final String projectArtifactId;
        @Column(displayName="Group", description="The first part of a parent coordinate `org.springframework.boot`.")
        private final String groupId;
        @Column(displayName="Artifact", description="The second part of a parent coordinate `spring-boot-starter-*`.")
        private final String artifactId;
        @Column(displayName="Version", description="The resolved version.")
        @Nullable
        private final String version;
        @Column(displayName="Relative path", description="The relative path to the parent.")
        @Nullable
        private final String relativePath;

        public Row(String projectArtifactId, String groupId, String artifactId, @Nullable String version, @Nullable String relativePath) {
            this.projectArtifactId = projectArtifactId;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.relativePath = relativePath;
        }

        public String getProjectArtifactId() {
            return this.projectArtifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getRelativePath() {
            return this.relativePath;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$projectArtifactId = this.getProjectArtifactId();
            String other$projectArtifactId = other.getProjectArtifactId();
            if (this$projectArtifactId == null ? other$projectArtifactId != null : !this$projectArtifactId.equals(other$projectArtifactId)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$relativePath = this.getRelativePath();
            String other$relativePath = other.getRelativePath();
            return !(this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectArtifactId = this.getProjectArtifactId();
            result = result * 59 + ($projectArtifactId == null ? 43 : $projectArtifactId.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ParentPomsInUse.Row(projectArtifactId=" + this.getProjectArtifactId() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", relativePath=" + this.getRelativePath() + ")";
        }
    }
}

