/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.protobuf.ProtoVisitor;
import org.openrewrite.protobuf.tree.Comment;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.ProtoContainer;
import org.openrewrite.protobuf.tree.ProtoRightPadded;
import org.openrewrite.protobuf.tree.Space;

public class ProtoPrinter<P>
extends ProtoVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> PROTO_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    @Override
    public Proto visitBlock(Proto.Block block, PrintOutputCapture<P> p) {
        this.beforeSyntax(block, p);
        p.append('{');
        this.visitStatements(block.getPadding().getStatements(), p);
        this.visitSpace(block.getEnd(), p);
        p.append('}');
        this.afterSyntax(block, p);
        return block;
    }

    @Override
    public Proto visitConstant(Proto.Constant constant, PrintOutputCapture<P> p) {
        this.beforeSyntax(constant, p);
        p.append(constant.getValueSource());
        this.afterSyntax(constant, p);
        return constant;
    }

    @Override
    public Proto visitDocument(Proto.Document document, PrintOutputCapture<P> p) {
        this.beforeSyntax(document, p);
        this.visit(document.getSyntax(), p);
        this.visitStatements(document.getPadding().getBody(), p);
        this.visitSpace(document.getEof(), p);
        this.afterSyntax(document, p);
        return document;
    }

    @Override
    public Proto visitEmpty(Proto.Empty empty, PrintOutputCapture<P> p) {
        this.beforeSyntax(empty, p);
        this.afterSyntax(empty, p);
        return empty;
    }

    @Override
    public Proto visitEnum(Proto.Enum anEnum, PrintOutputCapture<P> p) {
        this.beforeSyntax(anEnum, p);
        p.append("enum");
        this.visit(anEnum.getName(), p);
        this.visit(anEnum.getBody(), p);
        this.afterSyntax(anEnum, p);
        return anEnum;
    }

    @Override
    public Proto visitEnumField(Proto.EnumField enumField, PrintOutputCapture<P> p) {
        this.beforeSyntax(enumField, p);
        this.visitRightPadded(enumField.getPadding().getName(), p);
        p.append('=');
        this.visit(enumField.getNumber(), p);
        this.visitContainer("[", enumField.getPadding().getOptions(), "]", p);
        this.afterSyntax(enumField, p);
        return enumField;
    }

    @Override
    public Proto visitExtend(Proto.Extend extend, PrintOutputCapture<P> p) {
        this.beforeSyntax(extend, p);
        p.append("extend");
        this.visitFullIdentifier(extend.getName(), p);
        this.visitBlock(extend.getBody(), p);
        this.afterSyntax(extend, p);
        return extend;
    }

    @Override
    public Proto visitExtensionName(Proto.ExtensionName extensionName, PrintOutputCapture<P> p) {
        this.beforeSyntax(extensionName, p);
        p.append('(');
        this.visitRightPadded(extensionName.getPadding().getExtension(), p);
        p.append(')');
        this.afterSyntax(extensionName, p);
        return extensionName;
    }

    @Override
    public Proto visitField(Proto.Field field, PrintOutputCapture<P> p) {
        this.beforeSyntax(field, p);
        this.visit(field.getLabel(), p);
        this.visit(field.getType(), p);
        this.visitRightPadded(field.getPadding().getName(), p);
        p.append('=');
        this.visit(field.getNumber(), p);
        this.visitContainer("[", field.getPadding().getOptions(), "]", p);
        this.afterSyntax(field, p);
        return field;
    }

    @Override
    public Proto visitFullIdentifier(Proto.FullIdentifier identifier, PrintOutputCapture<P> p) {
        this.beforeSyntax(identifier, p);
        this.visitRightPadded(identifier.getPadding().getTarget(), p);
        if (identifier.getTarget() != null) {
            p.append('.');
        }
        this.visit(identifier.getName(), p);
        this.afterSyntax(identifier, p);
        return identifier;
    }

    @Override
    public Proto visitIdentifier(Proto.Identifier identifier, PrintOutputCapture<P> p) {
        this.beforeSyntax(identifier, p);
        p.append(identifier.getName());
        this.afterSyntax(identifier, p);
        return identifier;
    }

    @Override
    public Proto visitImport(Proto.Import anImport, PrintOutputCapture<P> p) {
        this.beforeSyntax(anImport, p);
        p.append("import");
        this.visit(anImport.getModifier(), p);
        this.visitRightPadded(anImport.getPadding().getName(), p);
        this.afterSyntax(anImport, p);
        return anImport;
    }

    @Override
    public Proto visitKeyword(Proto.Keyword keyword, PrintOutputCapture<P> p) {
        this.beforeSyntax(keyword, p);
        p.append(keyword.getKeyword());
        this.afterSyntax(keyword, p);
        return keyword;
    }

    @Override
    public Proto visitMapField(Proto.MapField mapField, PrintOutputCapture<P> p) {
        this.beforeSyntax(mapField, p);
        p.append("map");
        this.visitSpace(mapField.getPadding().getMap().getAfter(), p);
        p.append('<');
        this.visitRightPadded(mapField.getPadding().getKeyType(), p);
        p.append(',');
        this.visitRightPadded(mapField.getPadding().getValueType(), p);
        p.append('>');
        this.visitRightPadded(mapField.getPadding().getName(), p);
        p.append('=');
        this.visit(mapField.getNumber(), p);
        this.visitContainer("[", mapField.getPadding().getOptions(), "]", p);
        this.afterSyntax(mapField, p);
        return mapField;
    }

    @Override
    public Proto visitMessage(Proto.Message message, PrintOutputCapture<P> p) {
        this.beforeSyntax(message, p);
        p.append("message");
        this.visit(message.getName(), p);
        this.visit(message.getBody(), p);
        this.afterSyntax(message, p);
        return message;
    }

    @Override
    public Proto visitOneOf(Proto.OneOf oneOf, PrintOutputCapture<P> p) {
        this.beforeSyntax(oneOf, p);
        p.append("oneof");
        this.visit(oneOf.getName(), p);
        this.visit(oneOf.getFields(), p);
        this.afterSyntax(oneOf, p);
        return oneOf;
    }

    @Override
    public Proto visitOption(Proto.Option option, PrintOutputCapture<P> p) {
        this.beforeSyntax(option, p);
        this.visitRightPadded(option.getPadding().getName(), p);
        p.append('=');
        this.visit(option.getAssignment(), p);
        this.afterSyntax(option, p);
        return option;
    }

    @Override
    public Proto visitOptionDeclaration(Proto.OptionDeclaration optionDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax(optionDeclaration, p);
        p.append("option");
        this.visitRightPadded(optionDeclaration.getPadding().getName(), p);
        p.append('=');
        this.visit(optionDeclaration.getAssignment(), p);
        this.afterSyntax(optionDeclaration, p);
        return optionDeclaration;
    }

    @Override
    public Proto visitPackage(Proto.Package aPackage, PrintOutputCapture<P> p) {
        this.beforeSyntax(aPackage, p);
        p.append("package");
        this.visit(aPackage.getName(), p);
        this.afterSyntax(aPackage, p);
        return aPackage;
    }

    @Override
    public Proto visitPrimitive(Proto.Primitive primitive, PrintOutputCapture<P> p) {
        this.beforeSyntax(primitive, p);
        p.append(primitive.getType().toString().toLowerCase());
        this.afterSyntax(primitive, p);
        return primitive;
    }

    @Override
    public Proto visitRange(Proto.Range range, PrintOutputCapture<P> p) {
        this.beforeSyntax(range, p);
        this.visitRightPadded(range.getPadding().getFrom(), p);
        if (range.getTo() != null) {
            p.append("to");
            this.visit(range.getTo(), p);
        }
        this.afterSyntax(range, p);
        return range;
    }

    @Override
    public Proto visitReserved(Proto.Reserved reserved, PrintOutputCapture<P> p) {
        this.beforeSyntax(reserved, p);
        p.append("reserved");
        this.visitContainer("", reserved.getPadding().getReservations(), "", p);
        this.afterSyntax(reserved, p);
        return reserved;
    }

    @Override
    public Proto visitRpc(Proto.Rpc rpc, PrintOutputCapture<P> p) {
        this.beforeSyntax(rpc, p);
        p.append("rpc");
        this.visit(rpc.getName(), p);
        this.visit(rpc.getRequest(), p);
        this.visit(rpc.getReturns(), p);
        this.visit(rpc.getResponse(), p);
        this.visit(rpc.getBody(), p);
        this.afterSyntax(rpc, p);
        return rpc;
    }

    @Override
    public Proto visitRpcInOut(Proto.RpcInOut rpcInOut, PrintOutputCapture<P> p) {
        this.beforeSyntax(rpcInOut, p);
        p.append('(');
        if (rpcInOut.getStream() != null) {
            this.visitSpace(rpcInOut.getStream().getPrefix(), p);
            p.append("stream");
        }
        this.visitRightPadded(rpcInOut.getPadding().getType(), p);
        p.append(')');
        this.afterSyntax(rpcInOut, p);
        return rpcInOut;
    }

    @Override
    public Proto visitService(Proto.Service service, PrintOutputCapture<P> p) {
        this.beforeSyntax(service, p);
        p.append("service");
        this.visit(service.getName(), p);
        this.visit(service.getBody(), p);
        this.afterSyntax(service, p);
        return service;
    }

    @Override
    public Proto visitStringLiteral(Proto.StringLiteral stringLiteral, PrintOutputCapture<P> p) {
        this.beforeSyntax(stringLiteral, p);
        p.append(stringLiteral.isSingleQuote() ? (char)'\'' : '\"');
        p.append(stringLiteral.getLiteral());
        p.append(stringLiteral.isSingleQuote() ? (char)'\'' : '\"');
        this.afterSyntax(stringLiteral, p);
        return stringLiteral;
    }

    @Override
    public Proto visitSyntax(Proto.Syntax syntax, PrintOutputCapture<P> p) {
        this.beforeSyntax(syntax, p);
        p.append("syntax");
        this.visitSpace(syntax.getKeywordSuffix(), p);
        p.append('=');
        this.visitRightPadded(syntax.getPadding().getLevel(), p);
        p.append(';');
        this.afterSyntax(syntax, p);
        return syntax;
    }

    @Override
    public Space visitSpace(Space space, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            if (comment.isMultiline()) {
                p.append("/*").append(comment.getText()).append("*/");
            } else {
                p.append("//").append(comment.getText());
            }
            p.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitContainer(String before, @Nullable ProtoContainer<? extends Proto> container, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), p);
        p.append(after == null ? "" : after);
    }

    protected void visitRightPadded(List<? extends ProtoRightPadded<? extends Proto>> nodes, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            ProtoRightPadded<? extends Proto> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(',');
        }
    }

    protected void visitStatements(List<ProtoRightPadded<Proto>> statements, PrintOutputCapture<P> p) {
        for (ProtoRightPadded<Proto> paddedStat : statements) {
            this.visitStatement(paddedStat, p);
        }
    }

    protected void visitStatement(@Nullable ProtoRightPadded<Proto> paddedStat, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.visit(paddedStat.getElement(), p);
        this.visitSpace(paddedStat.getAfter(), p);
        Proto s = paddedStat.getElement();
        if (s instanceof Proto.Empty || s instanceof Proto.Field || s instanceof Proto.Import || s instanceof Proto.MapField || s instanceof Proto.EnumField || s instanceof Proto.OptionDeclaration || s instanceof Proto.Package || s instanceof Proto.Reserved || s instanceof Proto.Rpc && ((Proto.Rpc)s).getBody() == null || s instanceof Proto.Syntax) {
            p.append(';');
        }
    }

    private void beforeSyntax(Proto proto, PrintOutputCapture<P> p) {
        this.beforeSyntax(proto.getPrefix(), proto.getMarkers(), p);
    }

    private void beforeSyntax(Space prefix, Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), PROTO_MARKER_WRAPPER));
        }
        this.visitSpace(prefix, p);
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), PROTO_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Proto proto, PrintOutputCapture<P> p) {
        this.afterSyntax(proto.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), PROTO_MARKER_WRAPPER));
        }
    }
}

