/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.MockFileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public abstract class FileTypeManager
extends FileTypeRegistry {
    private static final Supplier<FileTypeManager> ourInstance;
    @Topic.AppLevel
    @NotNull
    public static final Topic<FileTypeListener> TOPIC;

    public static FileTypeManager getInstance() {
        return ourInstance.get();
    }

    @Deprecated(forRemoval=true)
    public abstract void registerFileType(@NotNull FileType var1, String ... var2);

    public abstract boolean isFileIgnored(@NotNull String var1);

    @NotNull
    public abstract List<FileNameMatcher> getAssociations(@NotNull FileType var1);

    @Nullable
    public abstract FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public abstract String getIgnoredFilesList();

    public abstract void setIgnoredFilesList(@NotNull String var1);

    public final void associateExtension(@NotNull FileType type, @NotNull String extension) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            FileTypeManager.$$$reportNull$$$0(1);
        }
        this.associate(type, (FileNameMatcher)new ExtensionFileNameMatcher(extension));
    }

    public final void associatePattern(@NotNull FileType type, @NotNull String pattern) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            FileTypeManager.$$$reportNull$$$0(3);
        }
        this.associate(type, FileTypeManager.parseFromString(pattern));
    }

    public abstract void associate(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    public final void removeAssociatedExtension(@NotNull FileType type, @NotNull String extension) {
        if (type == null) {
            FileTypeManager.$$$reportNull$$$0(4);
        }
        if (extension == null) {
            FileTypeManager.$$$reportNull$$$0(5);
        }
        this.removeAssociation(type, (FileNameMatcher)new ExtensionFileNameMatcher(extension));
    }

    public abstract void removeAssociation(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    @NotNull
    public static FileNameMatcher parseFromString(@NotNull String pattern) {
        if (pattern == null) {
            FileTypeManager.$$$reportNull$$$0(6);
        }
        FileNameMatcher fileNameMatcher = FileNameMatcherFactory.getInstance().createMatcher(pattern);
        if (fileNameMatcher == null) {
            FileTypeManager.$$$reportNull$$$0(7);
        }
        return fileNameMatcher;
    }

    @NotNull
    public abstract FileType getStdFileType(@NotNull String var1);

    static {
        FileTypeRegistry.setInstanceSupplier(FileTypeManager::getInstance);
        ourInstance = CachedSingletonsRegistry.lazy(() -> {
            Application app = ApplicationManager.getApplication();
            return app == null ? new MockFileTypeManager() : app.getService(FileTypeManager.class);
        });
        TOPIC = new Topic<FileTypeListener>(FileTypeListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/FileTypeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/FileTypeManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "associateExtension";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "associatePattern";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociatedExtension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseFromString";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

