/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static volatile SimpleStringPersistentEnumerator nameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<String, ID<?, ?>> idObjects = new ConcurrentHashMap();
    private static final Object lock = new Object();
    private static volatile PersistentMap<ID<?, ?>, PluginId> idToPluginId = ExtensionsKt.persistentHashMapOf();
    private static volatile PersistentMap<ID<?, ?>, Throwable> idToRegistrationStackTrace = ExtensionsKt.persistentHashMapOf();
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private volatile int uniqueId;

    @ApiStatus.Internal
    @NotNull
    private static Path getEnumFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.enum");
        if (path == null) {
            ID.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.Internal
    public static void reloadEnumFile() {
        ID.reloadEnumFile(ID.getEnumFile());
    }

    private static void reloadEnumFile(@NotNull Path enumFile) {
        if (enumFile == null) {
            ID.$$$reportNull$$$0(1);
        }
        if (enumFile.equals(nameToIdRegistry.getFile())) {
            return;
        }
        SimpleStringPersistentEnumerator newNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
        Map<String, Integer> newInvertedState = newNameToIdRegistry.getInvertedState();
        Map<String, Integer> oldInvertedState = nameToIdRegistry.getInvertedState();
        oldInvertedState.forEach((oldKey, oldId) -> {
            Integer newId = (Integer)newInvertedState.get(oldKey);
            if (newId == null) {
                int createdId = newNameToIdRegistry.enumerate((String)oldKey);
                if (createdId != oldId) {
                    ID.reassign(oldKey, createdId);
                }
            } else if (oldId.intValue() != newId.intValue()) {
                ID.reassign(oldKey, newId);
            }
        });
        nameToIdRegistry = newNameToIdRegistry;
    }

    private static void reassign(String name, int newId) {
        ID<?, ?> id = idObjects.get(name);
        if (id != null) {
            id.uniqueId = newId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected ID(@NotNull String name, @Nullable PluginId pluginId) {
        if (name == null) {
            ID.$$$reportNull$$$0(2);
        }
        super(name);
        this.uniqueId = ID.stringToId(name);
        ID old = idObjects.put(name, this);
        assert (old == null) : "ID with name '" + name + "' is already registered";
        Object object = lock;
        synchronized (object) {
            PluginId oldPluginId = (PluginId)idToPluginId.get((Object)this);
            assert (oldPluginId == null) : "ID with name '" + name + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
            idToPluginId = idToPluginId.put((Object)this, (Object)pluginId);
            idToRegistrationStackTrace = idToRegistrationStackTrace.put((Object)this, (Object)new Throwable());
        }
    }

    private static int stringToId(@NotNull String name) {
        int id;
        if (name == null) {
            ID.$$$reportNull$$$0(3);
        }
        if ((id = nameToIdRegistry.enumerate(name)) != (short)id) {
            throw new AssertionError((Object)"Too many indexes registered");
        }
        return id;
    }

    static void reinitializeDiskStorage() {
        nameToIdRegistry.forceDiskSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(4);
        }
        PluginId pluginId = ID.getCallerPluginId();
        Object object = lock;
        // MONITORENTER : object
        ID<K, V> found = ID.findByName(name, true, pluginId);
        ID<K, V> iD = found == null ? new ID<K, V>(name, pluginId) : found;
        // MONITOREXIT : object
        if (iD != null) return iD;
        ID.$$$reportNull$$$0(5);
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(6);
        }
        return ID.findByName(name, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        if (name == null) {
            ID.$$$reportNull$$$0(7);
        }
        ID<?, ?> id = ID.findById(ID.stringToId(name));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = (PluginId)idToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? "IJ Core" : actualPluginId.getIdString();
            String string = requiredPluginIdStr = requiredPluginId == null ? "IJ Core" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = (Throwable)idToRegistrationStackTrace.get(id);
                String message = ID.getInvalidIdAccessMessage(name, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace != null) {
                    throw new AssertionError(message, registrationStackTrace);
                }
                throw new AssertionError((Object)message);
            }
        }
        return id;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        if (name == null) {
            ID.$$$reportNull$$$0(8);
        }
        String string = "ID with name '" + name + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
        if (string == null) {
            ID.$$$reportNull$$$0(9);
        }
        return string;
    }

    @ApiStatus.Internal
    public static Collection<ID<?, ?>> getRegisteredIds() {
        return idToPluginId.keySet();
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        Throwable throwable = (Throwable)idToRegistrationStackTrace.get((Object)this);
        if (throwable == null) {
            ID.$$$reportNull$$$0(10);
        }
        return throwable;
    }

    @ApiStatus.Internal
    public int getUniqueId() {
        return this.uniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return (PluginId)idToPluginId.get((Object)this);
    }

    @ApiStatus.Internal
    public static ID<?, ?> findById(int id) {
        String key = nameToIdRegistry.valueOf(id);
        return key == null ? null : idObjects.get(key);
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        return PluginUtil.getInstance().getCallerPlugin(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void unloadId(@NotNull ID<?, ?> id) {
        if (id == null) {
            ID.$$$reportNull$$$0(11);
        }
        String name = id.getName();
        Object object = lock;
        synchronized (object) {
            ID<?, ?> oldID = idObjects.remove(name);
            LOG.assertTrue(id.equals(oldID), "Failed to unload: " + name);
            idToPluginId = idToPluginId.remove(id);
            idToRegistrationStackTrace.remove(id);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIdAccessMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationTrace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadEnumFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidIdAccessMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unloadId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

