/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNumericLiteralExpressionImpl
extends PyElementImpl
implements PyNumericLiteralExpression {
    public PyNumericLiteralExpressionImpl(@NotNull ASTNode astNode) {
        if (astNode == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyNumericLiteralExpression(this);
    }

    @Override
    @Nullable
    public Long getLongValue() {
        BigInteger value = this.getBigIntegerValue();
        return Optional.ofNullable(value).map(BigInteger::longValue).filter(longValue -> BigInteger.valueOf(longValue).equals(value)).orElse(null);
    }

    @Override
    @Nullable
    public BigInteger getBigIntegerValue() {
        if (this.isIntegerLiteral()) {
            return PyNumericLiteralExpressionImpl.getBigIntegerValue(this.getNode().getText());
        }
        BigDecimal bigDecimal = this.getBigDecimalValue();
        return bigDecimal == null ? null : bigDecimal.toBigInteger();
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimalValue() {
        String text = this.getNode().getText();
        if (this.isIntegerLiteral()) {
            return Optional.ofNullable(PyNumericLiteralExpressionImpl.getBigIntegerValue(text)).map(BigDecimal::new).orElse(null);
        }
        return new BigDecimal(PyNumericLiteralExpressionImpl.prepareLiteralForJava(text, 0));
    }

    @Override
    public boolean isIntegerLiteral() {
        return this.getNode().getElementType() == PyElementTypes.INTEGER_LITERAL_EXPRESSION;
    }

    @Override
    @Nullable
    public String getIntegerLiteralSuffix() {
        return this.isIntegerLiteral() ? StringUtil.nullize(PyNumericLiteralExpressionImpl.retrieveSuffix(this.getText())) : null;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (key == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        if (this.isIntegerLiteral()) {
            return PyBuiltinCache.getInstance(this).getIntType();
        }
        IElementType type = this.getNode().getElementType();
        if (type == PyElementTypes.FLOAT_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance(this).getFloatType();
        }
        if (type == PyElementTypes.IMAGINARY_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance(this).getComplexType();
        }
        return null;
    }

    @Nullable
    private static BigInteger getBigIntegerValue(@NotNull String text) {
        int radix;
        int beginIndex;
        if (text == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (text.equalsIgnoreCase("0" + PyNumericLiteralExpressionImpl.retrieveSuffix(text))) {
            return BigInteger.ZERO;
        }
        if (StringUtil.startsWithIgnoreCase(text, "0x")) {
            beginIndex = 2;
            radix = 16;
        } else if (StringUtil.startsWithIgnoreCase(text, "0b")) {
            beginIndex = 2;
            radix = 2;
        } else if (text.startsWith("0")) {
            beginIndex = StringUtil.isChar(text, 1, 'o') || StringUtil.isChar(text, 1, 'O') ? 2 : 1;
            radix = 8;
        } else {
            beginIndex = 0;
            radix = 10;
        }
        return new BigInteger(PyNumericLiteralExpressionImpl.prepareLiteralForJava(text, beginIndex), radix);
    }

    @NotNull
    private static String prepareLiteralForJava(@NotNull String text, int beginIndex) {
        if (text == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        int endIndex = text.length() - PyNumericLiteralExpressionImpl.retrieveSuffix(text).length();
        String string = text.substring(beginIndex, endIndex).replaceAll("_", "");
        if (string == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String retrieveSuffix(@NotNull String text) {
        char last;
        int lastIndex;
        if (text == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        for (lastIndex = text.length(); lastIndex > 0 && ((last = text.charAt(lastIndex - 1)) == 'u' || last == 'U' || last == 'l' || last == 'L' || last == 'j' || last == 'J'); --lastIndex) {
        }
        String string = text.substring(lastIndex);
        if (string == null) {
            PyNumericLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyNumericLiteralExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyNumericLiteralExpressionImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLiteralForJava";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBigIntegerValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareLiteralForJava";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retrieveSuffix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

