/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyKeywordArgumentProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class KeywordArgumentCompletionUtil {
    public static void collectFunctionArgNames(PyElement element, List<? super LookupElement> ret, @NotNull TypeEvalContext context, boolean addEquals) {
        PyExpression callee;
        PyCallExpression callExpr;
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(0);
        }
        if ((callExpr = PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) != null && (callee = callExpr.getCallee()) instanceof PyReferenceExpression && element.getParent() == callExpr.getArgumentList()) {
            PyTypedElement implicit;
            PyType calleeType = context.getType(callee);
            if (calleeType == null && (implicit = PyUtil.as(KeywordArgumentCompletionUtil.getElementByChain((PyReferenceExpression)callee, context), PyTypedElement.class)) != null) {
                calleeType = context.getType(implicit);
            }
            Set namedArgsAlready = StreamEx.of((Object[])callExpr.getArgumentList().getArguments()).select(PyKeywordArgument.class).map(PyKeywordArgument::getKeyword).toSet();
            List extra = ((StreamEx)PyTypeUtil.toStream(calleeType).select(PyCallableType.class).flatMap(type -> KeywordArgumentCompletionUtil.collectParameterNamesFromType(type, callExpr, context).stream()).filter(it -> !namedArgsAlready.contains(it))).map(name -> PyUtil.createNamedParameterLookup(name, element.getContainingFile(), addEquals)).toList();
            ret.addAll(extra);
        }
    }

    @NotNull
    private static List<String> collectParameterNamesFromType(@NotNull PyCallableType type, @NotNull PyCallExpression callSite, @NotNull TypeEvalContext context) {
        List<PyCallableParameter> parameters;
        if (type == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(1);
        }
        if (callSite == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(3);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        if (type.isCallable() && (parameters = type.getParameters(context)) != null) {
            int indexOfPySlashParameter = KeywordArgumentCompletionUtil.getIndexOfPySlashParameter(parameters);
            for (PyCallableParameter parameter : parameters.subList(indexOfPySlashParameter + 1, parameters.size())) {
                if (parameter.isKeywordContainer() || parameter.isPositionalContainer()) continue;
                ContainerUtil.addIfNotNull(result2, parameter.getName());
            }
            PyFunction func = null;
            if (type.getCallable() instanceof PyFunction) {
                func = PyUtil.as(type.getCallable(), PyFunction.class);
            } else if (type instanceof PyClassType) {
                func = ((PyClassType)type).getPyClass().findInitOrNew(true, context);
            }
            if (func != null) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariantsForFunction(callSite, func, result2, new HashSet<PyCallable>(), context);
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static PsiElement getElementByChain(@NotNull PyReferenceExpression callee, @NotNull TypeEvalContext context) {
        if (callee == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(6);
        }
        PyResolveContext resolveContext = PyResolveContext.implicitContext(context);
        QualifiedResolveResult result2 = callee.followAssignmentsChain(resolveContext);
        return result2.getElement();
    }

    private static int getIndexOfPySlashParameter(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(7);
        }
        return ContainerUtil.indexOf(parameters, parameter -> parameter.getParameter() instanceof PySlashParameter);
    }

    private static void addKeywordArgumentVariantsForFunction(@NotNull PyCallExpression callExpr, @NotNull PyFunction function, @NotNull List<String> ret, @NotNull Set<PyCallable> visited, @NotNull TypeEvalContext context) {
        if (callExpr == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(8);
        }
        if (function == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(9);
        }
        if (ret == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(10);
        }
        if (visited == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(12);
        }
        if (visited.contains(function)) {
            return;
        }
        boolean needSelf = function.getContainingClass() != null && function.getModifier() != PyFunction.Modifier.STATICMETHOD;
        KwArgParameterCollector collector = new KwArgParameterCollector(needSelf, ret);
        List<PyCallableParameter> parameters = function.getParameters(context);
        int indexOfPySlashParameter = KeywordArgumentCompletionUtil.getIndexOfPySlashParameter(parameters);
        ((StreamEx)StreamEx.of(parameters).skip((long)(indexOfPySlashParameter + 1))).map(PyCallableParameter::getParameter).nonNull().forEach(parameter -> parameter.accept(collector));
        if (collector.hasKwArgs()) {
            PyFunction superMethod;
            for (PyKeywordArgumentProvider provider : PyKeywordArgumentProvider.EP_NAME.getExtensionList()) {
                ret.addAll(provider.getKeywordArguments(function, callExpr));
            }
            KwArgFromStatementCallCollector fromStatementCallCollector = new KwArgFromStatementCallCollector(ret, collector.getKwArgs());
            function.getStatementList().acceptChildren(fromStatementCallCollector);
            if (fromStatementCallCollector.isKwArgsTransit() && (superMethod = PyUtil.as(PySuperMethodsSearch.search((PyFunction)function, (TypeEvalContext)context).findFirst(), PyFunction.class)) != null) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariantsForFunction(callExpr, superMethod, ret, visited, context);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ret";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParameterNamesFromType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFunctionArgNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectParameterNamesFromType";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementByChain";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfPySlashParameter";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addKeywordArgumentVariantsForFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static class KwArgParameterCollector
    extends PyElementVisitor {
        private int myCount;
        private final boolean myNeedSelf;
        private final List<? super String> myRet;
        private boolean myHasSelf = false;
        private boolean myHasKwArgs = false;
        private PyParameter kwArgsParam = null;

        public KwArgParameterCollector(boolean needSelf, List<? super String> ret) {
            this.myNeedSelf = needSelf;
            this.myRet = ret;
        }

        @Override
        public void visitPyParameter(@NotNull PyParameter par) {
            if (par == null) {
                KwArgParameterCollector.$$$reportNull$$$0(0);
            }
            ++this.myCount;
            if (this.myCount == 1 && this.myNeedSelf) {
                this.myHasSelf = true;
                return;
            }
            PyNamedParameter namedParam = par.getAsNamed();
            if (namedParam != null) {
                if (!namedParam.isKeywordContainer() && !namedParam.isPositionalContainer()) {
                    this.myRet.add(namedParam.getName());
                } else if (namedParam.isKeywordContainer()) {
                    this.myHasKwArgs = true;
                    this.kwArgsParam = namedParam;
                }
            }
        }

        public PyParameter getKwArgs() {
            return this.kwArgsParam;
        }

        public boolean hasKwArgs() {
            return this.myHasKwArgs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "par", "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil$KwArgParameterCollector", "visitPyParameter"));
        }
    }

    public static class KwArgFromStatementCallCollector
    extends PyElementVisitor {
        private final List<String> myRet;
        private final PyParameter myKwArgs;
        private boolean kwArgsTransit;

        public KwArgFromStatementCallCollector(List<String> ret, @NotNull PyParameter kwArgs) {
            if (kwArgs == null) {
                KwArgFromStatementCallCollector.$$$reportNull$$$0(0);
            }
            this.kwArgsTransit = true;
            this.myRet = ret;
            this.myKwArgs = kwArgs;
        }

        @Override
        public void visitPyElement(@NotNull PyElement node) {
            if (node == null) {
                KwArgFromStatementCallCollector.$$$reportNull$$$0(1);
            }
            node.acceptChildren(this);
        }

        @Override
        public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
            if (node == null) {
                KwArgFromStatementCallCollector.$$$reportNull$$$0(2);
            }
            String operandName = node.getOperand().getName();
            this.processGet(operandName, node.getIndexExpression());
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            block5: {
                block4: {
                    if (node == null) {
                        KwArgFromStatementCallCollector.$$$reportNull$$$0(3);
                    }
                    if (!node.isCalleeText("pop", "get", "getattr")) break block4;
                    PyReferenceExpression child = PsiTreeUtil.getChildOfType(node.getCallee(), PyReferenceExpression.class);
                    if (child == null) break block5;
                    String operandName = child.getName();
                    if (node.getArguments().length > 0) {
                        PyExpression argument = node.getArguments()[0];
                        this.processGet(operandName, argument);
                    }
                    break block5;
                }
                if (node.isCalleeText("__init__")) {
                    this.kwArgsTransit = false;
                    for (PyExpression e : node.getArguments()) {
                        if (!(e instanceof PyStarArgument)) continue;
                        PyStarArgument kw = (PyStarArgument)e;
                        if (!Objects.equals(this.myKwArgs.getName(), kw.getFirstChild().getNextSibling().getText())) continue;
                        this.kwArgsTransit = true;
                        break;
                    }
                }
            }
            super.visitPyCallExpression(node);
        }

        private void processGet(String operandName, PyExpression argument) {
            String name;
            if (Objects.equals(this.myKwArgs.getName(), operandName) && argument instanceof PyStringLiteralExpression && PyNames.isIdentifier((String)(name = ((PyStringLiteralExpression)argument).getStringValue()))) {
                this.myRet.add(name);
            }
        }

        public boolean isKwArgsTransit() {
            return this.kwArgsTransit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kwArgs";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil$KwArgFromStatementCallCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPySubscriptionExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

