/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeCheckerExtension;
import com.jetbrains.python.psi.types.PyTypeParameterMapping;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyTypingNewType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(0);
        }
        @NotNull GenericSubstitutions substitutions = new GenericSubstitutions();
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> typeVars) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(1);
        }
        if (typeVars == null) {
            PyTypeChecker.$$$reportNull$$$0(2);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions(typeVars, new HashMap<PyTypeVarTupleType, PyVariadicType>(), new HashMap<PyParamSpecType, PyParamSpecType>(), null);
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(3);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(4);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    @NotNull
    private static Optional<Boolean> match(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> result2;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(5);
        }
        Optional<Boolean> optional = (result2 = RecursionManager.doPreventingRecursion(Pair.create(expected, actual), false, () -> PyTypeChecker.matchImpl(expected, actual, context))) == null ? Optional.of(true) : result2;
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(6);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchImpl(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(7);
        }
        if (Objects.equals(expected, actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(8);
            }
            return optional;
        }
        for (PyTypeCheckerExtension extension : PyTypeCheckerExtension.EP_NAME.getExtensionList()) {
            Optional<Boolean> result2 = extension.match(expected, actual, context.context, context.mySubstitutions.typeVars);
            if (!result2.isPresent()) continue;
            Optional<Boolean> optional = result2;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(9);
            }
            return optional;
        }
        if (expected instanceof PyClassType && (match = PyTypeChecker.matchObject((PyClassType)expected, actual)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(10);
            }
            return optional;
        }
        if (actual instanceof PyTypeVarTupleType) {
            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)actual;
            if (context.reversedSubstitutions) {
                Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyVariadicType)typeVarTupleType, expected, context));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(11);
                }
                return optional;
            }
        }
        if (expected instanceof PyVariadicType) {
            PyVariadicType variadic = (PyVariadicType)expected;
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(variadic, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(12);
            }
            return optional;
        }
        if (actual instanceof PyGenericType && context.reversedSubstitutions) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyGenericType)((Object)actual), expected, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(13);
            }
            return optional;
        }
        if (expected instanceof PyGenericType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyGenericType)((Object)expected), actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(14);
            }
            return optional;
        }
        if (expected instanceof PySelfType) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, actual, context);
        }
        if (actual instanceof PySelfType && context.reversedSubstitutions) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, expected, context);
        }
        if (expected instanceof PyParamSpecType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyParamSpecType)((Object)expected), actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(15);
            }
            return optional;
        }
        if (expected == null || actual == null || PyTypeChecker.isUnknown(actual, context.context)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(16);
            }
            return optional;
        }
        if (actual instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(expected, (PyUnionType)actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(17);
            }
            return optional;
        }
        if (expected instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyUnionType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(18);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyClassType && (match = PyTypeChecker.match((PyClassType)expected, (PyClassType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(19);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && ((PyStructuralType)actual).isInferredFromUsages()) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(20);
            }
            return optional;
        }
        if (expected instanceof PyStructuralType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyStructuralType)expected, actual, context.context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(21);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && expected instanceof PyClassType) {
            Set<String> expectedAttributes = ((PyClassType)expected).getMemberNames(true, context.context);
            Optional<Boolean> optional = Optional.of(expectedAttributes.containsAll(((PyStructuralType)actual).getAttributeNames()));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(22);
            }
            return optional;
        }
        if (actual instanceof PyCallableType) {
            PyCallableType expectedCallable;
            Optional<Boolean> match2;
            PyCallableType actualCallable = (PyCallableType)actual;
            if (expected instanceof PyCallableType && (match2 = PyTypeChecker.match(expectedCallable = (PyCallableType)expected, actualCallable, context)).isPresent()) {
                Optional<Boolean> optional = match2;
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(23);
                }
                return optional;
            }
        }
        if (expected instanceof PyNoneType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyNoneType);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(24);
            }
            return optional;
        }
        if (expected instanceof PyModuleType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyModuleType && ((PyModuleType)expected).getModule() == ((PyModuleType)actual).getModule());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(25);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyModuleType) {
            return PyTypeChecker.match(expected, (PyType)((PyModuleType)actual).getModuleClassType(), context);
        }
        Optional<Boolean> optional = Optional.of(PyTypeChecker.matchNumericTypes(expected, actual));
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(26);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchObject(@NotNull PyClassType expected, @Nullable PyType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(27);
        }
        if (ArrayUtil.contains(expected.getName(), "object", "type")) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(expected.getPyClass());
            if (expected.equals(builtinCache.getObjectType())) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(28);
                }
                return optional;
            }
            if (expected.equals(builtinCache.getTypeType()) && actual instanceof PyInstantiableType && ((PyInstantiableType)actual).isDefinition()) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(29);
                }
                return optional;
            }
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(30);
        }
        return optional;
    }

    private static boolean match(@NotNull PyGenericType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(32);
        }
        if (expected.isDefinition() && actual instanceof PyInstantiableType && !((PyInstantiableType)actual).isDefinition()) {
            return false;
        }
        PyType substitution = context.mySubstitutions.typeVars.get(expected);
        PyType bound = expected.getBound();
        if (expected.isDefinition()) {
            Function<PyType, PyType> toDefinition = t -> t instanceof PyInstantiableType ? ((PyInstantiableType)t).toClass() : t;
            bound = PyUnionType.union(PyTypeUtil.toStream(bound).map(toDefinition).toList());
        }
        if ((match = PyTypeChecker.match(bound, actual, context)).isPresent() && !match.get().booleanValue()) {
            return false;
        }
        if (substitution != null) {
            if (expected.equals(actual) || substitution.equals(expected)) {
                return true;
            }
            Optional recursiveMatch = RecursionManager.doPreventingRecursion(expected, false, context.reversedSubstitutions ? () -> PyTypeChecker.match(actual, substitution, context) : () -> PyTypeChecker.match(substitution, actual, context));
            return recursiveMatch != null ? recursiveMatch.orElse(false) : false;
        }
        if (actual != null) {
            context.mySubstitutions.typeVars.put(expected, actual);
        } else if (bound != null) {
            context.mySubstitutions.typeVars.put(expected, PyUnionType.createWeakType(bound));
        }
        return true;
    }

    private static boolean match(@NotNull PyVariadicType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(34);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyVariadicType)) {
            return false;
        }
        PyVariadicType actualVariadic = (PyVariadicType)actual;
        if (expected instanceof PyUnpackedTupleType) {
            PyUnpackedTupleType expectedUnpackedTupleType = (PyUnpackedTupleType)expected;
            if (!(actualVariadic instanceof PyUnpackedTupleType)) {
                return false;
            }
            PyUnpackedTupleType actualUnpackedTupleType = (PyUnpackedTupleType)actualVariadic;
            if (expectedUnpackedTupleType.isUnbound()) {
                PyType repeatedExpectedType = (PyType)expectedUnpackedTupleType.getElementTypes().get(0);
                if (actualUnpackedTupleType.isUnbound()) {
                    return PyTypeChecker.match(repeatedExpectedType, (PyType)actualUnpackedTupleType.getElementTypes().get(0), context).orElse(false);
                }
                return ContainerUtil.all(actualUnpackedTupleType.getElementTypes(), singleActualType -> PyTypeChecker.match(repeatedExpectedType, singleActualType, context).orElse(false));
            }
            if (actualUnpackedTupleType.isUnbound()) {
                PyType repeatedActualType = (PyType)actualUnpackedTupleType.getElementTypes().get(0);
                return ContainerUtil.all(expectedUnpackedTupleType.getElementTypes(), singleExpectedType -> PyTypeChecker.match(singleExpectedType, repeatedActualType, context).orElse(false));
            }
            return PyTypeChecker.matchTypeParameters(expectedUnpackedTupleType.getElementTypes(), actualUnpackedTupleType.getElementTypes(), context);
        }
        PyVariadicType substitution = context.mySubstitutions.typeVarTuples.get(expected);
        if (substitution != null && !substitution.equals(PyUnpackedTupleTypeImpl.UNSPECIFIED)) {
            if (expected.equals(actual) || substitution.equals(expected)) {
                return true;
            }
            return context.reversedSubstitutions ? PyTypeChecker.match(actualVariadic, (PyType)substitution, context) : PyTypeChecker.match(substitution, (PyType)actualVariadic, context);
        }
        context.mySubstitutions.typeVarTuples.put((PyTypeVarTupleType)expected, actualVariadic);
        return true;
    }

    private static boolean match(@NotNull PyParamSpecType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(35);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(36);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyParamSpecType)) {
            return false;
        }
        PyParamSpecType callableActual = (PyParamSpecType)((Object)actual);
        List<PyCallableParameter> parameters = callableActual.getParameters();
        if (parameters == null) {
            return false;
        }
        context.mySubstitutions.paramSpecs.put(expected, expected.withParameters(parameters, context.context));
        return true;
    }

    private static boolean match(@NotNull PyType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        PyTupleType expectedTupleType;
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(37);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(39);
        }
        if (expected instanceof PyTupleType && (match = PyTypeChecker.match(expectedTupleType = (PyTupleType)expected, actual, context)).isPresent()) {
            return match.get();
        }
        if (ContainerUtil.exists(actual.getMembers(), x -> x instanceof PyLiteralStringType || x instanceof PyLiteralType)) {
            return ContainerUtil.and(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
        }
        return ContainerUtil.or(actual.getMembers(), type -> PyTypeChecker.match(expected, type, context).orElse(false));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        PyTupleType widenedActual;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(40);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(42);
        }
        int elementCount = expected.getElementCount();
        if (!expected.isHomogeneous() && (widenedActual = PyTypeChecker.widenUnionOfTuplesToTupleOfUnions(actual, elementCount)) != null) {
            return PyTypeChecker.match(expected, widenedActual, context);
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(43);
        }
        return optional;
    }

    private static boolean match(@NotNull PyUnionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(44);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(45);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(46);
        }
        if (expected.getMembers().contains(actual)) {
            return true;
        }
        return ContainerUtil.or(expected.getMembers(), type -> PyTypeChecker.match(type, actual, context).orElse(true));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyTypedDictType.TypeCheckingResult matchResult;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(47);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(48);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(49);
        }
        if (expected.equals(actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(50);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected.isDefinition() ^ actual.isDefinition() && !PyProtocolsKt.isProtocol((PyClassLikeType)expected, (TypeEvalContext)context)) {
            if (!expected.isDefinition() && actual.isDefinition()) {
                PyClassLikeType metaClass = actual.getMetaClassType(context, true);
                Optional<Boolean> optional = Optional.of(metaClass != null && PyTypeChecker.match((PyType)expected, metaClass.toInstance(), matchContext).orElse(true) != false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(51);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(52);
            }
            return optional;
        }
        if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
            return PyTypeChecker.match((PyTupleType)expected, (PyTupleType)actual, matchContext);
        }
        if (expected instanceof PyLiteralType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyLiteralType && PyLiteralType.Companion.match((PyLiteralType)expected, (PyLiteralType)actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(53);
            }
            return optional;
        }
        if (actual instanceof PyTypedDictType && (matchResult = PyTypedDictType.Companion.checkTypes(expected, (PyTypedDictType)actual, context, null)) != null) {
            Optional<Boolean> optional = Optional.of(matchResult.getMatch());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(54);
            }
            return optional;
        }
        if (expected instanceof PyLiteralStringType) {
            Optional<Boolean> optional = Optional.of(PyLiteralStringType.Companion.match((PyLiteralStringType)expected, actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(55);
            }
            return optional;
        }
        PyClass superClass = expected.getPyClass();
        PyClass subClass = actual.getPyClass();
        if (!subClass.isSubclass(superClass, context) && PyProtocolsKt.isProtocol((PyClassLikeType)expected, (TypeEvalContext)context)) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchProtocols(expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(56);
            }
            return optional;
        }
        if (expected instanceof PyCollectionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyCollectionType)expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(57);
            }
            return optional;
        }
        if (PyTypeChecker.matchClasses(superClass, subClass, context)) {
            if (expected instanceof PyTypingNewType && !expected.equals(actual) && superClass.equals(subClass)) {
                Optional<Boolean> optional = Optional.of(actual.getAncestorTypes(context).contains(expected));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(58);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(59);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(60);
        }
        return optional;
    }

    private static boolean matchProtocols(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyCollectionType genericSuperClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(61);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(62);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(63);
        }
        GenericSubstitutions substitutions = PyTypeChecker.collectTypeSubstitutions(actual, matchContext.context);
        MatchContext protocolContext = new MatchContext(matchContext.context, new GenericSubstitutions(), matchContext.reversedSubstitutions);
        for (kotlin.Pair pair : PyProtocolsKt.inspectProtocolSubclass((PyClassType)expected, (PyClassType)actual, (TypeEvalContext)matchContext.context)) {
            List subclassElements = (List)pair.getSecond();
            if (ContainerUtil.isEmpty(subclassElements)) {
                return false;
            }
            PyType protocolElementType = PyTypeChecker.dropSelfIfNeeded(expected, matchContext.context.getType((PyTypedElement)pair.getFirst()), matchContext.context);
            boolean elementResult = StreamEx.of((Collection)subclassElements).map(ResolveResult::getElement).select(PyTypedElement.class).map(matchContext.context::getType).map(type -> PyTypeChecker.dropSelfIfNeeded(actual, type, matchContext.context)).map(type -> PyTypeChecker.substitute(type, substitutions, matchContext.context)).anyMatch(subclassElementType -> {
                boolean matched = PyTypeChecker.match(protocolElementType, subclassElementType, protocolContext).orElse(true);
                if (!matched) {
                    return false;
                }
                if (!(protocolElementType instanceof PyFunctionType) || !(subclassElementType instanceof PyFunctionType)) {
                    return matched;
                }
                PyType protocolReturnType = ((PyFunctionType)protocolElementType).getReturnType(protocolContext.context);
                if (protocolReturnType instanceof PySelfType) {
                    PyType subclassReturnType = ((PyFunctionType)subclassElementType).getReturnType(protocolContext.context);
                    if (subclassReturnType instanceof PySelfType) {
                        return true;
                    }
                    return PyTypeChecker.match((PyType)actual, subclassReturnType, matchContext).orElse(true);
                }
                return matched;
            });
            if (elementResult) continue;
            return false;
        }
        if (expected instanceof PyCollectionType && (genericSuperClass = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), matchContext.context)) != null) {
            PyCollectionType concreteSuperClass = (PyCollectionType)PyTypeChecker.substitute(genericSuperClass, protocolContext.mySubstitutions, protocolContext.context);
            assert (concreteSuperClass != null);
            return PyTypeChecker.matchGenericClassesParameterWise((PyCollectionType)expected, concreteSuperClass, matchContext);
        }
        return true;
    }

    @Nullable
    private static PyType dropSelfIfNeeded(@NotNull PyClassType classType, @Nullable PyType elementType, @NotNull TypeEvalContext context) {
        PyFunctionType functionType;
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(64);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(65);
        }
        if (elementType instanceof PyFunctionType && (PyUtil.isInitOrNewMethod((functionType = (PyFunctionType)elementType).getCallable()) || !classType.isDefinition())) {
            return functionType.dropSelf(context);
        }
        return elementType;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(66);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(67);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(68);
        }
        if (!expected.isHomogeneous() && !actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchTypeParameters(expected.getElementTypes(), actual.getElementTypes(), context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(69);
            }
            return optional;
        }
        if (expected.isHomogeneous() && !actual.isHomogeneous()) {
            PyType expectedElementType = expected.getIteratedItemType();
            for (int i = 0; i < actual.getElementCount(); ++i) {
                if (PyTypeChecker.match(expectedElementType, actual.getElementType(i), context).orElse(true).booleanValue()) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(70);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(71);
            }
            return optional;
        }
        if (!expected.isHomogeneous() && actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(72);
            }
            return optional;
        }
        return PyTypeChecker.match(expected.getIteratedItemType(), actual.getIteratedItemType(), context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        PyClass subClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(73);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(74);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(75);
        }
        if (actual instanceof PyTupleType) {
            return PyTypeChecker.match(expected, (PyTupleType)actual, context);
        }
        PyClass superClass = expected.getPyClass();
        return PyTypeChecker.matchClasses(superClass, subClass = actual.getPyClass(), context.context) && PyTypeChecker.matchGenerics(expected, actual, context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(76);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(77);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(78);
        }
        if (!PyTypeChecker.matchClasses(expected.getPyClass(), actual.getPyClass(), context.context)) {
            return false;
        }
        PyType superElementType = expected.getIteratedItemType();
        PyType subElementType = actual.getIteratedItemType();
        return PyTypeChecker.match(superElementType, subElementType, context).orElse(true);
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyType actual, @NotNull TypeEvalContext context) {
        PyFile module;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(79);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(80);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(81);
        }
        if (actual instanceof PyStructuralType) {
            return PyTypeChecker.match(expected, (PyStructuralType)actual);
        }
        if (actual instanceof PyClassType) {
            return PyTypeChecker.match(expected, (PyClassType)actual, context);
        }
        if (actual instanceof PyModuleType && (module = ((PyModuleType)actual).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && PyTypeChecker.definesGetAttr(module, context)) {
            return true;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return !ContainerUtil.exists(expected.getAttributeNames(), attribute -> ContainerUtil.isEmpty(actual.resolveMember((String)attribute, null, AccessDirection.READ, resolveContext)));
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyStructuralType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(82);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(83);
        }
        if (expected.isInferredFromUsages()) {
            return true;
        }
        return expected.getAttributeNames().containsAll(actual.getAttributeNames());
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyClassType actual, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(84);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(85);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(86);
        }
        if (PyTypeChecker.overridesGetAttr(actual.getPyClass(), context)) {
            return true;
        }
        Set<String> actualAttributes = actual.getMemberNames(true, context);
        return actualAttributes.containsAll(expected.getAttributeNames());
    }

    private static boolean matchCallableParameters(@NotNull List<PyCallableParameter> expectedParameters, @NotNull List<PyCallableParameter> actualParameters, @NotNull MatchContext matchContext) {
        if (expectedParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(87);
        }
        if (actualParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(88);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(89);
        }
        TypeEvalContext context = matchContext.context;
        if (expectedParameters.size() == 1) {
            PyCallableParameter firstExpectedParam = expectedParameters.get(0);
            PyType expectedParamType = firstExpectedParam.getType(context);
            if (expectedParamType instanceof PyParamSpecType) {
                PyParamSpecType expectedParamSpecType = (PyParamSpecType)((Object)expectedParamType);
                matchContext.mySubstitutions.paramSpecs.put(expectedParamSpecType, expectedParamSpecType.withParameters(actualParameters, context));
                return true;
            }
            if (expectedParamType instanceof PyConcatenateType) {
                PyConcatenateType expectedConcatenateType = (PyConcatenateType)expectedParamType;
                if (actualParameters.isEmpty()) {
                    return true;
                }
                PyType actualParamType = actualParameters.get(0).getType(context);
                List<PyType> expectedFirstTypes = expectedConcatenateType.getFirstTypes();
                if (actualParamType instanceof PyConcatenateType) {
                    PyConcatenateType actualConcatenateType = (PyConcatenateType)actualParamType;
                    List<PyType> actualFirstType = actualConcatenateType.getFirstTypes();
                    if (!PyTypeChecker.match(expectedFirstTypes, actualFirstType, matchContext)) {
                        return false;
                    }
                } else {
                    int actualParamRightBound = Math.min(expectedFirstTypes.size(), actualParameters.size());
                    List<PyType> actualFirstParamTypes = ContainerUtil.map(actualParameters.subList(0, actualParamRightBound), it -> it.getType(context));
                    if (!PyTypeChecker.match(expectedFirstTypes, actualFirstParamTypes, matchContext)) {
                        return false;
                    }
                    if (actualParamRightBound < actualParameters.size()) {
                        PyParamSpecType expectedParamSpecType = expectedConcatenateType.getParamSpec();
                        List<PyCallableParameter> restActualParameters = actualParameters.subList(actualParamRightBound, actualParameters.size());
                        PyParamSpecType parametersSubst = expectedParamSpecType.withParameters(restActualParameters, context);
                        matchContext.mySubstitutions.paramSpecs.put(expectedParamSpecType, parametersSubst);
                        return true;
                    }
                }
                return true;
            }
        }
        int startIndex = 0;
        if (!expectedParameters.isEmpty() && !actualParameters.isEmpty()) {
            PyCallableParameter firstExpectedParam = expectedParameters.get(0);
            PyCallableParameter firstActualParam = actualParameters.get(0);
            if (firstExpectedParam.isSelf() && firstActualParam.isSelf()) {
                if (!PyTypeChecker.match(firstExpectedParam.getType(context), firstActualParam.getType(context), matchContext).orElse(true).booleanValue()) {
                    return false;
                }
                startIndex = 1;
            }
        }
        boolean shouldAcceptUnlimitedPositionalArgs = ContainerUtil.exists(expectedParameters, PyCallableParameter::isPositionalContainer);
        boolean canAcceptUnlimitedPositionalArgs = ContainerUtil.exists(actualParameters, PyCallableParameter::isPositionalContainer);
        if (shouldAcceptUnlimitedPositionalArgs && !canAcceptUnlimitedPositionalArgs) {
            return false;
        }
        boolean shouldAcceptArbitraryKeywordArgs = ContainerUtil.exists(expectedParameters, PyCallableParameter::isKeywordContainer);
        boolean canAcceptArbitraryKeywordArgs = ContainerUtil.exists(actualParameters, PyCallableParameter::isKeywordContainer);
        if (shouldAcceptArbitraryKeywordArgs && !canAcceptArbitraryKeywordArgs) {
            return false;
        }
        List<PyType> expectedElementTypes = ContainerUtil.map(expectedParameters, cp -> {
            PyType argType = cp.getArgumentType(context);
            if (cp.isPositionalContainer() && !(argType instanceof PyVariadicType)) {
                return PyUnpackedTupleTypeImpl.createUnbound((PyType)argType);
            }
            return argType;
        });
        PyTypeParameterMapping mapping = PyTypeParameterMapping.mapWithParameterList(ContainerUtil.subList(expectedElementTypes, startIndex), ContainerUtil.subList(actualParameters, startIndex), (TypeEvalContext)context);
        if (mapping == null) {
            return false;
        }
        for (Couple pair : mapping.getMappedTypes()) {
            Optional<Boolean> matched = matchContext.reverseSubstitutions().reversedSubstitutions ? PyTypeChecker.match((PyType)pair.getSecond(), (PyType)pair.getFirst(), matchContext.reverseSubstitutions()) : PyTypeChecker.match((PyType)pair.getFirst(), (PyType)pair.getSecond(), matchContext.reverseSubstitutions());
            if (matched.orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyCallableType expected, @NotNull PyCallableType actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(90);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(91);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(92);
        }
        if (actual instanceof PyFunctionType && expected instanceof PyClassType && "function".equals(expected.getName()) && expected.equals(PyBuiltinCache.getInstance(actual.getCallable()).getObjectType("function"))) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(93);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected instanceof PyClassLikeType && !PyTypeChecker.isCallableProtocol((PyClassLikeType)expected, context)) {
            Optional<Boolean> optional = "typing.Callable".equals(((PyClassLikeType)expected).getClassQName()) ? Optional.of(actual.isCallable()) : Optional.empty();
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(94);
            }
            return optional;
        }
        if (expected.isCallable() && actual.isCallable()) {
            List<PyCallableParameter> expectedParameters = expected.getParameters(context);
            List<PyCallableParameter> actualParameters = actual.getParameters(context);
            if (expectedParameters != null && actualParameters != null && !PyTypeChecker.matchCallableParameters(expectedParameters, actualParameters, matchContext)) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(95);
                }
                return optional;
            }
            if (!PyTypeChecker.match(expected.getReturnType(context), PyTypeChecker.getActualReturnType(actual, context), matchContext).orElse(true).booleanValue()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(96);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(97);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(98);
        }
        return optional;
    }

    private static boolean match(@NotNull List<PyType> expected, @NotNull List<PyType> actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(99);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(100);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(101);
        }
        int size = Math.min(expected.size(), actual.size());
        for (int i = 0; i < size; ++i) {
            if (PyTypeChecker.match(expected.get(i), actual.get(i), matchContext).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean isCallableProtocol(@NotNull PyClassLikeType expected, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(102);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(103);
        }
        return PyProtocolsKt.isProtocol((PyClassLikeType)expected, (TypeEvalContext)context) && expected.getMemberNames(false, context).contains("__call__");
    }

    @Nullable
    private static PyType getActualReturnType(@NotNull PyCallableType actual, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(104);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(105);
        }
        if ((callable = actual.getCallable()) instanceof PyFunction) {
            return PyUtil.getReturnTypeToAnalyzeAsCallType((PyFunction)callable, context);
        }
        return actual.getReturnType(context);
    }

    @Nullable
    private static PyTupleType widenUnionOfTuplesToTupleOfUnions(@NotNull PyUnionType unionType, int elementCount) {
        boolean consistsOfSameSizeTuples;
        if (unionType == null) {
            PyTypeChecker.$$$reportNull$$$0(106);
        }
        if (!(consistsOfSameSizeTuples = ContainerUtil.all(unionType.getMembers(), member -> {
            PyTupleType tupleType;
            return member instanceof PyTupleType && !(tupleType = (PyTupleType)member).isHomogeneous() && elementCount == tupleType.getElementCount();
        }))) {
            return null;
        }
        List newTupleElements = IntStreamEx.range((int)elementCount).mapToObj(index -> (PyType)PyTypeUtil.toStream(unionType).select(PyTupleType.class).map(tupleType -> tupleType.getElementType(index)).collect(PyTypeUtil.toUnion())).toList();
        PyClass tupleClass = ((PyTupleType)ContainerUtil.getFirstItem(unionType.getMembers())).getPyClass();
        return new PyTupleType(tupleClass, newTupleElements, false);
    }

    private static boolean matchGenerics(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(107);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(108);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(109);
        }
        if (actual instanceof PyCollectionType && expected.getPyClass().equals(actual.getPyClass())) {
            return PyTypeChecker.matchGenericClassesParameterWise(expected, (PyCollectionType)actual, context);
        }
        PyCollectionType expectedGenericType = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), context.context);
        if (expectedGenericType != null) {
            GenericSubstitutions actualSubstitutions = PyTypeChecker.collectTypeSubstitutions(actual, context.context);
            PyCollectionType concreteExpected = (PyCollectionType)PyTypeChecker.substitute(expectedGenericType, actualSubstitutions, context.context);
            assert (concreteExpected != null);
            return PyTypeChecker.matchGenericClassesParameterWise(expected, concreteExpected, context);
        }
        return true;
    }

    @NotNull
    private static GenericSubstitutions collectTypeSubstitutions(@NotNull PyClassType classType, @NotNull TypeEvalContext context) {
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(110);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(111);
        }
        GenericSubstitutions result2 = new GenericSubstitutions();
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyCollectionType genericDefinitionType;
            Map<PyType, PyType> substitutionsFromClassDefinition = provider.getGenericSubstitutions(classType.getPyClass(), context);
            for (Map.Entry<PyType, PyType> entry : substitutionsFromClassDefinition.entrySet()) {
                if (entry.getKey() instanceof PyGenericType) {
                    result2.typeVars.put((PyGenericType)((Object)entry.getKey()), entry.getValue());
                    continue;
                }
                PyType pyType = entry.getKey();
                if (!(pyType instanceof PyTypeVarTupleType)) continue;
                PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)pyType;
                assert (entry.getValue() instanceof PyVariadicType);
                result2.typeVarTuples.put(typeVarTuple, (PyVariadicType)entry.getValue());
            }
            if (!classType.isDefinition() && (genericDefinitionType = PyUtil.as(provider.getGenericType(classType.getPyClass(), context), PyCollectionType.class)) != null) {
                List<PyType> definitionTypeParameters = genericDefinitionType.getElementTypes();
                if (!(classType instanceof PyCollectionType)) {
                    for (PyType typeParameter : definitionTypeParameters) {
                        if (typeParameter instanceof PyTypeVarTupleType) {
                            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)typeParameter;
                            result2.typeVarTuples.put(typeVarTupleType, null);
                            continue;
                        }
                        if (typeParameter instanceof PyParamSpecType) {
                            PyParamSpecType paramSpecType = (PyParamSpecType)((Object)typeParameter);
                            result2.paramSpecs.put(paramSpecType, null);
                            continue;
                        }
                        if (!(typeParameter instanceof PyTypeVarType)) continue;
                        PyTypeVarType typeVarType = (PyTypeVarType)typeParameter;
                        result2.typeVars.put((PyGenericType)typeVarType, null);
                    }
                } else {
                    PyCollectionType genericType = (PyCollectionType)classType;
                    PyTypeParameterMapping mapping = PyTypeParameterMapping.mapByShape(definitionTypeParameters, genericType.getElementTypes(), (PyTypeParameterMapping.Option[])new PyTypeParameterMapping.Option[]{PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY});
                    if (mapping != null) {
                        for (Couple pair : mapping.getMappedTypes()) {
                            PyType typeParameter = (PyType)pair.getFirst();
                            PyType typeArgument = (PyType)pair.getSecond();
                            if (typeParameter instanceof PyGenericType) {
                                result2.typeVars.put((PyGenericType)((Object)typeParameter), typeArgument);
                                continue;
                            }
                            if (typeParameter instanceof PyTypeVarTupleType) {
                                PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)typeParameter;
                                assert (typeArgument instanceof PyVariadicType || typeArgument == null);
                                result2.typeVarTuples.put(typeVarTuple, (PyVariadicType)typeArgument);
                                continue;
                            }
                            if (!(typeParameter instanceof PyParamSpecType)) continue;
                            result2.getParamSpecs().put((PyParamSpecType)((Object)typeParameter), PyUtil.as(typeArgument, PyParamSpecType.class));
                        }
                    }
                }
            }
            if (result2.typeVars.isEmpty() && result2.typeVarTuples.isEmpty() && result2.paramSpecs.isEmpty()) continue;
            GenericSubstitutions genericSubstitutions = result2;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(112);
            }
            return genericSubstitutions;
        }
        GenericSubstitutions genericSubstitutions = result2;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(113);
        }
        return genericSubstitutions;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyCollectionType findGenericDefinitionType(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypeChecker.$$$reportNull$$$0(114);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(115);
        }
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyType definitionType = provider.getGenericType(pyClass, context);
            if (!(definitionType instanceof PyCollectionType)) continue;
            return (PyCollectionType)definitionType;
        }
        return null;
    }

    private static boolean matchGenericClassesParameterWise(@NotNull PyCollectionType expected, @NotNull PyCollectionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(116);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(118);
        }
        if (expected.equals(actual)) {
            return true;
        }
        if (!expected.getPyClass().equals(actual.getPyClass())) {
            return false;
        }
        List<PyType> expectedElementTypes = expected.getElementTypes();
        List<PyType> actualElementTypes = actual.getElementTypes();
        if (context.reversedSubstitutions) {
            return PyTypeChecker.matchTypeParameters(actualElementTypes, expectedElementTypes, context.resetSubstitutions());
        }
        return PyTypeChecker.matchTypeParameters(expectedElementTypes, actualElementTypes, context);
    }

    private static boolean matchTypeParameters(@NotNull List<PyType> expectedTypeParameters, @NotNull List<PyType> actualTypeParameters, @NotNull MatchContext context) {
        PyTypeParameterMapping mapping;
        if (expectedTypeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(119);
        }
        if (actualTypeParameters == null) {
            PyTypeChecker.$$$reportNull$$$0(120);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(121);
        }
        if ((mapping = PyTypeParameterMapping.mapByShape(expectedTypeParameters, actualTypeParameters, (PyTypeParameterMapping.Option[])new PyTypeParameterMapping.Option[0])) == null) {
            return false;
        }
        for (Couple pair : mapping.getMappedTypes()) {
            Optional<Boolean> matched = context.reversedSubstitutions ? PyTypeChecker.match((PyType)pair.getSecond(), (PyType)pair.getFirst(), context) : PyTypeChecker.match((PyType)pair.getFirst(), (PyType)pair.getSecond(), context);
            if (matched.orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        if (expected instanceof PyClassType && actual instanceof PyClassType) {
            String superName = ((PyClassType)expected).getPyClass().getName();
            String subName = ((PyClassType)actual).getPyClass().getName();
            boolean subIsBool = "bool".equals(subName);
            boolean subIsInt = "int".equals(subName);
            boolean subIsLong = "long".equals(subName);
            boolean subIsFloat = "float".equals(subName);
            boolean subIsComplex = "complex".equals(subName);
            if (superName == null || subName == null || superName.equals(subName) || "int".equals(superName) && subIsBool || ("long".equals(superName) || "Integral".equals(superName)) && (subIsBool || subIsInt) || ("float".equals(superName) || "Real".equals(superName)) && (subIsBool || subIsInt || subIsLong) || ("complex".equals(superName) || "Complex".equals(superName)) && (subIsBool || subIsInt || subIsLong || subIsFloat) || "Number".equals(superName) && (subIsBool || subIsInt || subIsLong || subIsFloat || subIsComplex)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnknown(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(122);
        }
        return PyTypeChecker.isUnknown(type, true, context);
    }

    public static boolean isUnknown(@Nullable PyType type, boolean genericsAreUnknown, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(123);
        }
        if (type == null || genericsAreUnknown && type instanceof PyTypeParameterType) {
            return true;
        }
        if (type instanceof PyFunctionType && (callable = ((PyFunctionType)type).getCallable()) instanceof PyDecoratable && PyKnownDecoratorUtil.hasChangingReturnTypeDecorator((PyDecoratable)((PyDecoratable)((Object)callable)), (TypeEvalContext)context)) {
            return true;
        }
        if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                if (!PyTypeChecker.isUnknown(t, genericsAreUnknown, context)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static GenericSubstitutions getSubstitutionsWithUnresolvedReturnGenerics(@NotNull Collection<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyTypeChecker.$$$reportNull$$$0(124);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(125);
        }
        GenericSubstitutions existingSubstitutions = substitutions == null ? new GenericSubstitutions() : substitutions;
        Generics typeParamsFromReturnType = PyTypeChecker.collectGenerics(returnType, context);
        if (typeParamsFromReturnType.typeVars.isEmpty()) {
            GenericSubstitutions genericSubstitutions = existingSubstitutions;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(126);
            }
            return genericSubstitutions;
        }
        HashSet visited = new HashSet();
        Generics typeParamsFromParameterTypes = new Generics();
        for (PyCallableParameter parameter : parameters) {
            PyTypeChecker.collectGenerics(parameter.getArgumentType(context), context, typeParamsFromParameterTypes, visited);
        }
        for (PyGenericType returnTypeParam : typeParamsFromReturnType.typeVars) {
            boolean isAlreadyBound;
            boolean canGetBoundFromArguments = typeParamsFromParameterTypes.typeVars.contains(returnTypeParam) || typeParamsFromParameterTypes.typeVars.contains(PyTypeChecker.invert(returnTypeParam));
            boolean bl = isAlreadyBound = existingSubstitutions.typeVars.containsKey(returnTypeParam) || existingSubstitutions.typeVars.containsKey(PyTypeChecker.invert(returnTypeParam));
            if (!canGetBoundFromArguments || isAlreadyBound) continue;
            existingSubstitutions.typeVars.put(returnTypeParam, null);
        }
        GenericSubstitutions genericSubstitutions = existingSubstitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(127);
        }
        return genericSubstitutions;
    }

    @NotNull
    private static <T extends PyInstantiableType<T>> T invert(@NotNull PyInstantiableType<T> instantiable) {
        if (instantiable == null) {
            PyTypeChecker.$$$reportNull$$$0(128);
        }
        T t = instantiable.isDefinition() ? instantiable.toInstance() : instantiable.toClass();
        if (t == null) {
            PyTypeChecker.$$$reportNull$$$0(129);
        }
        return t;
    }

    public static boolean hasGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(130);
        }
        return !PyTypeChecker.collectGenerics(type, context).isEmpty();
    }

    @ApiStatus.Internal
    @NotNull
    public static Generics collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(131);
        }
        Generics result2 = new Generics();
        PyTypeChecker.collectGenerics(type, context, result2, new HashSet());
        Generics generics = result2;
        if (generics == null) {
            PyTypeChecker.$$$reportNull$$$0(132);
        }
        return generics;
    }

    private static void collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull Generics generics, @NotNull Set<? super PyType> visited) {
        block16: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                if (context == null) {
                                    PyTypeChecker.$$$reportNull$$$0(133);
                                }
                                if (generics == null) {
                                    PyTypeChecker.$$$reportNull$$$0(134);
                                }
                                if (visited == null) {
                                    PyTypeChecker.$$$reportNull$$$0(135);
                                }
                                if (type instanceof PyTypeParameterType) {
                                    PyTypeParameterType typeParameter = (PyTypeParameterType)type;
                                    generics.allTypeParameters.add(typeParameter);
                                }
                                if (visited.contains(type)) {
                                    return;
                                }
                                visited.add(type);
                                if (type instanceof PyGenericType) {
                                    generics.typeVars.add((PyGenericType)((Object)type));
                                }
                                if (type instanceof PyTypeVarTupleType) {
                                    PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)type;
                                    generics.typeVarTuples.add(typeVarTupleType);
                                }
                                if (type instanceof PyParamSpecType) {
                                    generics.paramSpecs.add((PyParamSpecType)((Object)type));
                                }
                                if (type instanceof PyConcatenateType) {
                                    generics.concatenates.add((PyConcatenateType)type);
                                }
                                if (!(type instanceof PySelfType)) break block15;
                                generics.self = (PySelfType)((Object)type);
                                break block16;
                            }
                            if (!(type instanceof PyUnionType)) break block17;
                            PyUnionType union = (PyUnionType)type;
                            for (PyType t : union.getMembers()) {
                                PyTypeChecker.collectGenerics(t, context, generics, visited);
                            }
                            break block16;
                        }
                        if (!(type instanceof PyTupleType)) break block18;
                        PyTupleType tuple = (PyTupleType)type;
                        int n = tuple.isHomogeneous() ? 1 : tuple.getElementCount();
                        for (int i = 0; i < n; ++i) {
                            PyTypeChecker.collectGenerics(tuple.getElementType(i), context, generics, visited);
                        }
                        break block16;
                    }
                    if (!(type instanceof PyCollectionType)) break block19;
                    PyCollectionType collection = (PyCollectionType)type;
                    for (PyType elementType : collection.getElementTypes()) {
                        PyTypeChecker.collectGenerics(elementType, context, generics, visited);
                    }
                    break block16;
                }
                if (!(type instanceof PyCallableType)) break block20;
                PyCallableType callable = (PyCallableType)type;
                if (type instanceof PyClassLikeType) break block20;
                List<PyCallableParameter> parameters = callable.getParameters(context);
                if (parameters != null) {
                    for (PyCallableParameter parameter : parameters) {
                        if (parameter == null) continue;
                        PyTypeChecker.collectGenerics(parameter.getType(context), context, generics, visited);
                    }
                }
                PyTypeChecker.collectGenerics(callable.getReturnType(context), context, generics, visited);
                break block16;
            }
            if (!(type instanceof PyUnpackedTupleType)) break block16;
            PyUnpackedTupleType unpackedTupleType = (PyUnpackedTupleType)type;
            for (PyType elementType : unpackedTupleType.getElementTypes()) {
                PyTypeChecker.collectGenerics(elementType, context, generics, visited);
            }
        }
    }

    public static @NotNull List<@Nullable PyType> substituteExpand(@Nullable PyType type, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context, @NotNull Set<PyType> substituting) {
        PyUnpackedTupleType unpackedTupleType;
        PyType substituted;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(136);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(137);
        }
        if (substituting == null) {
            PyTypeChecker.$$$reportNull$$$0(138);
        }
        if ((substituted = PyTypeChecker.substitute(type, substitutions, context, substituting)) instanceof PyUnpackedTupleType && !(unpackedTupleType = (PyUnpackedTupleType)substituted).isUnbound()) {
            List list = unpackedTupleType.getElementTypes();
            if (list == null) {
                PyTypeChecker.$$$reportNull$$$0(139);
            }
            return list;
        }
        List<PyType> list = Collections.singletonList(substituted);
        if (list == null) {
            PyTypeChecker.$$$reportNull$$$0(140);
        }
        return list;
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(141);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(142);
        }
        return PyTypeChecker.substitute(type, substitutions, context, new HashSet<PyType>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PyType substitute(@Nullable PyType type, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context, @NotNull Set<PyType> substituting) {
        boolean alreadySubstituting;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(143);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(144);
        }
        if (substituting == null) {
            PyTypeChecker.$$$reportNull$$$0(145);
        }
        boolean bl = alreadySubstituting = !substituting.add(type);
        if (alreadySubstituting) {
            return null;
        }
        try {
            if (PyTypeChecker.hasGenerics(type, context)) {
                if (type instanceof PyUnpackedTupleType) {
                    PyUnpackedTupleType unpackedTupleType = (PyUnpackedTupleType)type;
                    PyUnpackedTupleTypeImpl pyUnpackedTupleTypeImpl = new PyUnpackedTupleTypeImpl(ContainerUtil.flatMap(unpackedTupleType.getElementTypes(), t -> PyTypeChecker.substituteExpand(t, substitutions, context, substituting)), unpackedTupleType.isUnbound());
                    return pyUnpackedTupleTypeImpl;
                }
                if (type instanceof PyTypeVarTupleType) {
                    PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)type;
                    if (!substitutions.typeVarTuples.containsKey(typeVarTupleType)) {
                        PyType pyType = type;
                        return pyType;
                    }
                    PyVariadicType substitution = substitutions.typeVarTuples.get(typeVarTupleType);
                    if (!typeVarTupleType.equals(substitution) && PyTypeChecker.hasGenerics((PyType)substitution, context)) {
                        PyType pyType = PyTypeChecker.substitute((PyType)substitution, substitutions, context, substituting);
                        return pyType;
                    }
                    PyUnpackedTupleType pyUnpackedTupleType = substitution == null ? PyUnpackedTupleTypeImpl.UNSPECIFIED : substitution;
                    return pyUnpackedTupleType;
                }
                if (type instanceof PyGenericType) {
                    Object invertedTypeVar;
                    PyInstantiableType invertedSubstitution;
                    PyGenericType typeVar = (PyGenericType)((Object)type);
                    if (!substitutions.typeVars.containsKey(typeVar) && !substitutions.typeVars.containsKey(PyTypeChecker.invert(typeVar))) {
                        PyGenericType pyGenericType = typeVar;
                        return pyGenericType;
                    }
                    PyType substitution = substitutions.typeVars.get(typeVar);
                    if (substitution == null && (invertedSubstitution = PyUtil.as(substitutions.typeVars.get(invertedTypeVar = PyTypeChecker.invert(typeVar)), PyInstantiableType.class)) != null) {
                        substitution = PyTypeChecker.invert(invertedSubstitution);
                    }
                    if (!typeVar.equals(substitution) && PyTypeChecker.hasGenerics(substitution, context)) {
                        invertedTypeVar = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                        return invertedTypeVar;
                    }
                    invertedTypeVar = substitution;
                    return invertedTypeVar;
                }
                if (type instanceof PyParamSpecType) {
                    PyParamSpecType paramSpecType = (PyParamSpecType)((Object)type);
                    PyParamSpecType substitution = substitutions.paramSpecs.get(paramSpecType);
                    if (substitution != null && !substitution.equals(paramSpecType) && PyTypeChecker.hasGenerics((PyType)((Object)substitution), context)) {
                        PyType invertedTypeVar = PyTypeChecker.substitute((PyType)((Object)substitution), substitutions, context);
                        return invertedTypeVar;
                    }
                    PyParamSpecType invertedTypeVar = substitution;
                    return invertedTypeVar;
                }
                if (type instanceof PySelfType) {
                    PyType qualifierType = substitutions.qualifierType;
                    PyClassLikeType selfScopeClassType = ((PySelfType)((Object)type)).getScopeClassType();
                    PyType invertedSubstitution = (PyType)((StreamEx)PyTypeUtil.toStream(qualifierType).filter(memberType -> PyTypeChecker.match((PyType)selfScopeClassType, memberType, context))).collect(PyTypeUtil.toUnion());
                    return invertedSubstitution;
                }
                if (type instanceof PyUnionType) {
                    PyType qualifierType = ((PyUnionType)type).map(member -> PyTypeChecker.substitute(member, substitutions, context, substituting));
                    return qualifierType;
                }
                if (type instanceof PyTypedDictType) {
                    PyTypedDictType typedDictType = (PyTypedDictType)type;
                    Map<String, kotlin.Pair<PyExpression, PyType>> tdFields = typedDictType.getKeysToValuesWithTypes();
                    Map substitutedTDFields = ContainerUtil.map2Map(tdFields.entrySet(), field -> Pair.create((String)field.getKey(), new kotlin.Pair((Object)((PyExpression)((kotlin.Pair)field.getValue()).getFirst()), (Object)PyTypeChecker.substitute((PyType)((kotlin.Pair)field.getValue()).getSecond(), substitutions, context, substituting))));
                    PyTypedDictType invertedSubstitution = PyTypedDictType.Companion.createFromKeysToValueTypes(typedDictType.myClass, substitutedTDFields, false);
                    return invertedSubstitution;
                }
                if (type instanceof PyCollectionTypeImpl) {
                    PyCollectionTypeImpl collection = (PyCollectionTypeImpl)type;
                    PyCollectionTypeImpl tdFields = new PyCollectionTypeImpl(collection.getPyClass(), collection.isDefinition(), ContainerUtil.flatMap(collection.getElementTypes(), t -> PyTypeChecker.substituteExpand(t, substitutions, context, substituting)));
                    return tdFields;
                }
                if (type instanceof PyTupleType) {
                    PyTupleType tupleType = (PyTupleType)type;
                    PyClass tupleClass = tupleType.getPyClass();
                    List<PyType> oldElementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                    ArrayList newElementTypes = new ArrayList(ContainerUtil.flatMap(oldElementTypes, elementType -> PyTypeChecker.substituteExpand(elementType, substitutions, context, substituting)));
                    PyTupleType pyTupleType = new PyTupleType(tupleClass, newElementTypes, tupleType.isHomogeneous());
                    return pyTupleType;
                }
                if (type instanceof PyCallableType) {
                    PyCallableType callable = (PyCallableType)type;
                    if (!(type instanceof PyClassLikeType)) {
                        List<PyCallableParameter> substParams = null;
                        List<PyCallableParameter> parameters = callable.getParameters(context);
                        if (parameters != null) {
                            substParams = new ArrayList<PyCallableParameter>();
                            for (PyCallableParameter parameter : parameters) {
                                PyConcatenateType concatenateType;
                                PyParamSpecType paramSpecType;
                                PyParamSpecType paramSpecTypeSubst;
                                PyParamSpecType parameterTypeSubst;
                                PyType parameterType = parameter.getType(context);
                                if (parameters.size() == 1 && parameterType instanceof PyParamSpecType && (parameterTypeSubst = substitutions.paramSpecs.get(parameterType)) != null && parameterTypeSubst.getParameters() != null) {
                                    substParams = parameterTypeSubst.getParameters();
                                    break;
                                }
                                if (parameters.size() == 1 && parameterType instanceof PyConcatenateType && (paramSpecTypeSubst = substitutions.paramSpecs.get(paramSpecType = (concatenateType = (PyConcatenateType)parameterType).getParamSpec())) != null && paramSpecTypeSubst.getParameters() != null) {
                                    List<PyCallableParameter> firstParameters = ContainerUtil.map(concatenateType.getFirstTypes(), it -> PyCallableParameterImpl.nonPsi(it));
                                    substParams.addAll(firstParameters);
                                    substParams.addAll(paramSpecTypeSubst.getParameters());
                                    break;
                                }
                                List<PyType> substTypes = PyTypeChecker.substituteExpand(parameter.getType(context), substitutions, context, substituting);
                                PyParameter psi = parameter.getParameter();
                                List<PyCallableParameter> substs = psi != null ? ContainerUtil.map(substTypes, it -> PyCallableParameterImpl.psi(psi, it)) : ContainerUtil.map(substTypes, it -> PyCallableParameterImpl.nonPsi(parameter.getName(), it, parameter.getDefaultValue()));
                                substParams.addAll(substs);
                            }
                        }
                        PyType substResult = PyTypeChecker.substitute(callable.getReturnType(context), substitutions, context, substituting);
                        PyCallableTypeImpl pyCallableTypeImpl = new PyCallableTypeImpl(substParams, substResult);
                        return pyCallableTypeImpl;
                    }
                }
            }
        }
        finally {
            substituting.remove(type);
        }
        return type;
    }

    @Nullable
    public static GenericSubstitutions unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(146);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(147);
        }
        GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiver, context);
        for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType actualType;
            PyCallableParameter paramWrapper = entry.getValue();
            PyType expectedType = paramWrapper.getArgumentType(context);
            PyType promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(entry.getKey(), expectedType, context, substitutions);
            PyType pyType = actualType = promotedToLiteral != null ? promotedToLiteral : context.getType(entry.getKey());
            if (paramWrapper.isSelf()) {
                PyParameter param = paramWrapper.getParameter();
                PyFunction function = PyUtil.as(ScopeUtil.getScopeOwner(param), PyFunction.class);
                assert (function != null);
                if (function.getModifier() == PyFunction.Modifier.CLASSMETHOD) {
                    actualType = PyTypeUtil.toStream(actualType).select(PyClassLikeType.class).map(PyInstantiableType::toClass).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
                } else if (PyUtil.isInitMethod(function)) {
                    actualType = PyTypeUtil.toStream(actualType).select(PyInstantiableType.class).map(PyInstantiableType::toInstance).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
                }
                PyClass containingClass = function.getContainingClass();
                assert (containingClass != null);
                PyCollectionType genericClass = PyTypeChecker.findGenericDefinitionType(containingClass, context);
                if (genericClass != null && !PyTypeChecker.match((PyType)genericClass, expectedType, context, substitutions)) {
                    return null;
                }
            }
            if (PyTypeChecker.match(expectedType, actualType, context, substitutions)) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedPositionalContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedKeywordContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    private static boolean matchContainer(@Nullable PyCallableParameter container, @NotNull List<? extends PyExpression> arguments, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(148);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(149);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(150);
        }
        if (container == null) {
            return true;
        }
        List<PyType> actualArgumentTypes = ContainerUtil.map(arguments, context::getType);
        PyType expectedArgumentType = container.getArgumentType(context);
        if (container.isPositionalContainer() && expectedArgumentType instanceof PyVariadicType) {
            PyVariadicType variadicType = (PyVariadicType)expectedArgumentType;
            return PyTypeChecker.match(variadicType, (PyType)PyUnpackedTupleTypeImpl.create(actualArgumentTypes), new MatchContext(context, substitutions, false));
        }
        return PyTypeChecker.match(expectedArgumentType, PyUnionType.union(actualArgumentTypes), context, substitutions);
    }

    @NotNull
    public static GenericSubstitutions unifyReceiver(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(151);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions();
        if (receiver != null) {
            PyType receiverType = context.getType(receiver);
            substitutions.qualifierType = receiverType instanceof PyClassType ? ((PyClassType)receiverType).toInstance() : receiverType;
            PyTypeUtil.toStream(receiverType).select(PyClassType.class).map(type -> PyTypeChecker.collectTypeSubstitutions(type, context)).forEach(newSubstitutions -> {
                for (Map.Entry<PyGenericType, PyType> entry : newSubstitutions.typeVars.entrySet()) {
                    substitutions.typeVars.putIfAbsent(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<PyGenericType, PyType> entry : newSubstitutions.typeVarTuples.entrySet()) {
                    substitutions.typeVarTuples.putIfAbsent((PyTypeVarTupleType)entry.getKey(), (PyVariadicType)entry.getValue());
                }
                for (Map.Entry<Object, Object> entry : newSubstitutions.paramSpecs.entrySet()) {
                    substitutions.paramSpecs.putIfAbsent((PyParamSpecType)entry.getKey(), (PyParamSpecType)entry.getValue());
                }
            });
        }
        GenericSubstitutions genericSubstitutions = substitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(152);
        }
        return genericSubstitutions;
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(153);
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass, context) || PyABCUtil.isSubclass(subClass, superClass, context) || PyTypeChecker.isStrUnicodeMatch(subClass, superClass) || PyTypeChecker.isBytearrayBytesStringMatch(subClass, superClass) || PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    private static boolean isStrUnicodeMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(154);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(155);
        }
        return "str".equals(subClass.getName()) && "unicode".equals(superClass.getName());
    }

    private static boolean isBytearrayBytesStringMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(156);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(157);
        }
        if (!"bytearray".equals(subClass.getName())) {
            return false;
        }
        PsiFile subClassFile = subClass.getContainingFile();
        boolean isPy2 = subClassFile instanceof PyiFile ? PythonRuntimeService.getInstance().getLanguageLevelForSdk(PythonSdkUtil.findPythonSdk((PsiElement)subClassFile)).isPython2() : LanguageLevel.forElement(subClass).isPython2();
        String superClassName = superClass.getName();
        return isPy2 && "str".equals(superClassName) || !isPy2 && "bytes".equals(superClassName);
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType) {
            return PyTypeChecker.isUnionCallable((PyUnionType)type);
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).isCallable();
        }
        if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
            return true;
        }
        if (type instanceof PyGenericType) {
            if (((PyGenericType)((Object)type)).isDefinition()) {
                return true;
            }
            return PyTypeChecker.isCallable(((PyGenericType)((Object)type)).getBound());
        }
        return false;
    }

    @Nullable
    private static Boolean isUnionCallable(@NotNull PyUnionType type) {
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(158);
        }
        for (PyType member : type.getMembers()) {
            Boolean callable = PyTypeChecker.isCallable(member);
            if (callable == null) {
                return null;
            }
            if (!callable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean definesGetAttr(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        PyType type;
        if (file == null) {
            PyTypeChecker.$$$reportNull$$$0(159);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(160);
        }
        if (file instanceof PyTypedElement && (type = context.getType((PyTypedElement)((Object)file))) != null) {
            return PyTypeChecker.resolveTypeMember(type, "__getattr__", context) != null;
        }
        return false;
    }

    public static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyType type;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(161);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(162);
        }
        if ((type = context.getType(cls)) != null) {
            if (PyTypeChecker.resolveTypeMember(type, "__getattr__", context) != null) {
                return true;
            }
            PsiElement method = PyTypeChecker.resolveTypeMember(type, "__getattribute__", context);
            if (method != null && !PyBuiltinCache.getInstance(cls).isBuiltin(method)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(163);
        }
        if (name == null) {
            PyTypeChecker.$$$reportNull$$$0(164);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(165);
        }
        return !ContainerUtil.isEmpty(results = type.resolveMember(name, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) ? results.get(0).getElement() : null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target, @NotNull PyTupleExpression parentTuple, @NotNull PyType assignedType, @NotNull TypeEvalContext context) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(166);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(167);
        }
        if (assignedType == null) {
            PyTypeChecker.$$$reportNull$$$0(168);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(169);
        }
        if (assignedType instanceof PyTupleType) {
            return PyTypeChecker.getTargetTypeFromTupleAssignment(target, parentTuple, (PyTupleType)assignedType);
        }
        if (assignedType instanceof PyClassLikeType) {
            return StreamEx.of(((PyClassLikeType)assignedType).getAncestorTypes(context)).select(PyNamedTupleType.class).findFirst().map(t -> PyTypeChecker.getTargetTypeFromTupleAssignment(target, parentTuple, t)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target, @NotNull PyTupleExpression parentTuple, @NotNull PyTupleType assignedTupleType) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(170);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(171);
        }
        if (assignedTupleType == null) {
            PyTypeChecker.$$$reportNull$$$0(172);
        }
        int count = assignedTupleType.getElementCount();
        Object[] elements = parentTuple.getElements();
        if (elements.length == count || assignedTupleType.isHomogeneous()) {
            int index = ArrayUtil.indexOf(elements, target);
            if (index >= 0) {
                return assignedTupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyType result2;
                PyType elementType;
                Object element = elements[i];
                while (element instanceof PyParenthesizedExpression) {
                    element = ((PyParenthesizedExpression)element).getContainedExpression();
                }
                if (!(element instanceof PyTupleExpression) || !((elementType = assignedTupleType.getElementType(i)) instanceof PyTupleType) || (result2 = PyTypeChecker.getTargetTypeFromTupleAssignment(target, (PyTupleExpression)element, (PyTupleType)elementType)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType parameterizeType(@NotNull PyType genericType, @NotNull List<PyType> actualTypeParams, @NotNull TypeEvalContext context) {
        Generics typeParams;
        if (genericType == null) {
            PyTypeChecker.$$$reportNull$$$0(173);
        }
        if (actualTypeParams == null) {
            PyTypeChecker.$$$reportNull$$$0(174);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(175);
        }
        if (!(typeParams = PyTypeChecker.collectGenerics(genericType, context)).isEmpty()) {
            GenericSubstitutions substitutions = new GenericSubstitutions();
            ArrayList<PyTypeParameterType> expectedTypeParams = new ArrayList<PyTypeParameterType>(new LinkedHashSet<PyTypeParameterType>(typeParams.getAllTypeParameters()));
            PyTypeParameterMapping mapping = PyTypeParameterMapping.mapByShape(expectedTypeParams, actualTypeParams, (PyTypeParameterMapping.Option[])new PyTypeParameterMapping.Option[]{PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY});
            if (mapping != null) {
                for (Couple pair : mapping.getMappedTypes()) {
                    Object object = pair.getFirst();
                    if (object instanceof PyTypeVarType) {
                        PyTypeVarType typeVar = (PyTypeVarType)object;
                        substitutions.typeVars.put((PyGenericType)typeVar, (PyType)pair.getSecond());
                        continue;
                    }
                    object = pair.getFirst();
                    if (!(object instanceof PyTypeVarTupleType)) continue;
                    PyTypeVarTupleType typeVarTuple = (PyTypeVarTupleType)object;
                    assert (pair.getSecond() instanceof PyVariadicType);
                    substitutions.typeVarTuples.put(typeVarTuple, (PyVariadicType)pair.getSecond());
                }
            }
            return PyTypeChecker.substitute(genericType, substitutions, context);
        }
        if (genericType instanceof PyCollectionType) {
            return genericType;
        }
        if (genericType instanceof PyClassType) {
            PyClass cls = ((PyClassType)genericType).getPyClass();
            return new PyCollectionTypeImpl(cls, false, actualTypeParams);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 43, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 69, 70, 71, 72, 93, 94, 95, 96, 97, 98, 112, 113, 126, 127, 129, 132, 139, 140, 152 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVars";
                break;
            }
            case 4: 
            case 136: 
            case 141: 
            case 143: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 126: 
            case 127: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 47: 
            case 61: 
            case 66: 
            case 73: 
            case 76: 
            case 79: 
            case 82: 
            case 84: 
            case 90: 
            case 99: 
            case 102: 
            case 107: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 38: 
            case 41: 
            case 45: 
            case 48: 
            case 62: 
            case 67: 
            case 74: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 91: 
            case 100: 
            case 104: 
            case 108: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 49: 
            case 63: 
            case 89: 
            case 92: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 64: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedParameters";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeParameters";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParameters";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiable";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 138: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituting";
                break;
            }
            case 146: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 154: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 155: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 158: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 166: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 167: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTuple";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedType";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTupleType";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 6: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "matchImpl";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "matchObject";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeSubstitutions";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGenerics";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteExpand";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 112: 
            case 113: 
            case 126: 
            case 127: 
            case 129: 
            case 132: 
            case 139: 
            case 140: 
            case 152: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "matchObject";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "matchProtocols";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "dropSelfIfNeeded";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "matchCallableParameters";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isCallableProtocol";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getActualReturnType";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "widenUnionOfTuplesToTupleOfUnions";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "matchGenerics";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeSubstitutions";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "findGenericDefinitionType";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericClassesParameterWise";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeParameters";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "hasGenerics";
                break;
            }
            case 131: 
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "collectGenerics";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "substituteExpand";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCall";
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "matchContainer";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "unifyReceiver";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "matchClasses";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "isStrUnicodeMatch";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "isBytearrayBytesStringMatch";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "isUnionCallable";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "definesGetAttr";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "overridesGetAttr";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeMember";
                break;
            }
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromTupleAssignment";
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "parameterizeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 43, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 69, 70, 71, 72, 93, 94, 95, 96, 97, 98, 112, 113, 126, 127, 129, 132, 139, 140, 152 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Experimental
    public static class GenericSubstitutions {
        @NotNull
        private final Map<PyGenericType, PyType> typeVars;
        @NotNull
        private final Map<PyTypeVarTupleType, PyVariadicType> typeVarTuples;
        @NotNull
        private final Map<PyParamSpecType, PyParamSpecType> paramSpecs;
        @Nullable
        private PyType qualifierType;

        public GenericSubstitutions(@NotNull Map<PyGenericType, PyType> typeVars) {
            if (typeVars == null) {
                GenericSubstitutions.$$$reportNull$$$0(0);
            }
            this(typeVars, new LinkedHashMap<PyTypeVarTupleType, PyVariadicType>(), new LinkedHashMap<PyParamSpecType, PyParamSpecType>(), null);
        }

        public GenericSubstitutions() {
            this(new LinkedHashMap<PyGenericType, PyType>(), new LinkedHashMap<PyTypeVarTupleType, PyVariadicType>(), new LinkedHashMap<PyParamSpecType, PyParamSpecType>(), null);
        }

        GenericSubstitutions(@NotNull Map<PyGenericType, PyType> typeVars, @NotNull Map<PyTypeVarTupleType, PyVariadicType> typeVarTuples, @NotNull Map<PyParamSpecType, PyParamSpecType> paramSpecs, @Nullable PyType qualifierType) {
            if (typeVars == null) {
                GenericSubstitutions.$$$reportNull$$$0(1);
            }
            if (typeVarTuples == null) {
                GenericSubstitutions.$$$reportNull$$$0(2);
            }
            if (paramSpecs == null) {
                GenericSubstitutions.$$$reportNull$$$0(3);
            }
            this.typeVars = typeVars;
            this.typeVarTuples = typeVarTuples;
            this.paramSpecs = paramSpecs;
            this.qualifierType = qualifierType;
        }

        @NotNull
        public Map<PyParamSpecType, PyParamSpecType> getParamSpecs() {
            Map<PyParamSpecType, PyParamSpecType> map = this.paramSpecs;
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(4);
            }
            return map;
        }

        @NotNull
        public Map<PyGenericType, PyType> getTypeVars() {
            Map<PyGenericType, PyType> map = this.typeVars;
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(5);
            }
            return map;
        }

        @NotNull
        public Map<PyTypeVarTupleType, PyVariadicType> getTypeVarTuples() {
            Map<PyTypeVarTupleType, PyVariadicType> map = this.typeVarTuples;
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(6);
            }
            return map;
        }

        @Nullable
        public PyType getQualifierType() {
            return this.qualifierType;
        }

        public String toString() {
            return "GenericSubstitutions{typeVars=" + this.typeVars + ", typeVarTuples" + this.typeVarTuples + ", paramSpecs=" + this.paramSpecs + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVarTuples";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpecs";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVarTuples";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class MatchContext {
        @NotNull
        private final TypeEvalContext context;
        @NotNull
        private final GenericSubstitutions mySubstitutions;
        private final boolean reversedSubstitutions;

        MatchContext(@NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions, boolean reversedSubstitutions) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(0);
            }
            if (substitutions == null) {
                MatchContext.$$$reportNull$$$0(1);
            }
            this.context = context;
            this.mySubstitutions = substitutions;
            this.reversedSubstitutions = reversedSubstitutions;
        }

        @NotNull
        public MatchContext reverseSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, !this.reversedSubstitutions);
        }

        @NotNull
        public MatchContext resetSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/types/PyTypeChecker$MatchContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class Generics {
        @NotNull
        private final Set<PyGenericType> typeVars = new LinkedHashSet<PyGenericType>();
        @NotNull
        private final Set<PyTypeVarTupleType> typeVarTuples = new LinkedHashSet<PyTypeVarTupleType>();
        @NotNull
        private final List<PyTypeParameterType> allTypeParameters = new ArrayList<PyTypeParameterType>();
        @NotNull
        private final Set<PyParamSpecType> paramSpecs = new LinkedHashSet<PyParamSpecType>();
        @NotNull
        private final Set<PyConcatenateType> concatenates = new LinkedHashSet<PyConcatenateType>();
        @Nullable
        private PySelfType self;

        @NotNull
        public Set<PyGenericType> getTypeVars() {
            Set<PyGenericType> set = Collections.unmodifiableSet(this.typeVars);
            if (set == null) {
                Generics.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public Set<PyTypeVarTupleType> getTypeVarTuples() {
            Set<PyTypeVarTupleType> set = Collections.unmodifiableSet(this.typeVarTuples);
            if (set == null) {
                Generics.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public List<PyTypeParameterType> getAllTypeParameters() {
            List<PyTypeParameterType> list = Collections.unmodifiableList(this.allTypeParameters);
            if (list == null) {
                Generics.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public Set<PyParamSpecType> getParamSpecs() {
            Set<PyParamSpecType> set = Collections.unmodifiableSet(this.paramSpecs);
            if (set == null) {
                Generics.$$$reportNull$$$0(3);
            }
            return set;
        }

        public boolean isEmpty() {
            return this.typeVars.isEmpty() && this.typeVarTuples.isEmpty() && this.paramSpecs.isEmpty() && this.concatenates.isEmpty() && this.self == null;
        }

        public String toString() {
            return "Generics{typeVars=" + this.typeVars + ", typeVarTuples" + this.typeVarTuples + ", paramSpecs=" + this.paramSpecs + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/psi/types/PyTypeChecker$Generics";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVarTuples";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllTypeParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

