/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.tree.PyComment;

public final class PySpace {
    public static Space appendWhitespace(Space space, String whitespace) {
        if (!space.getComments().isEmpty()) {
            return space.withComments(ListUtils.mapLast((List)space.getComments(), comment -> comment.withSuffix(comment.getSuffix() + whitespace)));
        }
        return space.withWhitespace(space.getWhitespace() + whitespace);
    }

    public static Space appendComment(Space space, String commentWithHash) {
        String commentText = PySpace.validateComment(commentWithHash);
        return space.withComments(ListUtils.concat((List)space.getComments(), (Object)new PyComment(commentText, "", false, Markers.EMPTY)));
    }

    private static String validateComment(String commentWithHash) {
        if (!commentWithHash.startsWith("#")) {
            throw new IllegalArgumentException("comment should start with a hash");
        }
        if (commentWithHash.contains("\n")) {
            throw new IllegalArgumentException("comment cannot contain newlines");
        }
        return commentWithHash.substring(1);
    }

    public static Space reindent(Space original, String indentWithoutNewline, IndentStartMode startMode, IndentEndMode endMode) {
        if (indentWithoutNewline.contains("\n")) {
            throw new IllegalArgumentException("argument to `deindent` should not contain newline: " + Space.build((String)indentWithoutNewline, Collections.emptyList()));
        }
        if (indentWithoutNewline.isEmpty()) {
            return original;
        }
        switch (endMode) {
            case REST_OF_LINE: {
                if (original.getLastWhitespace().endsWith("\n")) break;
                throw new IllegalStateException("expected statement suffix to end with a newline: " + original);
            }
            case STATEMENT_START: {
                if (!(!original.getComments().isEmpty() || original.getLastWhitespace().contains("\n") ? !original.getLastWhitespace().endsWith("\n") : !original.getLastWhitespace().isEmpty())) break;
                throw new IllegalStateException("expected statement prefix to end with an indent placeholder: " + original);
            }
        }
        Space space = Space.build((String)original.getWhitespace(), Collections.emptyList());
        List originalComments = original.getComments();
        if (original.getComments().isEmpty()) {
            if (startMode == IndentStartMode.LINE_START && endMode == IndentEndMode.STATEMENT_START && (original.getWhitespace().isEmpty() || original.getWhitespace().endsWith("\n"))) {
                space = PySpace.appendWhitespace(space, indentWithoutNewline);
            }
        } else {
            for (int i = 0; i < originalComments.size(); ++i) {
                Comment originalComment = (Comment)originalComments.get(i);
                PyComment comment = (PyComment)originalComment;
                if (comment.isAlignedToIndent() && (i != 0 || startMode == IndentStartMode.LINE_START) && (space.getLastWhitespace().isEmpty() || space.getLastWhitespace().endsWith("\n"))) {
                    space = PySpace.appendWhitespace(space, indentWithoutNewline);
                }
                space = space.withComments(ListUtils.concat((List)space.getComments(), (Object)comment));
            }
            if (endMode == IndentEndMode.STATEMENT_START) {
                space = PySpace.appendWhitespace(space, indentWithoutNewline);
            }
        }
        return space;
    }

    public static Space deindent(Space original, String indentWithoutNewline, IndentStartMode startMode, IndentEndMode endMode) {
        Space space;
        boolean currentlyIndented;
        if (indentWithoutNewline.contains("\n")) {
            throw new IllegalArgumentException("argument to `deindent` should not contain newline: " + Space.build((String)indentWithoutNewline, Collections.emptyList()));
        }
        if (indentWithoutNewline.isEmpty()) {
            return original;
        }
        String indentWithNewline = "\n" + indentWithoutNewline;
        switch (endMode) {
            case REST_OF_LINE: {
                if (original.getLastWhitespace().endsWith("\n")) break;
                throw new IllegalStateException("expected statement suffix to end with a newline");
            }
            case STATEMENT_START: {
                if (!(!original.getComments().isEmpty() || original.getLastWhitespace().contains("\n") ? !original.getLastWhitespace().endsWith(indentWithNewline) : !original.getLastWhitespace().equals(indentWithoutNewline))) break;
                throw new IllegalStateException("expected statement prefix to end with an indent");
            }
        }
        if (startMode == IndentStartMode.LINE_START && original.getWhitespace().equals(indentWithoutNewline)) {
            if (endMode == IndentEndMode.STATEMENT_START || !original.getComments().isEmpty()) {
                currentlyIndented = true;
                space = Space.EMPTY;
            } else {
                currentlyIndented = false;
                space = Space.build((String)original.getWhitespace(), Collections.emptyList());
            }
        } else if (original.getWhitespace().endsWith(indentWithNewline)) {
            currentlyIndented = true;
            space = Space.build((String)original.getWhitespace().substring(0, original.getWhitespace().length() - indentWithoutNewline.length()), Collections.emptyList());
        } else {
            currentlyIndented = false;
            space = Space.build((String)original.getWhitespace(), Collections.emptyList());
        }
        List originalComments = original.getComments();
        for (int i = 0; i < originalComments.size(); ++i) {
            boolean isLastComment;
            Comment originalComment = (Comment)originalComments.get(i);
            PyComment comment = (PyComment)originalComment;
            comment = comment.withAlignedToIndent(currentlyIndented);
            boolean bl = isLastComment = i == originalComments.size() - 1;
            if (!isLastComment || endMode == IndentEndMode.STATEMENT_START) {
                currentlyIndented = comment.getSuffix().endsWith(indentWithNewline);
                if (currentlyIndented) {
                    comment = comment.withSuffix(comment.getSuffix().substring(0, comment.getSuffix().length() - indentWithoutNewline.length()));
                }
            } else {
                currentlyIndented = false;
            }
            space = space.withComments(ListUtils.concat((List)space.getComments(), (Object)comment));
        }
        return space;
    }

    public static Space stripIndent(Space space, String expectedIndent) {
        if (space.getComments().isEmpty()) {
            String ws = space.getWhitespace();
            if (!ws.endsWith(expectedIndent)) {
                throw new IllegalStateException("expected statement prefix to end with block indent");
            }
            space = space.withWhitespace(ws.substring(0, ws.length() - expectedIndent.length()));
        } else {
            space = space.withComments(ListUtils.mapLast((List)space.getComments(), lastComment -> {
                String suffix = lastComment.getSuffix();
                if (!suffix.endsWith(expectedIndent)) {
                    throw new IllegalStateException("expected statement prefix to end with block indent");
                }
                return lastComment.withSuffix(suffix.substring(0, suffix.length() - expectedIndent.length()));
            }));
        }
        return space;
    }

    private PySpace() {
    }

    public static enum IndentEndMode {
        STATEMENT_START,
        REST_OF_LINE;

    }

    public static enum IndentStartMode {
        LINE_START,
        AFTER_STATEMENT;

    }

    public static enum Location {
        ASSERT_PREFIX,
        ASSERT_ELEMENT_SUFFIX,
        AWAIT_PREFIX,
        COMPREHENSION_CLAUSE_PREFIX,
        COMPREHENSION_CONDITION_PREFIX,
        COMPREHENSION_IN,
        COMPREHENSION_PREFIX,
        COMPREHENSION_SUFFIX,
        NAMED_ARGUMENT_PREFIX,
        DEL_ELEMENT_SUFFIX,
        DEL_PREFIX,
        DICT_ENTRY,
        DICT_ENTRY_KEY_SUFFIX,
        DICT_LITERAL_ELEMENT_SUFFIX,
        DICT_LITERAL_PREFIX,
        ELSE_WRAPPER_PREFIX,
        EXCEPTION_TYPE_PREFIX,
        ERROR_FROM_PREFIX,
        ERROR_FROM_SOURCE,
        KEY_VALUE_PREFIX,
        KEY_VALUE_SUFFIX,
        MATCH_CASE_GUARD,
        MATCH_CASE_PREFIX,
        MATCH_PATTERN_PREFIX,
        MATCH_PATTERN_ELEMENT_PREFIX,
        MATCH_PATTERN_ELEMENT_SUFFIX,
        NAMED_ARGUMENT,
        PASS_PREFIX,
        SPECIAL_ARG_PREFIX,
        SPECIAL_PARAM_PREFIX,
        TOP_LEVEL_STATEMENT,
        TRAILING_ELSE_WRAPPER_PREFIX,
        TYPE_HINT_PREFIX,
        TYPE_HINTED_EXPRESSION_PREFIX,
        VARIABLE_SCOPE_NAME_SUFFIX,
        VARIABLE_SCOPE_PREFIX,
        YIELD_FROM_PREFIX,
        YIELD_PREFIX,
        YIELD_ELEMENT_SUFFIX;

    }

    public static final class SpaceBuilder {
        @Nullable
        private String initialWhitespace;
        @Nullable
        private List<Comment> comments;
        @Nullable
        private StringBuilder whitespaceBuilder;
        @Nullable
        private String nextComment;

        private String finishWhitespace() {
            if (this.whitespaceBuilder == null) {
                return "";
            }
            String ws = this.whitespaceBuilder.toString();
            this.whitespaceBuilder.setLength(0);
            return ws;
        }

        private void finishComment() {
            String whitespace = this.finishWhitespace();
            if (this.nextComment != null) {
                if (this.comments == null) {
                    this.comments = new ArrayList<Comment>();
                }
                this.comments.add(new PyComment(this.nextComment, whitespace, false, Markers.EMPTY));
            } else if (!whitespace.isEmpty()) {
                if (this.initialWhitespace != null) {
                    throw new IllegalStateException("unexpected");
                }
                this.initialWhitespace = whitespace;
            }
        }

        public SpaceBuilder addWhitespace(String whitespace) {
            if (this.whitespaceBuilder == null) {
                this.whitespaceBuilder = new StringBuilder();
            }
            this.whitespaceBuilder.append(whitespace);
            return this;
        }

        public SpaceBuilder addComment(String commentWithHash) {
            this.finishComment();
            this.nextComment = commentWithHash;
            return this;
        }

        public Space build() {
            this.finishComment();
            Space space = Space.build((String)(this.initialWhitespace == null ? "" : this.initialWhitespace), this.comments == null ? Collections.emptyList() : this.comments);
            this.reset();
            return space;
        }

        public SpaceBuilder reset() {
            this.initialWhitespace = null;
            this.whitespaceBuilder.setLength(0);
            this.comments = null;
            return this;
        }
    }
}

