/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.data.repository.query;

import org.springframework.data.spel.spi.EvaluationContextExtension;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityEvaluationContextExtension
implements EvaluationContextExtension {
    private Authentication authentication;
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();
    private String defaultRolePrefix = "ROLE_";

    public SecurityEvaluationContextExtension() {
    }

    public SecurityEvaluationContextExtension(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getExtensionId() {
        return "security";
    }

    public SecurityExpressionRoot getRootObject() {
        Authentication authentication = this.getAuthentication();
        SecurityExpressionRoot root = new SecurityExpressionRoot(authentication){};
        root.setTrustResolver(this.trustResolver);
        root.setRoleHierarchy(this.roleHierarchy);
        root.setPermissionEvaluator(this.permissionEvaluator);
        root.setDefaultRolePrefix(this.defaultRolePrefix);
        return root;
    }

    private Authentication getAuthentication() {
        if (this.authentication != null) {
            return this.authentication;
        }
        SecurityContext context = SecurityContextHolder.getContext();
        return context.getAuthentication();
    }
}

