/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.handler.invocation.reactive;

import java.lang.annotation.Annotation;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodArgumentResolver;
import org.springframework.security.core.annotation.CurrentSecurityContext;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class CurrentSecurityContextArgumentResolver
implements HandlerMethodArgumentResolver {
    private ExpressionParser parser = new SpelExpressionParser();
    private BeanResolver beanResolver;
    private ReactiveAdapterRegistry adapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    public void setAdapterRegistry(ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)adapterRegistry, (String)"adapterRegistry cannot be null");
        this.adapterRegistry = adapterRegistry;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return this.isMonoSecurityContext(parameter) || this.findMethodAnnotation(CurrentSecurityContext.class, parameter) != null;
    }

    private boolean isMonoSecurityContext(MethodParameter parameter) {
        boolean isParameterPublisher = Publisher.class.isAssignableFrom(parameter.getParameterType());
        if (isParameterPublisher) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
            Class genericType = resolvableType.resolveGeneric(new int[]{0});
            if (genericType == null) {
                return false;
            }
            return SecurityContext.class.isAssignableFrom(genericType);
        }
        return false;
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, Message<?> message) {
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(parameter.getParameterType());
        return ReactiveSecurityContextHolder.getContext().flatMap(securityContext -> {
            Object sc = this.resolveSecurityContext(parameter, securityContext);
            Mono result = Mono.justOrEmpty((Object)sc);
            return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)result)) : result;
        });
    }

    private Object resolveSecurityContext(MethodParameter parameter, Object securityContext) {
        CurrentSecurityContext contextAnno = this.findMethodAnnotation(CurrentSecurityContext.class, parameter);
        if (contextAnno != null) {
            return this.resolveSecurityContextFromAnnotation(contextAnno, parameter, securityContext);
        }
        return securityContext;
    }

    private Object resolveSecurityContextFromAnnotation(CurrentSecurityContext contextAnno, MethodParameter parameter, Object securityContext) {
        String expressionToParse = contextAnno.expression();
        if (StringUtils.hasLength((String)expressionToParse)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(securityContext);
            context.setVariable("this", securityContext);
            context.setBeanResolver(this.beanResolver);
            Expression expression = this.parser.parseExpression(expressionToParse);
            securityContext = expression.getValue((EvaluationContext)context);
        }
        if (this.isInvalidType(parameter, securityContext)) {
            if (contextAnno.errorOnInvalidType()) {
                throw new ClassCastException(securityContext + " is not assignable to " + parameter.getParameterType());
            }
            return null;
        }
        return securityContext;
    }

    private boolean isInvalidType(MethodParameter parameter, Object value) {
        if (value == null) {
            return false;
        }
        Class typeToCheck = parameter.getParameterType();
        boolean isParameterPublisher = Publisher.class.isAssignableFrom(parameter.getParameterType());
        if (isParameterPublisher) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
            Class genericType = resolvableType.resolveGeneric(new int[]{0});
            if (genericType == null) {
                return false;
            }
            typeToCheck = genericType;
        }
        return !typeToCheck.isAssignableFrom(value.getClass());
    }

    private <T extends Annotation> T findMethodAnnotation(Class<T> annotationClass, MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        Annotation annotation = parameter.getParameterAnnotation(annotationClass);
        if (annotation != null) {
            return (T)annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = AnnotationUtils.findAnnotation(toSearch.annotationType(), annotationClass);
            if (annotation == null) continue;
            return (T)annotation;
        }
        return null;
    }
}

