/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.talend.bigdata.http.HttpHost;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.client.HttpClient;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.lang3.StringUtils;
import org.talend.bigdata.launcher.EndpointDescriptor;

public abstract class AbstractSparkJobRequest
implements EndpointDescriptor {
    protected HttpClient httpClient;
    protected Request request;
    protected String rootEndpoint;
    protected String apiPath;

    protected AbstractSparkJobRequest(Request request, String rootEndpoint, String apiPath) {
        this.request = request;
        this.rootEndpoint = StringUtils.removeEnd(rootEndpoint, "/");
        this.apiPath = apiPath;
    }

    public AbstractSparkJobRequest withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public HttpResponse execute() throws IOException {
        try {
            URI uri = new URI(this.rootEndpoint);
            HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            Executor executor = Executor.newInstance(this.httpClient).authPreemptive(httpHost);
            return executor.execute(this.request).returnResponse();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new IOException("Invalid URI: " + this.rootEndpoint, e);
        }
    }

    protected static String buildFullEndpoint(String rootEndpoint, String apiPath) {
        if (rootEndpoint == null || apiPath == null) {
            throw new IllegalArgumentException("rootEndpoint and apiPath must not be null");
        }
        String cleanRoot = StringUtils.removeEnd(rootEndpoint, "/");
        String cleanApi = apiPath.startsWith("/") ? apiPath : "/" + apiPath;
        return cleanRoot + cleanApi;
    }

    @Override
    public String getFullEndpoint() {
        return AbstractSparkJobRequest.buildFullEndpoint(this.rootEndpoint, this.apiPath);
    }
}

