/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.node.JsonNodeType;
import org.talend.bigdata.launcher.fs.FileSystem;

public class Utils {
    public static String appendFirstSlash(String string) {
        if (!string.startsWith("/")) {
            return "/" + string;
        }
        return string;
    }

    public static String removeStringAfter(String first, String second) {
        int indexFound = first.indexOf(second);
        if (indexFound != -1) {
            int indexRemoval = indexFound + second.length();
            return first.substring(0, indexRemoval);
        }
        return first;
    }

    public static String removeAPIend(String string) {
        for (SERVICE_PATHS path : SERVICE_PATHS.values()) {
            if (!string.endsWith(path.getServicePath())) continue;
            return string.substring(0, string.length() - path.getServicePath().length());
        }
        return string;
    }

    public static String removeFirstSlash(String string) {
        String str = string;
        if (str != null && str.length() > 1 && str.charAt(0) == '/') {
            str = str.substring(1);
        }
        return str;
    }

    public static String removeLastSlash(String string) {
        String str = string;
        int l = str.length();
        if (str != null && l > 1 && str.charAt(l - 1) == '/') {
            str = str.substring(0, l - 1);
        }
        return str;
    }

    public static String removeFirstAndLastSlash(String string) {
        String str = Utils.removeFirstSlash(string);
        str = Utils.removeLastSlash(str);
        return str;
    }

    public static Exception buildException(JsonNode object) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String message = object.get("message") != null ? object.get("message").asText() : null;
        String errorClass = object.get("errorClass") != null ? object.get("errorClass").asText() : null;
        JsonNode stackJSONArray = object.get("stack");
        if (stackJSONArray == null || errorClass == null || JsonNodeType.ARRAY != stackJSONArray.getNodeType()) {
            throw new InvalidParameterException("The JSON object must contain the \"stack\" and \"errorClass\" elements.");
        }
        ArrayList<StackTraceElement> stackList = new ArrayList<StackTraceElement>();
        Pattern stackPattern = Pattern.compile("([\\w\\.$_]+)\\.([\\w$_]+)\\((.*java|.*scala)?:(\\d+)\\)");
        Iterator<JsonNode> stackIterator = stackJSONArray.iterator();
        while (stackIterator.hasNext()) {
            Matcher stackMatcher = stackPattern.matcher(stackIterator.next().asText());
            if (!stackMatcher.find()) continue;
            stackList.add(new StackTraceElement(stackMatcher.group(1), stackMatcher.group(2), stackMatcher.group(3), Integer.parseInt(stackMatcher.group(4))));
        }
        Class<?> exceptionClass = Class.forName(errorClass);
        Constructor<?> exceptionConstructor = exceptionClass.getConstructor(String.class);
        Exception e = (Exception)exceptionConstructor.newInstance(message);
        StackTraceElement[] stackArray = new StackTraceElement[stackList.size()];
        e.setStackTrace(stackList.toArray(stackArray));
        return e;
    }

    public static StringBuilder buildLog(JsonNode array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            Iterator<JsonNode> iter = array.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().asText() + "\n");
            }
        }
        return sb;
    }

    public static String toConfString(Map<String, String> conf, Map<String, String> tuningConf) {
        StringBuilder sb = new StringBuilder("spark {context-settings {");
        if (conf != null) {
            for (Map.Entry<String, String> e : conf.entrySet()) {
                sb.append(e.getKey() + " = \"" + e.getValue() + "\",");
            }
        }
        sb.append("passthrough {");
        if (tuningConf != null) {
            for (Map.Entry<String, String> e : tuningConf.entrySet()) {
                sb.append(e.getKey() + " = \"" + e.getValue() + "\",");
            }
        }
        sb.append("} } }");
        return sb.toString();
    }

    public static String sendFiles(String remoteFolder, String statusFolder, FileSystem fs, String jarToExecute, String libJars) throws IOException, InvalidKeyException, URISyntaxException {
        String remote = remoteFolder;
        String remotejar = remote + "/jar";
        String remotelibjars = remote + "/libjars";
        String status = statusFolder;
        boolean overwrite = fs.getOverwrite();
        if (status != null && fs.exists(status)) {
            fs.delete(status);
        }
        if (!fs.exists(remote)) {
            fs.mkdir(remote);
        }
        if (!fs.exists(remotejar)) {
            fs.mkdir(remotejar);
        }
        if (!fs.exists(remotelibjars)) {
            fs.mkdir(remotelibjars);
        }
        fs.setOverwrite(true);
        fs.copyFromLocal(jarToExecute, remotejar);
        fs.setOverwrite(overwrite);
        StringBuilder libJarsSb = new StringBuilder();
        if (libJars == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(libJars, ",");
        boolean firstElement = true;
        while (tokenizer.hasMoreElements()) {
            String jar = (String)tokenizer.nextElement();
            if (jar.equals(jarToExecute)) continue;
            if (jar.contains("routines")) {
                fs.setOverwrite(true);
            }
            fs.copyFromLocal(jar, remotelibjars);
            fs.setOverwrite(overwrite);
            if (!firstElement) {
                libJarsSb.append(",");
            }
            firstElement = false;
            libJarsSb.append(fs.getFileSystemPrefix() + "/" + remoteFolder + "/libjars/" + new File(jar).getName());
        }
        return libJarsSb.toString();
    }

    public static String getJobJarUri(String remoteFolder, String jar, FileSystem fs) {
        return fs.getFileSystemPrefix() + "/" + remoteFolder + "/jar/" + new File(jar).getName();
    }

    public static enum SERVICE_PATHS {
        CM_API("cm-api"),
        LIVY("livy"),
        LIVY_SPARK3("livy_for_spark3"),
        OOZIE("oozie"),
        RESOURCE_MANAGER("resourcemanager"),
        WebHDFS("webhdfs/v1");

        private String servicePath;

        private SERVICE_PATHS(String servicePath) {
            this.servicePath = servicePath;
        }

        public String getServicePath() {
            return this.servicePath;
        }
    }
}

