/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.webhcat;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.NameValuePair;
import org.talend.bigdata.http.client.entity.UrlEncodedFormEntity;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.message.BasicNameValuePair;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.JobType;
import org.talend.bigdata.launcher.webhcat.WebHCatJob;

public class QueryJob
extends WebHCatJob {
    protected JobType mType;
    protected String mFileToExecute;

    public QueryJob(FileSystem fs, JobType type) {
        this.mFileSystem = fs;
        this.mType = type;
    }

    @Override
    public int callWS(String libjars) throws IOException, URISyntaxException {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        URI apiEndpoint = QueryJob.createURIBuilder(this.mWebhcatEndpoint, "/templeton/v1/" + this.mType.getType()).build();
        ArrayList<BasicNameValuePair> formParts = new ArrayList<BasicNameValuePair>(3);
        formParts.add(new BasicNameValuePair("user.name", this.mUsername));
        formParts.add(new BasicNameValuePair("file", this.mFileSystem.getFileSystemPrefix() + "/" + this.mRemoteFolder + "/file/" + this.mFileToExecute));
        formParts.add(new BasicNameValuePair("statusdir", "/" + this.mStatusFolder));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((List<? extends NameValuePair>)formParts);
        Request request = Request.Post(apiEndpoint).body(urlEncodedFormEntity);
        Executor executor = Executor.newInstance(this.httpClient).authPreemptive(apiEndpoint.getAuthority());
        HttpResponse response = executor.execute(request).returnResponse();
        return response.getStatusLine().getStatusCode();
    }

    @Override
    public String sendFiles() {
        String remote = this.mRemoteFolder;
        String remotefile = remote + "/file";
        String remotelibjars = remote + "/libjars";
        String status = this.mStatusFolder;
        if (this.mFileSystem.exists(remote)) {
            this.mFileSystem.delete(remote);
        }
        if (this.mFileSystem.exists(status)) {
            this.mFileSystem.delete(status);
        }
        this.mFileSystem.mkdir(remote);
        this.mFileSystem.mkdir(remotefile);
        this.mFileSystem.mkdir(remotelibjars);
        boolean previousValue = this.mFileSystem.getOverwrite();
        this.mFileSystem.setOverwrite(true);
        this.mFileSystem.copyFromLocal(this.mFileToExecute, remotefile);
        this.mFileSystem.setOverwrite(previousValue);
        if (this.mLibjars != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.mLibjars, ",");
            while (tokenizer.hasMoreElements()) {
                String jar = (String)tokenizer.nextElement();
                this.mFileSystem.copyFromLocal(jar, remotelibjars);
            }
        }
        return null;
    }

    public void setFileToExecute(String file) {
        this.mFileToExecute = file;
    }
}

