/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.processing.fields;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;

@Value.Enclosing
public interface TWriteAvroFields {

    public static class WriteAvroFieldsException
    extends RuntimeException {
        public WriteAvroFieldsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Value.Immutable
    public static abstract class Dataframe
    implements Serializable,
    Component.WithSchemaDescription {
        private transient DatumWriter<GenericRecord> datumWriter;
        private transient BinaryEncoder binaryEncoder;
        private transient ByteArrayOutputStream outputStream;
        private transient StructType inputStructType;
        private transient StructType outputStructType;
        private transient Schema avroSchema;

        abstract Dataset<Row> inputDataset();

        @Value.Default
        public Dataset<Row> getBinaryRecordFromAvro() {
            Dataset binaryDataset = this.inputDataset().map(this::convert, Encoders.BINARY());
            Dataset select = binaryDataset.select(new Column[]{binaryDataset.col("value").as("serializedValue")});
            StructField byteBufferField = new StructField("serializedValue", DataTypes.BinaryType, true, Metadata.empty());
            if (this.outputStructType == null) {
                this.outputStructType = new StructType(new StructField[]{byteBufferField});
            }
            return select;
        }

        private StructType getInputStructType(StructType schema) {
            StructType structType = schema;
            if (Arrays.asList(structType.fieldNames()).contains("processing_time")) {
                structType = new StructType((StructField[])Arrays.stream(structType.fields()).filter(field -> !"processing_time".equals(field.name())).toArray(StructField[]::new));
            }
            return structType;
        }

        private byte[] convert(Row value) {
            if (this.inputStructType == null) {
                this.inputStructType = this.getInputStructType(value.schema());
            }
            List<String> strings = List.of("org.apache.spark.sql.types.DataTypes.ByteType", "org.apache.spark.sql.types.DataTypes.DateType", "org.apache.spark.sql.types.DataTypes.TimestampType", "org.apache.spark.sql.types.DataTypes.ShortType");
            if (this.avroSchema == null) {
                this.avroSchema = SchemaConverters.toAvroType((DataType)this.inputStructType, (boolean)false, (String)this.inputStructType.typeName(), (String)"");
                this.avroSchema = this.getValidatedAvroSchema(this.avroSchema, this.schemaFieldDescriptions().stream().filter(fieldDescription -> strings.contains(fieldDescription.type())).map(Component.SchemaFieldDescription::name).toList(), this.inputStructType);
            }
            if (this.datumWriter == null) {
                this.datumWriter = new GenericDatumWriter(this.avroSchema);
            }
            if (this.outputStream == null) {
                this.outputStream = new ByteArrayOutputStream();
            } else {
                this.outputStream.reset();
            }
            this.binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)this.outputStream, this.binaryEncoder);
            try {
                this.datumWriter.write((Object)this.getGenericRecord(value), (Encoder)this.binaryEncoder);
                this.binaryEncoder.flush();
                return this.outputStream.toByteArray();
            }
            catch (IOException e) {
                throw new WriteAvroFieldsException("Failed to convert row to Avro", e);
            }
        }

        private GenericRecord getGenericRecord(Row value) {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            Arrays.stream(this.getInputStructType(value.schema()).fields()).forEach(arg_0 -> this.lambda$getGenericRecord$5(value, (GenericRecord)genericRecord, arg_0));
            return genericRecord;
        }

        private Schema getValidatedAvroSchema(Schema inputSchema, List<String> fieldsToConvertList, StructType inputStructType) {
            Schema newRecord = Schema.createRecord((String)inputSchema.getName(), (String)inputSchema.getDoc(), (String)inputSchema.getNamespace(), (boolean)inputSchema.isError());
            if (this.avroSchema.getType().equals((Object)Schema.Type.RECORD)) {
                List<Schema.Field> newFields = this.avroSchema.getFields().stream().map(field -> {
                    Schema newFieldSchema = field.schema();
                    if (fieldsToConvertList.contains(field.name())) {
                        newFieldSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                        StructField structField1 = Arrays.stream(inputStructType.fields()).filter(structField -> structField.name().equals(field.name())).findAny().orElseThrow(() -> new RuntimeException("TWriteAvroFields : No StructField found for " + field.name()));
                        field.addProp("java-class", Component.SchemaFieldDescription.structFieldToJavaType((StructField)structField1).getName());
                    }
                    return new Schema.Field(field.name(), newFieldSchema, field.doc(), field.defaultVal(), field.order());
                }).toList();
                newRecord.setFields(newFields);
                return newRecord;
            }
            return this.avroSchema;
        }

        private /* synthetic */ void lambda$getGenericRecord$5(Row value, GenericRecord genericRecord, StructField field) {
            String name = field.name();
            Object fieldValue = value.getAs(name);
            Object parsedValue = this.schemaFieldDescriptions().stream().filter(fieldDescription -> !fieldDescription.name().contains(" ") ? fieldDescription.name().equals(name) : fieldDescription.name().replace(" ", "_").equals(name)).findFirst().map(fieldDescription -> fieldDescription.parseObject(fieldValue, field)).orElse(fieldValue);
            genericRecord.put(field.name(), parsedValue);
        }
    }
}

