/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.technical.tcollectandcheck;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;

@Value.Immutable
public class TCollectAndCheckMapper
implements MapFunction<Row, String> {
    @Value.Default
    String separator() {
        return ";";
    }

    public String call(Row recordRow) {
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(recordRow.schema().fields()).forEach(field -> stringBuilder.append(this.getFormatedField(recordRow, (StructField)field)));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private String getFormatedField(Row recordRow, StructField field) {
        if (recordRow.getAs(field.name()) instanceof Date || recordRow.getAs(field.name()) instanceof Timestamp) {
            if (recordRow.getAs(field.name()) != null) {
                return recordRow.getAs(field.name()).toString().replaceAll("\\.\\d+", "") + this.separator();
            }
            return "null" + this.separator();
        }
        Object object = recordRow.getAs(field.name());
        if (object instanceof byte[]) {
            byte[] byteArray = (byte[])object;
            return Component.Conversions.asString((byte[])byteArray) + this.separator();
        }
        return recordRow.getAs(field.name()) + this.separator();
    }
}

