/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.common.output.StreamWriter;
import org.talend.bigdata.structuredstreaming.hive.THiveOutput;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="THiveOutput", generator="Immutables")
@Immutable
public final class ImmutableTHiveOutput
extends THiveOutput {
    private final Dataset<Row> input;
    private final Encoder<Row> encoder;
    private final Class<?> rowClass;
    private final ImmutableMap<String, String> options;
    private final Optional<String> queryName;
    private final OutputMode outputMode;
    @Nullable
    private final Trigger trigger;
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    @Nullable
    private final String table;
    private final String format;
    private final boolean external;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTHiveOutput(Dataset<Row> input) {
        this.input = Objects.requireNonNull(input, "input");
        this.trigger = null;
        this.schemaFieldDescriptions = ImmutableList.of();
        this.table = null;
        this.encoder = this.initShim.encoder();
        this.rowClass = this.initShim.rowClass();
        this.options = this.initShim.options();
        this.queryName = this.initShim.queryName();
        this.outputMode = this.initShim.outputMode();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.format = this.initShim.format();
        this.external = this.initShim.external();
        this.initShim = null;
    }

    private ImmutableTHiveOutput(Builder builder) {
        this.input = builder.input;
        this.trigger = builder.trigger;
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        this.table = builder.table;
        if (builder.encoder != null) {
            this.initShim.encoder(builder.encoder);
        }
        if (builder.rowClass != null) {
            this.initShim.rowClass(builder.rowClass);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options((ImmutableMap<String, String>)builder.options.build());
        }
        if (builder.queryName != null) {
            this.initShim.queryName(builder.queryName);
        }
        if (builder.outputMode != null) {
            this.initShim.outputMode(builder.outputMode);
        }
        if (builder.format != null) {
            this.initShim.format(builder.format);
        }
        if (builder.externalIsSet()) {
            this.initShim.external(builder.external);
        }
        this.encoder = this.initShim.encoder();
        this.rowClass = this.initShim.rowClass();
        this.options = this.initShim.options();
        this.queryName = this.initShim.queryName();
        this.outputMode = this.initShim.outputMode();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.format = this.initShim.format();
        this.external = this.initShim.external();
        this.initShim = null;
    }

    private ImmutableTHiveOutput(Dataset<Row> input, Encoder<Row> encoder, Class<?> rowClass, ImmutableMap<String, String> options, Optional<String> queryName, OutputMode outputMode, @Nullable Trigger trigger, ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, @Nullable String table, String format, boolean external) {
        this.input = input;
        this.initShim.encoder(encoder);
        this.initShim.rowClass(rowClass);
        this.initShim.options(options);
        this.initShim.queryName(queryName);
        this.initShim.outputMode(outputMode);
        this.trigger = trigger;
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.table = table;
        this.initShim.format(format);
        this.initShim.external(external);
        this.encoder = this.initShim.encoder();
        this.rowClass = this.initShim.rowClass();
        this.options = this.initShim.options();
        this.queryName = this.initShim.queryName();
        this.outputMode = this.initShim.outputMode();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.format = this.initShim.format();
        this.external = this.initShim.external();
        this.initShim = null;
    }

    @Override
    public Dataset<Row> input() {
        return this.input;
    }

    @Override
    public Encoder<Row> encoder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encoder() : this.encoder;
    }

    @Override
    public Class<?> rowClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowClass() : this.rowClass;
    }

    public ImmutableMap<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    @Override
    public Optional<String> queryName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.queryName() : this.queryName;
    }

    @Override
    public OutputMode outputMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputMode() : this.outputMode;
    }

    @Override
    public Optional<Trigger> trigger() {
        return Optional.ofNullable(this.trigger);
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    Optional<String> table() {
        return Optional.ofNullable(this.table);
    }

    @Override
    String format() {
        InitShim shim = this.initShim;
        return shim != null ? shim.format() : this.format;
    }

    @Override
    boolean external() {
        InitShim shim = this.initShim;
        return shim != null ? shim.external() : this.external;
    }

    public final ImmutableTHiveOutput withInput(Dataset<Row> value) {
        if (this.input == value) {
            return this;
        }
        Dataset<Row> newValue = Objects.requireNonNull(value, "input");
        return new ImmutableTHiveOutput(newValue, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withEncoder(Encoder<Row> value) {
        if (this.encoder == value) {
            return this;
        }
        Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
        return new ImmutableTHiveOutput(this.input, newValue, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withRowClass(Class<?> value) {
        if (this.rowClass == value) {
            return this;
        }
        Class<?> newValue = Objects.requireNonNull(value, "rowClass");
        return new ImmutableTHiveOutput(this.input, this.encoder, newValue, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, (ImmutableMap<String, String>)newValue, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withQueryName(Optional<String> value) {
        Optional<String> newValue = Objects.requireNonNull(value, "queryName");
        if (this.queryName.equals(newValue)) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, newValue, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withOutputMode(OutputMode value) {
        if (this.outputMode == value) {
            return this;
        }
        OutputMode newValue = Objects.requireNonNull(value, "outputMode");
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, newValue, this.trigger, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withTrigger(Trigger value) {
        Trigger newValue = Objects.requireNonNull(value, "trigger");
        if (this.trigger == newValue) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, newValue, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withTrigger(Optional<? extends Trigger> optional) {
        Trigger value = optional.orElse(null);
        if (this.trigger == value) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, value, this.schemaFieldDescriptions, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.table, this.format, this.external);
    }

    public final ImmutableTHiveOutput withTable(String value) {
        String newValue = Objects.requireNonNull(value, "table");
        if (Objects.equals(this.table, newValue)) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, newValue, this.format, this.external);
    }

    public final ImmutableTHiveOutput withTable(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.table, value)) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, value, this.format, this.external);
    }

    public final ImmutableTHiveOutput withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (this.format.equals(newValue)) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, newValue, this.external);
    }

    public final ImmutableTHiveOutput withExternal(boolean value) {
        if (this.external == value) {
            return this;
        }
        return new ImmutableTHiveOutput(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.schemaFieldDescriptions, this.table, this.format, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTHiveOutput && this.equalTo(0, (ImmutableTHiveOutput)another);
    }

    private boolean equalTo(int synthetic, ImmutableTHiveOutput another) {
        return this.input.equals(another.input) && this.encoder.equals(another.encoder) && this.rowClass.equals(another.rowClass) && this.options.equals(another.options) && this.queryName.equals(another.queryName) && this.outputMode.equals(another.outputMode) && Objects.equals(this.trigger, another.trigger) && this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && Objects.equals(this.table, another.table) && this.format.equals(another.format) && this.external == another.external;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.encoder.hashCode();
        h += (h << 5) + this.rowClass.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.queryName.hashCode();
        h += (h << 5) + this.outputMode.hashCode();
        h += (h << 5) + Objects.hashCode(this.trigger);
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + Objects.hashCode(this.table);
        h += (h << 5) + this.format.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.external);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"THiveOutput").omitNullValues().add("input", this.input).add("encoder", this.encoder).add("rowClass", this.rowClass).add("options", this.options).add("queryName", this.queryName).add("outputMode", (Object)this.outputMode).add("trigger", (Object)this.trigger).add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("table", (Object)this.table).add("format", (Object)this.format).add("external", this.external).toString();
    }

    public static ImmutableTHiveOutput of(Dataset<Row> input) {
        return new ImmutableTHiveOutput(input);
    }

    public static ImmutableTHiveOutput copyOf(THiveOutput instance) {
        if (instance instanceof ImmutableTHiveOutput) {
            return (ImmutableTHiveOutput)instance;
        }
        return ImmutableTHiveOutput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="THiveOutput", generator="Immutables")
    private final class InitShim {
        private byte encoderBuildStage = 0;
        private Encoder<Row> encoder;
        private byte rowClassBuildStage = 0;
        private Class<?> rowClass;
        private byte optionsBuildStage = 0;
        private ImmutableMap<String, String> options;
        private byte queryNameBuildStage = 0;
        private Optional<String> queryName;
        private byte outputModeBuildStage = 0;
        private OutputMode outputMode;
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte formatBuildStage = 0;
        private String format;
        private byte externalBuildStage = 0;
        private boolean external;

        private InitShim() {
        }

        Encoder<Row> encoder() {
            if (this.encoderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encoderBuildStage == 0) {
                this.encoderBuildStage = (byte)-1;
                this.encoder = Objects.requireNonNull(ImmutableTHiveOutput.super.encoder(), "encoder");
                this.encoderBuildStage = 1;
            }
            return this.encoder;
        }

        void encoder(Encoder<Row> encoder) {
            this.encoder = encoder;
            this.encoderBuildStage = 1;
        }

        Class<?> rowClass() {
            if (this.rowClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowClassBuildStage == 0) {
                this.rowClassBuildStage = (byte)-1;
                this.rowClass = Objects.requireNonNull(ImmutableTHiveOutput.super.rowClass(), "rowClass");
                this.rowClassBuildStage = 1;
            }
            return this.rowClass;
        }

        void rowClass(Class<?> rowClass) {
            this.rowClass = rowClass;
            this.rowClassBuildStage = 1;
        }

        ImmutableMap<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableMap.copyOf((Map)ImmutableTHiveOutput.super.options());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableMap<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        Optional<String> queryName() {
            if (this.queryNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queryNameBuildStage == 0) {
                this.queryNameBuildStage = (byte)-1;
                this.queryName = Objects.requireNonNull(ImmutableTHiveOutput.super.queryName(), "queryName");
                this.queryNameBuildStage = 1;
            }
            return this.queryName;
        }

        void queryName(Optional<String> queryName) {
            this.queryName = queryName;
            this.queryNameBuildStage = 1;
        }

        OutputMode outputMode() {
            if (this.outputModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputModeBuildStage == 0) {
                this.outputModeBuildStage = (byte)-1;
                this.outputMode = Objects.requireNonNull(ImmutableTHiveOutput.super.outputMode(), "outputMode");
                this.outputModeBuildStage = 1;
            }
            return this.outputMode;
        }

        void outputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            this.outputModeBuildStage = 1;
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableTHiveOutput.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableTHiveOutput.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        String format() {
            if (this.formatBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.formatBuildStage == 0) {
                this.formatBuildStage = (byte)-1;
                this.format = Objects.requireNonNull(ImmutableTHiveOutput.super.format(), "format");
                this.formatBuildStage = 1;
            }
            return this.format;
        }

        void format(String format) {
            this.format = format;
            this.formatBuildStage = 1;
        }

        boolean external() {
            if (this.externalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.externalBuildStage == 0) {
                this.externalBuildStage = (byte)-1;
                this.external = ImmutableTHiveOutput.super.external();
                this.externalBuildStage = 1;
            }
            return this.external;
        }

        void external(boolean external) {
            this.external = external;
            this.externalBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.encoderBuildStage == -1) {
                attributes.add("encoder");
            }
            if (this.rowClassBuildStage == -1) {
                attributes.add("rowClass");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.queryNameBuildStage == -1) {
                attributes.add("queryName");
            }
            if (this.outputModeBuildStage == -1) {
                attributes.add("outputMode");
            }
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.formatBuildStage == -1) {
                attributes.add("format");
            }
            if (this.externalBuildStage == -1) {
                attributes.add("external");
            }
            return "Cannot build THiveOutput, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="THiveOutput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long OPT_BIT_OPTIONS = 1L;
        private static final long OPT_BIT_EXTERNAL = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Dataset<Row> input;
        @Nullable
        private Encoder<Row> encoder;
        @Nullable
        private Class<?> rowClass;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        @Nullable
        private Optional<String> queryName;
        @Nullable
        private OutputMode outputMode;
        @Nullable
        private Trigger trigger;
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private String table;
        @Nullable
        private String format;
        private boolean external;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamWriter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(THiveOutput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Trigger> triggerOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
            }
            if (object instanceof StreamWriter) {
                instance = (StreamWriter)object;
                if ((bits & 1L) == 0L) {
                    this.input(instance.input());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.rowClass(instance.rowClass());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.queryName(instance.queryName());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.outputMode(instance.outputMode());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    triggerOptional = instance.trigger();
                    if (triggerOptional.isPresent()) {
                        this.trigger(triggerOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.encoder(instance.encoder());
                    bits |= 0x80L;
                }
            }
            if (object instanceof THiveOutput) {
                Optional<String> tableOptional;
                instance = (THiveOutput)object;
                if ((bits & 1L) == 0L) {
                    this.input(instance.input());
                    bits |= 1L;
                }
                this.external(((THiveOutput)instance).external());
                if ((bits & 2L) == 0L) {
                    this.rowClass(instance.rowClass());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 4L;
                }
                this.format(((THiveOutput)instance).format());
                if ((bits & 8L) == 0L) {
                    this.queryName(instance.queryName());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.outputMode(instance.outputMode());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    triggerOptional = instance.trigger();
                    if (triggerOptional.isPresent()) {
                        this.trigger(triggerOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.encoder(instance.encoder());
                    bits |= 0x80L;
                }
                if ((tableOptional = ((THiveOutput)instance).table()).isPresent()) {
                    this.table(tableOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder input(Dataset<Row> input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoder(Encoder<Row> encoder) {
            this.encoder = Objects.requireNonNull(encoder, "encoder");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowClass(Class<?> rowClass) {
            this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryName(Optional<String> queryName) {
            this.queryName = Objects.requireNonNull(queryName, "queryName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputMode(OutputMode outputMode) {
            this.outputMode = Objects.requireNonNull(outputMode, "outputMode");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trigger(Trigger trigger) {
            this.trigger = Objects.requireNonNull(trigger, "trigger");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trigger(Optional<? extends Trigger> trigger) {
            this.trigger = trigger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder table(String table) {
            this.table = Objects.requireNonNull(table, "table");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder table(Optional<String> table) {
            this.table = table.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder external(boolean external) {
            this.external = external;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableTHiveOutput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTHiveOutput(this);
        }

        private boolean optionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean externalIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            return "Cannot build THiveOutput, some of required attributes are not set " + attributes;
        }
    }
}

