/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow;

import java.io.PrintStream;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.immutables.value.Value;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;

@Value.Immutable
public abstract class TLogRowForEachBatchWriter
implements VoidFunction2<Dataset<Row>, Long> {
    private transient PrintStream console;

    abstract WithLoggerMode loggerMode();

    public void call(Dataset<Row> inputDataset, Long aLong) throws Exception {
        try {
            if (this.console == null) {
                this.console = System.out;
            }
            inputDataset.collectAsList().forEach(inputRecord -> this.console.println(this.loggerMode().log((Row)inputRecord)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.console != null) {
                this.console.flush();
            }
        }
    }
}

