/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.immutables.value.Value;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.util.TLogRowUtils;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.util.VerticalFormatLogger;

@Value.Immutable
public abstract class VerticalTableLoggerMode
implements WithLoggerMode {
    @Value.Default
    public String componentLabel() {
        return "tLogRow";
    }

    @Value.Default
    public VerticalTitlePrintOptions verticalTitlePrintOption() {
        return VerticalTitlePrintOptions.UNIQUE_NAME;
    }

    @Override
    public String log(Row recordValue) {
        List<StructField> fieldList = Arrays.asList(recordValue.schema().fields());
        String[] columnsNameArray = TLogRowUtils.getColumnsNameArray(fieldList);
        AtomicInteger numberOfLines = new AtomicInteger();
        VerticalFormatLogger verticalFormatLogger = new VerticalFormatLogger();
        String[] rowArray = new String[columnsNameArray.length];
        fieldList.forEach(field -> {
            if (recordValue.getAs(field.name()) != null) {
                rowArray[recordValue.fieldIndex((String)field.name())] = this.getFormattedValue(recordValue, (StructField)field);
            }
            numberOfLines.getAndIncrement();
        });
        String componentTitle = switch (this.verticalTitlePrintOption()) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalTitlePrintOptions.UNIQUE_NAME -> this.componentName();
            case VerticalTitlePrintOptions.LABEL -> this.componentLabel();
            case VerticalTitlePrintOptions.BOTH -> this.componentName() + "--" + this.componentLabel();
        };
        return new String(verticalFormatLogger.print(columnsNameArray, rowArray, numberOfLines.get(), componentTitle).getBytes(StandardCharsets.UTF_8), Charset.defaultCharset());
    }

    public static enum VerticalTitlePrintOptions {
        UNIQUE_NAME,
        LABEL,
        BOTH;

    }
}

