/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.Trigger;
import org.immutables.value.Generated;
import org.talend.bigdata.structuredstreaming.common.output.StreamWriter;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.TLogRow;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.TLogRowForEachBatchWriter;

@ParametersAreNonnullByDefault
@Generated(from="TLogRow", generator="Immutables")
public final class ImmutableTLogRow {
    private ImmutableTLogRow() {
    }

    @CheckReturnValue
    @Generated(from="TLogRow.Dataframe", generator="Immutables")
    @Immutable
    public static final class Dataframe
    extends TLogRow.Dataframe {
        private final Dataset<Row> input;
        private final Encoder<Row> encoder;
        private final Class<?> rowClass;
        private final ImmutableMap<String, String> options;
        private final Optional<String> queryName;
        private final OutputMode outputMode;
        @Nullable
        private final Trigger trigger;
        private final TLogRowForEachBatchWriter tLogRowForEachBatchWriter;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Dataframe(Dataset<Row> input, TLogRowForEachBatchWriter tLogRowForEachBatchWriter) {
            this.input = Objects.requireNonNull(input, "input");
            this.tLogRowForEachBatchWriter = Objects.requireNonNull(tLogRowForEachBatchWriter, "tLogRowForEachBatchWriter");
            this.trigger = null;
            this.encoder = this.initShim.encoder();
            this.rowClass = this.initShim.rowClass();
            this.options = this.initShim.options();
            this.queryName = this.initShim.queryName();
            this.outputMode = this.initShim.outputMode();
            this.initShim = null;
        }

        private Dataframe(Builder builder) {
            this.input = builder.input;
            this.trigger = builder.trigger;
            this.tLogRowForEachBatchWriter = builder.tLogRowForEachBatchWriter;
            if (builder.encoder != null) {
                this.initShim.encoder(builder.encoder);
            }
            if (builder.rowClass != null) {
                this.initShim.rowClass(builder.rowClass);
            }
            if (builder.optionsIsSet()) {
                this.initShim.options((ImmutableMap<String, String>)builder.options.build());
            }
            if (builder.queryName != null) {
                this.initShim.queryName(builder.queryName);
            }
            if (builder.outputMode != null) {
                this.initShim.outputMode(builder.outputMode);
            }
            this.encoder = this.initShim.encoder();
            this.rowClass = this.initShim.rowClass();
            this.options = this.initShim.options();
            this.queryName = this.initShim.queryName();
            this.outputMode = this.initShim.outputMode();
            this.initShim = null;
        }

        private Dataframe(Dataset<Row> input, Encoder<Row> encoder, Class<?> rowClass, ImmutableMap<String, String> options, Optional<String> queryName, OutputMode outputMode, @Nullable Trigger trigger, TLogRowForEachBatchWriter tLogRowForEachBatchWriter) {
            this.input = input;
            this.encoder = encoder;
            this.rowClass = rowClass;
            this.options = options;
            this.queryName = queryName;
            this.outputMode = outputMode;
            this.trigger = trigger;
            this.tLogRowForEachBatchWriter = tLogRowForEachBatchWriter;
            this.initShim = null;
        }

        @Override
        public Dataset<Row> input() {
            return this.input;
        }

        @Override
        public Encoder<Row> encoder() {
            InitShim shim = this.initShim;
            return shim != null ? shim.encoder() : this.encoder;
        }

        @Override
        public Class<?> rowClass() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rowClass() : this.rowClass;
        }

        public ImmutableMap<String, String> options() {
            InitShim shim = this.initShim;
            return shim != null ? shim.options() : this.options;
        }

        @Override
        public Optional<String> queryName() {
            InitShim shim = this.initShim;
            return shim != null ? shim.queryName() : this.queryName;
        }

        @Override
        public OutputMode outputMode() {
            InitShim shim = this.initShim;
            return shim != null ? shim.outputMode() : this.outputMode;
        }

        @Override
        public Optional<Trigger> trigger() {
            return Optional.ofNullable(this.trigger);
        }

        @Override
        TLogRowForEachBatchWriter tLogRowForEachBatchWriter() {
            return this.tLogRowForEachBatchWriter;
        }

        public final Dataframe withInput(Dataset<Row> value) {
            if (this.input == value) {
                return this;
            }
            Dataset<Row> newValue = Objects.requireNonNull(value, "input");
            return new Dataframe(newValue, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withEncoder(Encoder<Row> value) {
            if (this.encoder == value) {
                return this;
            }
            Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
            return new Dataframe(this.input, newValue, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withRowClass(Class<?> value) {
            if (this.rowClass == value) {
                return this;
            }
            Class<?> newValue = Objects.requireNonNull(value, "rowClass");
            return new Dataframe(this.input, this.encoder, newValue, this.options, this.queryName, this.outputMode, this.trigger, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withOptions(Map<String, ? extends String> entries) {
            if (this.options == entries) {
                return this;
            }
            ImmutableMap newValue = ImmutableMap.copyOf(entries);
            return new Dataframe(this.input, this.encoder, this.rowClass, (ImmutableMap<String, String>)newValue, this.queryName, this.outputMode, this.trigger, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withQueryName(Optional<String> value) {
            Optional<String> newValue = Objects.requireNonNull(value, "queryName");
            if (this.queryName.equals(newValue)) {
                return this;
            }
            return new Dataframe(this.input, this.encoder, this.rowClass, this.options, newValue, this.outputMode, this.trigger, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withOutputMode(OutputMode value) {
            if (this.outputMode == value) {
                return this;
            }
            OutputMode newValue = Objects.requireNonNull(value, "outputMode");
            return new Dataframe(this.input, this.encoder, this.rowClass, this.options, this.queryName, newValue, this.trigger, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withTrigger(Trigger value) {
            Trigger newValue = Objects.requireNonNull(value, "trigger");
            if (this.trigger == newValue) {
                return this;
            }
            return new Dataframe(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, newValue, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withTrigger(Optional<? extends Trigger> optional) {
            Trigger value = optional.orElse(null);
            if (this.trigger == value) {
                return this;
            }
            return new Dataframe(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, value, this.tLogRowForEachBatchWriter);
        }

        public final Dataframe withTLogRowForEachBatchWriter(TLogRowForEachBatchWriter value) {
            if (this.tLogRowForEachBatchWriter == value) {
                return this;
            }
            TLogRowForEachBatchWriter newValue = Objects.requireNonNull(value, "tLogRowForEachBatchWriter");
            return new Dataframe(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.outputMode, this.trigger, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Dataframe && this.equalTo(0, (Dataframe)another);
        }

        private boolean equalTo(int synthetic, Dataframe another) {
            return this.input.equals(another.input) && this.encoder.equals(another.encoder) && this.rowClass.equals(another.rowClass) && this.options.equals(another.options) && this.queryName.equals(another.queryName) && this.outputMode.equals(another.outputMode) && Objects.equals(this.trigger, another.trigger) && this.tLogRowForEachBatchWriter.equals(another.tLogRowForEachBatchWriter);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.input.hashCode();
            h += (h << 5) + this.encoder.hashCode();
            h += (h << 5) + this.rowClass.hashCode();
            h += (h << 5) + this.options.hashCode();
            h += (h << 5) + this.queryName.hashCode();
            h += (h << 5) + this.outputMode.hashCode();
            h += (h << 5) + Objects.hashCode(this.trigger);
            h += (h << 5) + this.tLogRowForEachBatchWriter.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Dataframe").omitNullValues().add("input", this.input).add("encoder", this.encoder).add("rowClass", this.rowClass).add("options", this.options).add("queryName", this.queryName).add("outputMode", (Object)this.outputMode).add("trigger", (Object)this.trigger).add("tLogRowForEachBatchWriter", (Object)this.tLogRowForEachBatchWriter).toString();
        }

        public static Dataframe of(Dataset<Row> input, TLogRowForEachBatchWriter tLogRowForEachBatchWriter) {
            return new Dataframe(input, tLogRowForEachBatchWriter);
        }

        public static Dataframe copyOf(TLogRow.Dataframe instance) {
            if (instance instanceof Dataframe) {
                return (Dataframe)instance;
            }
            return Dataframe.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TLogRow.Dataframe", generator="Immutables")
        private final class InitShim {
            private byte encoderBuildStage = 0;
            private Encoder<Row> encoder;
            private byte rowClassBuildStage = 0;
            private Class<?> rowClass;
            private byte optionsBuildStage = 0;
            private ImmutableMap<String, String> options;
            private byte queryNameBuildStage = 0;
            private Optional<String> queryName;
            private byte outputModeBuildStage = 0;
            private OutputMode outputMode;

            private InitShim() {
            }

            Encoder<Row> encoder() {
                if (this.encoderBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.encoderBuildStage == 0) {
                    this.encoderBuildStage = (byte)-1;
                    this.encoder = Objects.requireNonNull(Dataframe.super.encoder(), "encoder");
                    this.encoderBuildStage = 1;
                }
                return this.encoder;
            }

            void encoder(Encoder<Row> encoder) {
                this.encoder = encoder;
                this.encoderBuildStage = 1;
            }

            Class<?> rowClass() {
                if (this.rowClassBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rowClassBuildStage == 0) {
                    this.rowClassBuildStage = (byte)-1;
                    this.rowClass = Objects.requireNonNull(Dataframe.super.rowClass(), "rowClass");
                    this.rowClassBuildStage = 1;
                }
                return this.rowClass;
            }

            void rowClass(Class<?> rowClass) {
                this.rowClass = rowClass;
                this.rowClassBuildStage = 1;
            }

            ImmutableMap<String, String> options() {
                if (this.optionsBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.optionsBuildStage == 0) {
                    this.optionsBuildStage = (byte)-1;
                    this.options = ImmutableMap.copyOf((Map)Dataframe.super.options());
                    this.optionsBuildStage = 1;
                }
                return this.options;
            }

            void options(ImmutableMap<String, String> options) {
                this.options = options;
                this.optionsBuildStage = 1;
            }

            Optional<String> queryName() {
                if (this.queryNameBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.queryNameBuildStage == 0) {
                    this.queryNameBuildStage = (byte)-1;
                    this.queryName = Objects.requireNonNull(Dataframe.super.queryName(), "queryName");
                    this.queryNameBuildStage = 1;
                }
                return this.queryName;
            }

            void queryName(Optional<String> queryName) {
                this.queryName = queryName;
                this.queryNameBuildStage = 1;
            }

            OutputMode outputMode() {
                if (this.outputModeBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.outputModeBuildStage == 0) {
                    this.outputModeBuildStage = (byte)-1;
                    this.outputMode = Objects.requireNonNull(Dataframe.super.outputMode(), "outputMode");
                    this.outputModeBuildStage = 1;
                }
                return this.outputMode;
            }

            void outputMode(OutputMode outputMode) {
                this.outputMode = outputMode;
                this.outputModeBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.encoderBuildStage == -1) {
                    attributes.add("encoder");
                }
                if (this.rowClassBuildStage == -1) {
                    attributes.add("rowClass");
                }
                if (this.optionsBuildStage == -1) {
                    attributes.add("options");
                }
                if (this.queryNameBuildStage == -1) {
                    attributes.add("queryName");
                }
                if (this.outputModeBuildStage == -1) {
                    attributes.add("outputMode");
                }
                return "Cannot build Dataframe, attribute initializers form cycle " + attributes;
            }
        }

        @Generated(from="TLogRow.Dataframe", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INPUT = 1L;
            private static final long INIT_BIT_T_LOG_ROW_FOR_EACH_BATCH_WRITER = 2L;
            private static final long OPT_BIT_OPTIONS = 1L;
            private long initBits = 3L;
            private long optBits;
            @Nullable
            private Dataset<Row> input;
            @Nullable
            private Encoder<Row> encoder;
            @Nullable
            private Class<?> rowClass;
            private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
            @Nullable
            private Optional<String> queryName;
            @Nullable
            private OutputMode outputMode;
            @Nullable
            private Trigger trigger;
            @Nullable
            private TLogRowForEachBatchWriter tLogRowForEachBatchWriter;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(StreamWriter instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(TLogRow.Dataframe instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                StreamWriter instance;
                if (object instanceof StreamWriter) {
                    instance = (StreamWriter)object;
                    this.input(instance.input());
                    this.rowClass(instance.rowClass());
                    this.putAllOptions(instance.options());
                    this.queryName(instance.queryName());
                    this.outputMode(instance.outputMode());
                    Optional<Trigger> triggerOptional = instance.trigger();
                    if (triggerOptional.isPresent()) {
                        this.trigger(triggerOptional);
                    }
                    this.encoder(instance.encoder());
                }
                if (object instanceof TLogRow.Dataframe) {
                    instance = (TLogRow.Dataframe)object;
                    this.tLogRowForEachBatchWriter(((TLogRow.Dataframe)instance).tLogRowForEachBatchWriter());
                }
            }

            @CanIgnoreReturnValue
            public final Builder input(Dataset<Row> input) {
                this.input = Objects.requireNonNull(input, "input");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder encoder(Encoder<Row> encoder) {
                this.encoder = Objects.requireNonNull(encoder, "encoder");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rowClass(Class<?> rowClass) {
                this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder putOptions(String key, String value) {
                this.options.put((Object)key, (Object)value);
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
                this.options.put(entry);
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder options(Map<String, ? extends String> entries) {
                this.options = ImmutableMap.builder();
                this.optBits |= 1L;
                return this.putAllOptions(entries);
            }

            @CanIgnoreReturnValue
            public final Builder putAllOptions(Map<String, ? extends String> entries) {
                this.options.putAll(entries);
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder queryName(Optional<String> queryName) {
                this.queryName = Objects.requireNonNull(queryName, "queryName");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder outputMode(OutputMode outputMode) {
                this.outputMode = Objects.requireNonNull(outputMode, "outputMode");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder trigger(Trigger trigger) {
                this.trigger = Objects.requireNonNull(trigger, "trigger");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder trigger(Optional<? extends Trigger> trigger) {
                this.trigger = trigger.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder tLogRowForEachBatchWriter(TLogRowForEachBatchWriter tLogRowForEachBatchWriter) {
                this.tLogRowForEachBatchWriter = Objects.requireNonNull(tLogRowForEachBatchWriter, "tLogRowForEachBatchWriter");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public Dataframe build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Dataframe(this);
            }

            private boolean optionsIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("input");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("tLogRowForEachBatchWriter");
                }
                return "Cannot build Dataframe, some of required attributes are not set " + attributes;
            }
        }
    }
}

