/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.rate;

import java.util.concurrent.TimeoutException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.talend.bigdata.common.TestData;
import org.talend.bigdata.structuredstreaming.misc.rate.ImmutableTRateInput;

public class TRateInputTest {
    @Test
    void testLoad() throws TimeoutException, InterruptedException, StreamingQueryException {
        SparkSession ss = TestData.SPARK.sparkSession();
        ImmutableTRateInput input = ImmutableTRateInput.builder().sparkSession(ss).putOptions("rowsPerSecond", "1").putOptions("rampUpTime", "0").build();
        Dataset ds = input.load();
        StreamingQuery query = ds.writeStream().format("memory").queryName("ratequery").start();
        Thread.sleep(2000L);
        query.awaitTermination(2000L);
        Dataset result = ss.sql("SELECT * FROM ratequery");
        long count = result.count();
        Assertions.assertTrue((count > 0L ? 1 : 0) != 0, (String)"Expected data in the DataFrame, but found none.");
        query.stop();
    }
}

