/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.processing.fields;

import dataset.Row1Struct;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.talend.bigdata.common.TestData;
import org.talend.bigdata.structuredstreaming.processing.fields.ImmutableTWriteAvroFields;

class TWriteAvroFieldsTest {
    TWriteAvroFieldsTest() {
    }

    @Test
    void getBinaryRecordFromAvroWithMocksTest() {
        SparkSession spark = (SparkSession)Mockito.mock(SparkSession.class);
        DataStreamReader streamReader = (DataStreamReader)Mockito.mock(DataStreamReader.class);
        Dataset ds = (Dataset)Mockito.mock(Dataset.class);
        Column col = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)col.as(ArgumentMatchers.anyString())).thenReturn((Object)col);
        Mockito.when((Object)ds.map((MapFunction)ArgumentMatchers.any(MapFunction.class), (Encoder)ArgumentMatchers.any(Encoder.class))).thenReturn((Object)ds);
        Mockito.when((Object)ds.col(ArgumentMatchers.anyString())).thenReturn((Object)col);
        Mockito.when((Object)ds.select(new Column[]{(Column)ArgumentMatchers.any(Column.class)})).thenReturn((Object)ds);
        ImmutableTWriteAvroFields.Dataframe tWriteAvroFields = ImmutableTWriteAvroFields.Dataframe.builder().inputDataset(ds).avroRecord((SpecificRecordBase)new Row1Struct()).build();
        Assertions.assertNotNull((Object)tWriteAvroFields);
    }

    @Test
    void getBinaryRecordFromAvroTest() {
        SparkSession ss = TestData.SPARK.sparkSession();
        Dataset ds = ss.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{"value1", "value1"}), RowFactory.create((Object[])new Object[]{"value2", "value2"})), new StructType(new StructField[]{new StructField("id", DataTypes.StringType, true, Metadata.empty()), new StructField("name", DataTypes.StringType, false, Metadata.empty())}));
        ImmutableTWriteAvroFields.Dataframe tWriteAvroFields = ImmutableTWriteAvroFields.Dataframe.builder().inputDataset(ds).avroRecord((SpecificRecordBase)new Row1Struct()).build();
        Dataset r = tWriteAvroFields.getBinaryRecordFromAvro();
        Assertions.assertEquals((Object)"StructType(StructField(serializedValue,BinaryType,true))", (Object)r.schema().toString());
        List rows = r.collectAsList();
        Assertions.assertEquals((int)2, (int)rows.size());
    }
}

