/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.bigdata.structuredstreaming.utils.Operation;

public class ConsoleLinesCaptor {
    public static List<String> getCapturedLinesList(Operation operation) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream out = System.out;
        System.setOut(printStream);
        operation.execute();
        List collectedStringList = Stream.of(byteArrayOutputStream.toString().split(System.lineSeparator())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        byteArrayOutputStream.flush();
        printStream.flush();
        System.setOut(out);
        return collectedStringList;
    }

    public static List<String> getCapturedTableLinesList(Operation operation) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream out = System.out;
        System.setOut(printStream);
        operation.execute();
        List collectedStringList = Stream.of(byteArrayOutputStream.toString().split("(?m)^\\s*$[\r\n]+")).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        byteArrayOutputStream.flush();
        printStream.flush();
        System.setOut(out);
        return collectedStringList;
    }
}

