/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.hive;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.common.output.StreamWriter;

@Value.Immutable
public abstract class THiveOutput
implements StreamWriter,
Component.WithSchemaDescription {
    abstract Optional<String> table();

    @Value.Default
    String format() {
        return "parquet";
    }

    @Value.Default
    boolean external() {
        return false;
    }

    @Override
    public StreamingQuery start() throws TimeoutException {
        if (this.external()) {
            return this.writer().format(this.format()).start();
        }
        return this.writer().foreachBatch((VoidFunction2 & Serializable)(batchDF, batchId) -> batchDF.write().format(this.format()).mode(this.outputMode().toString()).insertInto(this.table().orElse("mytable"))).start();
    }
}

