/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.kafka;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.spark.sql.SparkSession;
import org.talend.bigdata.structuredstreaming.kafka.TKafkaConfiguration;

public class TKafkaSLLKerberosUtils {
    protected static void setSASLTrustStoreConfiguration(TKafkaConfiguration tKafkaConfiguration, SparkSession sparkSession) {
        File sslTrustStore = new File(tKafkaConfiguration.sslTruststoreLocation());
        if (!sslTrustStore.exists()) {
            throw new RuntimeException("Could not find client truststore at location [" + tKafkaConfiguration.sslTruststoreLocation() + "]");
        }
        sparkSession.sparkContext().addFile(tKafkaConfiguration.sslTruststoreLocation());
        try {
            Files.copy(Paths.get(tKafkaConfiguration.sslTruststoreLocation(), new String[0]), Paths.get(".", sslTrustStore.getName()), StandardCopyOption.REPLACE_EXISTING);
            Paths.get(".", sslTrustStore.getName()).toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setKerberosSecurityConfiguration(TKafkaConfiguration tKafkaConfiguration, SparkSession sparkSession) {
        System.setProperty("java.security.auth.login.config", tKafkaConfiguration.kerberosJaasConfigurationPath());
        if (tKafkaConfiguration.isSetKerberosConfigurationPath()) {
            System.setProperty("java.security.krb5.conf", tKafkaConfiguration.kerberosConfigurationPath());
        }
        Configuration.setConfiguration(null);
        AppConfigurationEntry[] appConfigurationEntries = Configuration.getConfiguration().getAppConfigurationEntry("KafkaClient");
        if (appConfigurationEntries.length == 0) {
            throw new RuntimeException("Cannot found any 'KafkaClient' login section within the JAAS configuration file [" + tKafkaConfiguration.kerberosJaasConfigurationPath() + "].");
        }
        if (appConfigurationEntries.length > 1) {
            throw new RuntimeException("Only 1 'KafkaClient' login section is expected from the JAAS configuration. Found " + appConfigurationEntries.length + ".");
        }
        String keyTabPath = (String)appConfigurationEntries[0].getOptions().get("keyTab");
        File keyTabFile = new File(keyTabPath);
        if (!keyTabFile.exists()) {
            throw new RuntimeException("Could not find client keytab at location [" + keyTabPath + "]. Please check the contents of the JAAS configuration file.");
        }
        sparkSession.sparkContext().addFile(keyTabPath);
        File jaasFile = new File(tKafkaConfiguration.kerberosJaasConfigurationPath());
        if (!jaasFile.exists()) {
            throw new RuntimeException("Could not find JAAS configuration file at location[" + tKafkaConfiguration.kerberosJaasConfigurationPath() + "].");
        }
        try {
            String jaasOriginalContents = Files.readString(Paths.get(tKafkaConfiguration.kerberosJaasConfigurationPath(), new String[0]));
            String jaasModifiedContents = jaasOriginalContents.replaceAll(keyTabPath, "./" + keyTabFile.getName());
            Path modifiedJaasPath = Paths.get(System.getProperty("java.io.tmpdir"), jaasFile.getName());
            Files.writeString(modifiedJaasPath, (CharSequence)jaasModifiedContents, new OpenOption[0]);
            sparkSession.sparkContext().addFile(modifiedJaasPath.toAbsolutePath().toString());
            modifiedJaasPath.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

