/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.util;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class VerticalFormatLogger {
    String[] columnNames;

    public void printLine(StringBuilder sb, int titleWidth, int dataWidth) {
        int i;
        sb.append("+");
        for (i = 0; i < titleWidth + 2; ++i) {
            sb.append("-");
        }
        sb.append("+");
        for (i = 0; i < dataWidth + 2; ++i) {
            sb.append("-");
        }
        sb.append("+\n");
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String print(String[] columnNameArray, String[] row, int nbLine, String componentTitle) {
        StringBuilder sb = new StringBuilder();
        String title = "#" + nbLine + ". " + componentTitle;
        int dataWidth = 5;
        for (int i = 0; i < row.length; ++i) {
            if (row[i] == null && 4 > dataWidth) {
                dataWidth = 4;
                continue;
            }
            if (row[i] == null || row[i].length() <= dataWidth) continue;
            dataWidth = row[i].length();
        }
        int titleWidth = 8;
        int totalWidth = dataWidth + titleWidth + 5;
        sb.append(".");
        sb.append("-".repeat(Math.max(0, totalWidth)));
        sb.append(".\n|");
        int emptyCenterWidth = (totalWidth - title.length()) / 2;
        sb.append(" ".repeat(Math.max(0, emptyCenterWidth)));
        sb.append(title);
        sb.append(" ".repeat(Math.max(0, totalWidth - emptyCenterWidth - title.length())));
        sb.append("|\n");
        this.printLine(sb, titleWidth, dataWidth);
        sb.append("| key");
        sb.append(" ".repeat(titleWidth - 2));
        sb.append("| value");
        sb.append(" ".repeat(Math.max(0, dataWidth - 4)));
        sb.append("|\n");
        this.printLine(sb, titleWidth, dataWidth);
        AtomicInteger rowIndex = new AtomicInteger();
        int finalDataWidth = dataWidth;
        Arrays.stream(columnNameArray).forEach(columnName -> {
            int index = rowIndex.get();
            sb.append("| ").append((String)columnName);
            sb.append(" ".repeat(Math.max(0, titleWidth - columnName.length() + 1)));
            sb.append("| ").append(row[index]);
            for (int i = 0; row[index] == null && i < finalDataWidth - 3 || row[index] != null && i < finalDataWidth - row[index].length() + 1; ++i) {
                sb.append(" ");
            }
            sb.append("|\n");
            rowIndex.getAndIncrement();
        });
        this.printLine(sb, titleWidth, dataWidth);
        return sb.toString();
    }
}

