/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.rate;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.common.input.StreamReader;
import org.talend.bigdata.structuredstreaming.misc.rate.TRateInput;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TRateInput", generator="Immutables")
@Immutable
public final class ImmutableTRateInput
extends TRateInput {
    private final SparkSession sparkSession;
    private final Class<Row> rowClass;
    private final Encoder<Row> encoder;
    private final JavaSparkContext context;
    private final ImmutableMap<String, String> options;
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    @Nullable
    private final StreamReader.WatermarkingType enableWatermarking;
    @Nullable
    private final String watermarkColumn;
    @Nullable
    private final String watermarkDelay;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTRateInput(SparkSession sparkSession) {
        this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
        this.schemaFieldDescriptions = ImmutableList.of();
        this.enableWatermarking = null;
        this.watermarkColumn = null;
        this.watermarkDelay = null;
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.initShim = null;
    }

    private ImmutableTRateInput(Builder builder) {
        this.sparkSession = builder.sparkSession;
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        this.enableWatermarking = builder.enableWatermarking;
        this.watermarkColumn = builder.watermarkColumn;
        this.watermarkDelay = builder.watermarkDelay;
        if (builder.rowClass != null) {
            this.initShim.rowClass(builder.rowClass);
        }
        if (builder.encoder != null) {
            this.initShim.encoder(builder.encoder);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options((ImmutableMap<String, String>)builder.options.build());
        }
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.initShim = null;
    }

    private ImmutableTRateInput(SparkSession sparkSession, Class<Row> rowClass, Encoder<Row> encoder, ImmutableMap<String, String> options, ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, @Nullable StreamReader.WatermarkingType enableWatermarking, @Nullable String watermarkColumn, @Nullable String watermarkDelay) {
        this.sparkSession = sparkSession;
        this.initShim.rowClass(rowClass);
        this.initShim.encoder(encoder);
        this.initShim.options(options);
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.enableWatermarking = enableWatermarking;
        this.watermarkColumn = watermarkColumn;
        this.watermarkDelay = watermarkDelay;
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.initShim = null;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public Class<Row> rowClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowClass() : this.rowClass;
    }

    public Encoder<Row> encoder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encoder() : this.encoder;
    }

    public JavaSparkContext context() {
        InitShim shim = this.initShim;
        return shim != null ? shim.context() : this.context;
    }

    public ImmutableMap<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    public Optional<StreamReader.WatermarkingType> enableWatermarking() {
        return Optional.ofNullable(this.enableWatermarking);
    }

    @Override
    public Optional<String> watermarkColumn() {
        return Optional.ofNullable(this.watermarkColumn);
    }

    @Override
    public Optional<String> watermarkDelay() {
        return Optional.ofNullable(this.watermarkDelay);
    }

    public final ImmutableTRateInput withSparkSession(SparkSession value) {
        if (this.sparkSession == value) {
            return this;
        }
        SparkSession newValue = Objects.requireNonNull(value, "sparkSession");
        return new ImmutableTRateInput(newValue, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withRowClass(Class<Row> value) {
        if (this.rowClass == value) {
            return this;
        }
        Class<Row> newValue = Objects.requireNonNull(value, "rowClass");
        return new ImmutableTRateInput(this.sparkSession, newValue, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withEncoder(Encoder<Row> value) {
        if (this.encoder == value) {
            return this;
        }
        Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, newValue, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, (ImmutableMap<String, String>)newValue, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withEnableWatermarking(StreamReader.WatermarkingType value) {
        StreamReader.WatermarkingType newValue = Objects.requireNonNull(value, "enableWatermarking");
        if (this.enableWatermarking == newValue) {
            return this;
        }
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, newValue, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withEnableWatermarking(Optional<? extends StreamReader.WatermarkingType> optional) {
        StreamReader.WatermarkingType value = optional.orElse(null);
        if (this.enableWatermarking == value) {
            return this;
        }
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, value, this.watermarkColumn, this.watermarkDelay);
    }

    public final ImmutableTRateInput withWatermarkColumn(String value) {
        String newValue = Objects.requireNonNull(value, "watermarkColumn");
        if (Objects.equals(this.watermarkColumn, newValue)) {
            return this;
        }
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, newValue, this.watermarkDelay);
    }

    public final ImmutableTRateInput withWatermarkColumn(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.watermarkColumn, value)) {
            return this;
        }
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, value, this.watermarkDelay);
    }

    public final ImmutableTRateInput withWatermarkDelay(String value) {
        String newValue = Objects.requireNonNull(value, "watermarkDelay");
        if (Objects.equals(this.watermarkDelay, newValue)) {
            return this;
        }
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, newValue);
    }

    public final ImmutableTRateInput withWatermarkDelay(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.watermarkDelay, value)) {
            return this;
        }
        return new ImmutableTRateInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTRateInput && this.equalTo(0, (ImmutableTRateInput)another);
    }

    private boolean equalTo(int synthetic, ImmutableTRateInput another) {
        return this.sparkSession.equals(another.sparkSession) && this.rowClass.equals(another.rowClass) && this.encoder.equals(another.encoder) && this.context.equals(another.context) && this.options.equals(another.options) && this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && Objects.equals((Object)this.enableWatermarking, (Object)another.enableWatermarking) && Objects.equals(this.watermarkColumn, another.watermarkColumn) && Objects.equals(this.watermarkDelay, another.watermarkDelay);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sparkSession.hashCode();
        h += (h << 5) + this.rowClass.hashCode();
        h += (h << 5) + this.encoder.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.enableWatermarking);
        h += (h << 5) + Objects.hashCode(this.watermarkColumn);
        h += (h << 5) + Objects.hashCode(this.watermarkDelay);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TRateInput").omitNullValues().add("sparkSession", (Object)this.sparkSession).add("rowClass", this.rowClass).add("encoder", this.encoder).add("context", (Object)this.context).add("options", this.options).add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("enableWatermarking", (Object)this.enableWatermarking).add("watermarkColumn", (Object)this.watermarkColumn).add("watermarkDelay", (Object)this.watermarkDelay).toString();
    }

    public static ImmutableTRateInput of(SparkSession sparkSession) {
        return new ImmutableTRateInput(sparkSession);
    }

    public static ImmutableTRateInput copyOf(TRateInput instance) {
        if (instance instanceof ImmutableTRateInput) {
            return (ImmutableTRateInput)instance;
        }
        return ImmutableTRateInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TRateInput", generator="Immutables")
    private final class InitShim {
        private byte rowClassBuildStage = 0;
        private Class<Row> rowClass;
        private byte encoderBuildStage = 0;
        private Encoder<Row> encoder;
        private byte contextBuildStage = 0;
        private JavaSparkContext context;
        private byte optionsBuildStage = 0;
        private ImmutableMap<String, String> options;
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;

        private InitShim() {
        }

        Class<Row> rowClass() {
            if (this.rowClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowClassBuildStage == 0) {
                this.rowClassBuildStage = (byte)-1;
                this.rowClass = Objects.requireNonNull(ImmutableTRateInput.super.rowClass(), "rowClass");
                this.rowClassBuildStage = 1;
            }
            return this.rowClass;
        }

        void rowClass(Class<Row> rowClass) {
            this.rowClass = rowClass;
            this.rowClassBuildStage = 1;
        }

        Encoder<Row> encoder() {
            if (this.encoderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encoderBuildStage == 0) {
                this.encoderBuildStage = (byte)-1;
                this.encoder = Objects.requireNonNull(ImmutableTRateInput.super.encoder(), "encoder");
                this.encoderBuildStage = 1;
            }
            return this.encoder;
        }

        void encoder(Encoder<Row> encoder) {
            this.encoder = encoder;
            this.encoderBuildStage = 1;
        }

        JavaSparkContext context() {
            if (this.contextBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contextBuildStage == 0) {
                this.contextBuildStage = (byte)-1;
                this.context = Objects.requireNonNull(ImmutableTRateInput.super.context(), "context");
                this.contextBuildStage = 1;
            }
            return this.context;
        }

        ImmutableMap<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableMap.copyOf((Map)ImmutableTRateInput.super.options());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableMap<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableTRateInput.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableTRateInput.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.rowClassBuildStage == -1) {
                attributes.add("rowClass");
            }
            if (this.encoderBuildStage == -1) {
                attributes.add("encoder");
            }
            if (this.contextBuildStage == -1) {
                attributes.add("context");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            return "Cannot build TRateInput, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TRateInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SPARK_SESSION = 1L;
        private static final long OPT_BIT_OPTIONS = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private SparkSession sparkSession;
        @Nullable
        private Class<Row> rowClass;
        @Nullable
        private Encoder<Row> encoder;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private StreamReader.WatermarkingType enableWatermarking;
        @Nullable
        private String watermarkColumn;
        @Nullable
        private String watermarkDelay;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TRateInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamReader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<StreamReader.WatermarkingType> enableWatermarkingOptional;
            Optional<String> watermarkColumnOptional;
            Optional<String> watermarkDelayOptional;
            StreamReader instance;
            long bits = 0L;
            if (object instanceof TRateInput) {
                instance = (TRateInput)object;
                this.rowClass(instance.rowClass());
                if ((bits & 1L) == 0L) {
                    watermarkDelayOptional = instance.watermarkDelay();
                    if (watermarkDelayOptional.isPresent()) {
                        this.watermarkDelay(watermarkDelayOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    watermarkColumnOptional = instance.watermarkColumn();
                    if (watermarkColumnOptional.isPresent()) {
                        this.watermarkColumn(watermarkColumnOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    enableWatermarkingOptional = instance.enableWatermarking();
                    if (enableWatermarkingOptional.isPresent()) {
                        this.enableWatermarking(enableWatermarkingOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x20L;
                }
                this.encoder((Encoder<Row>)instance.encoder());
            }
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 0x20L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x20L;
                }
            }
            if (object instanceof StreamReader) {
                instance = (StreamReader)object;
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    enableWatermarkingOptional = instance.enableWatermarking();
                    if (enableWatermarkingOptional.isPresent()) {
                        this.enableWatermarking(enableWatermarkingOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    watermarkDelayOptional = instance.watermarkDelay();
                    if (watermarkDelayOptional.isPresent()) {
                        this.watermarkDelay(watermarkDelayOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    watermarkColumnOptional = instance.watermarkColumn();
                    if (watermarkColumnOptional.isPresent()) {
                        this.watermarkColumn(watermarkColumnOptional);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder sparkSession(SparkSession sparkSession) {
            this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowClass(Class<Row> rowClass) {
            this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoder(Encoder<Row> encoder) {
            this.encoder = Objects.requireNonNull(encoder, "encoder");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableWatermarking(StreamReader.WatermarkingType enableWatermarking) {
            this.enableWatermarking = Objects.requireNonNull(enableWatermarking, "enableWatermarking");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableWatermarking(Optional<? extends StreamReader.WatermarkingType> enableWatermarking) {
            this.enableWatermarking = enableWatermarking.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkColumn(String watermarkColumn) {
            this.watermarkColumn = Objects.requireNonNull(watermarkColumn, "watermarkColumn");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkColumn(Optional<String> watermarkColumn) {
            this.watermarkColumn = watermarkColumn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkDelay(String watermarkDelay) {
            this.watermarkDelay = Objects.requireNonNull(watermarkDelay, "watermarkDelay");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkDelay(Optional<String> watermarkDelay) {
            this.watermarkDelay = watermarkDelay.orElse(null);
            return this;
        }

        public ImmutableTRateInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTRateInput(this);
        }

        private boolean optionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sparkSession");
            }
            return "Cannot build TRateInput, some of required attributes are not set " + attributes;
        }
    }
}

