/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.tmap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Dataset;

public class TMapOutput<O>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<String> relatedInputs;
    private Dataset<O> outputDs;
    private FilterFunction<O> filter;

    public TMapOutput(String name, String relatedInput) {
        this.name = name;
        this.relatedInputs = Arrays.asList(relatedInput);
    }

    public TMapOutput(String name, String relatedInput, FilterFunction<O> filter) {
        this.name = name;
        this.relatedInputs = Arrays.asList(relatedInput);
        this.filter = filter;
    }

    public TMapOutput(String name, List<String> relatedInputs) {
        this.name = name;
        this.relatedInputs = relatedInputs;
    }

    public TMapOutput(String name, List<String> relatedInputs, FilterFunction<O> filter) {
        this.name = name;
        this.relatedInputs = relatedInputs;
        this.filter = filter;
    }

    public void setOutputDS(Dataset<O> ds) {
        this.outputDs = ds;
    }

    public Dataset<O> getOutputDS() {
        if (this.filter != null) {
            return this.outputDs.filter(this.filter);
        }
        return this.outputDs;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRelatedInputs() {
        return this.relatedInputs;
    }

    public String getRelatedInput() {
        return this.relatedInputs.get(0);
    }

    public String getRelatedInput(String name) {
        return this.relatedInputs.stream().filter(name::equals).findAny().orElse(null);
    }
}

