/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq.converter;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.activemq.converter.ActiveMQConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class ActiveMQConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile ActiveMQConverter activeMQConverter;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ActiveMQConverterLoader.addTypeConverter(registry, ActiveMQDestination.class, String.class, false, (type, exchange, value) -> this.getActiveMQConverter().toDestination((String)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

    private ActiveMQConverter getActiveMQConverter() {
        if (this.activeMQConverter == null) {
            this.activeMQConverter = new ActiveMQConverter();
            CamelContextAware.trySetCamelContext(this.activeMQConverter, this.camelContext);
        }
        return this.activeMQConverter;
    }
}

