/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.Message;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.support.PollingConsumerSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;

public class JmsPollingConsumer
extends PollingConsumerSupport {
    private final JmsOperations template;
    private final JmsEndpoint jmsEndpoint;

    public JmsPollingConsumer(JmsEndpoint endpoint, JmsOperations template) {
        super(endpoint);
        this.jmsEndpoint = endpoint;
        this.template = template;
    }

    @Override
    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(-1L);
    }

    @Override
    public Exchange receive() {
        return this.receive(0L);
    }

    @Override
    public Exchange receive(long timeout) {
        this.setReceiveTimeout(timeout);
        Message message = ObjectHelper.isNotEmpty(this.jmsEndpoint.getSelector()) ? this.template.receiveSelected(this.jmsEndpoint.getSelector()) : this.template.receive();
        if (message != null) {
            return this.getEndpoint().createExchange(message, null);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    protected void setReceiveTimeout(long timeout) {
        JmsOperations jmsOperations = this.template;
        if (!(jmsOperations instanceof JmsTemplate)) {
            throw new IllegalArgumentException("Cannot set the receiveTimeout property on unknown JmsOperations type: " + this.template.getClass().getName());
        }
        JmsTemplate jmsTemplate = (JmsTemplate)jmsOperations;
        jmsTemplate.setReceiveTimeout(timeout);
    }
}

