/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.UniVocityFixedDataFormat;
import org.apache.camel.model.dataformat.UniVocityHeader;
import org.apache.camel.reifier.dataformat.UniVocityAbstractDataFormatReifier;

public class UniVocityFixedWidthDataFormatReifier
extends UniVocityAbstractDataFormatReifier<UniVocityFixedDataFormat> {
    public UniVocityFixedWidthDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        super.prepareDataFormatConfig(properties);
        properties.put("fieldLengths", this.getFieldLengths());
        properties.put("skipTrailingCharsUntilNewline", ((UniVocityFixedDataFormat)this.definition).getSkipTrailingCharsUntilNewline());
        properties.put("recordEndsOnNewline", ((UniVocityFixedDataFormat)this.definition).getRecordEndsOnNewline());
        properties.put("padding", ((UniVocityFixedDataFormat)this.definition).getPadding());
    }

    private int[] getFieldLengths() {
        if (((UniVocityFixedDataFormat)this.definition).getHeaders() != null) {
            int i2 = 0;
            int[] arr = new int[((UniVocityFixedDataFormat)this.definition).getHeaders().size()];
            for (UniVocityHeader header : ((UniVocityFixedDataFormat)this.definition).getHeaders()) {
                String len = header.getLength();
                int num = Integer.parseInt(len);
                arr[i2++] = num;
            }
            return arr;
        }
        return null;
    }
}

