/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ThreadPoolProfile;
import org.slf4j.LoggerFactory;

public class DefaultErrorHandlerReifier
extends ErrorHandlerReifier<DefaultErrorHandlerDefinition> {
    public DefaultErrorHandlerReifier(Route route, DefaultErrorHandlerDefinition definition) {
        super(route, definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        RedeliveryPolicy redeliveryPolicy = this.resolveRedeliveryPolicy((DefaultErrorHandlerDefinition)this.definition, this.camelContext);
        CamelLogger logger = this.resolveLogger((DefaultErrorHandlerDefinition)this.definition);
        DefaultErrorHandler answer = new DefaultErrorHandler(this.camelContext, processor, logger, this.getProcessor(((DefaultErrorHandlerDefinition)this.definition).getOnRedeliveryProcessor(), ((DefaultErrorHandlerDefinition)this.definition).getOnRedeliveryRef()), redeliveryPolicy, this.getPredicate(((DefaultErrorHandlerDefinition)this.definition).getRetryWhilePredicate(), ((DefaultErrorHandlerDefinition)this.definition).getRetryWhileRef()), this.getExecutorService(((DefaultErrorHandlerDefinition)this.definition).getExecutorServiceBean(), ((DefaultErrorHandlerDefinition)this.definition).getExecutorServiceRef()), this.getProcessor(((DefaultErrorHandlerDefinition)this.definition).getOnPrepareFailureProcessor(), ((DefaultErrorHandlerDefinition)this.definition).getOnPrepareFailureRef()), this.getProcessor(((DefaultErrorHandlerDefinition)this.definition).getOnExceptionOccurredProcessor(), ((DefaultErrorHandlerDefinition)this.definition).getOnExceptionOccurredRef()));
        this.configure(answer);
        return answer;
    }

    @Deprecated
    private Predicate resolveRetryWhilePolicy(DeadLetterChannelDefinition definition, CamelContext camelContext) {
        Predicate answer = definition.getRetryWhilePredicate();
        if (answer == null && definition.getRetryWhileRef() != null) {
            Language bean2 = camelContext.resolveLanguage("bean");
            answer = bean2.createPredicate(definition.getRetryWhileRef());
            answer.initPredicate(camelContext);
        }
        return answer;
    }

    private CamelLogger resolveLogger(DefaultErrorHandlerDefinition definition) {
        CamelLogger answer = definition.getLoggerBean();
        if (answer == null && definition.getLoggerRef() != null) {
            answer = this.mandatoryLookup(definition.getLoggerRef(), CamelLogger.class);
        }
        if (answer == null) {
            answer = new CamelLogger(LoggerFactory.getLogger(DefaultErrorHandler.class), LoggingLevel.ERROR);
        }
        if (definition.getLevel() != null) {
            answer.setLevel(this.parse(LoggingLevel.class, definition.getLevel()));
        }
        return answer;
    }

    @Deprecated
    private Processor createDeadLetterChannelProcessor(String uri) {
        SendProcessor child = new SendProcessor(this.camelContext.getEndpoint(uri), ExchangePattern.InOnly);
        return new FatalFallbackErrorHandler(child, true);
    }

    private RedeliveryPolicy resolveRedeliveryPolicy(DefaultErrorHandlerDefinition definition, CamelContext camelContext) {
        RedeliveryPolicyDefinition def;
        if (definition.hasRedeliveryPolicy() && definition.getRedeliveryPolicyRef() != null) {
            throw new IllegalArgumentException("Cannot have both redeliveryPolicy and redeliveryPolicyRef set at the same time.");
        }
        RedeliveryPolicy answer = null;
        RedeliveryPolicyDefinition redeliveryPolicyDefinition = def = definition.hasRedeliveryPolicy() ? definition.getRedeliveryPolicy() : null;
        if (def != null) {
            answer = ErrorHandlerReifier.createRedeliveryPolicy(def, camelContext, null);
        }
        if (def == null && definition.getRedeliveryPolicyRef() != null) {
            answer = this.mandatoryLookup(definition.getRedeliveryPolicyRef(), RedeliveryPolicy.class);
        }
        if (answer == null) {
            answer = RedeliveryPolicy.DEFAULT_POLICY;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScheduledExecutorService getExecutorService(ScheduledExecutorService executorService, String executorServiceRef) {
        this.lock.lock();
        try {
            executorServiceRef = this.parseString(executorServiceRef);
            if (executorService == null || executorService.isShutdown()) {
                if (executorServiceRef != null) {
                    executorService = this.lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
                    if (executorService == null) {
                        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                        ThreadPoolProfile profile2 = manager.getThreadPoolProfile(executorServiceRef);
                        executorService = manager.newScheduledThreadPool((Object)this, executorServiceRef, profile2);
                    }
                    if (executorService == null) {
                        throw new IllegalArgumentException("ExecutorService " + executorServiceRef + " not found in registry.");
                    }
                } else {
                    executorService = null;
                }
            }
            ScheduledExecutorService scheduledExecutorService = executorService;
            return scheduledExecutorService;
        }
        finally {
            this.lock.unlock();
        }
    }
}

